/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.parameterInfo.custom;

import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.parameterInfo.HintType;
import org.jetbrains.kotlin.idea.parameterInfo.custom.KotlinCodeHintsModel;
import org.jetbrains.kotlin.idea.util.EditorsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/parameterInfo/custom/DisableReturnLambdaHintOptionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "idea"})
public final class DisableReturnLambdaHintOptionAction
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        return HintType.LAMBDA_RETURN_EXPRESSION.getDoNotShowDesc();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (Intrinsics.areEqual((Object)file2.getLanguage(), (Object)((Object)KotlinLanguage.INSTANCE)) ^ true) {
            return false;
        }
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage()) == null) {
            return false;
        }
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
        if (!editorSettingsExternalizable.isShowParameterNameHints() || !HintType.LAMBDA_RETURN_EXPRESSION.getEnabled()) {
            return false;
        }
        return KotlinCodeHintsModel.Companion.getInstance(project2).getExtensionInfoAtOffset(editor2) != null;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        HintType.LAMBDA_RETURN_EXPRESSION.getOption().set(false);
        EditorsKt.refreshAllOpenEditors();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

