/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.parameterInfo.custom;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.RangeUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0007J\"\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\u001cR/\u0010\u0005\u001a#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/parameterInfo/custom/KotlinCodeHintsModel;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "documentModels", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/editor/Document;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/parameterInfo/custom/KotlinCodeHintsModel$DocumentExtensionInfoModel;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "editorReleased", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "getExtensionInfo", "", "document", "offset", "", "getExtensionInfoAtOffset", "editor", "Lcom/intellij/openapi/editor/Editor;", "removeAll", "update", "actualHints", "", "Lcom/intellij/psi/PsiElement;", "Companion", "DocumentExtensionInfoModel", "idea"})
public final class KotlinCodeHintsModel
implements EditorFactoryListener {
    private final ConcurrentMap<Document, DocumentExtensionInfoModel> documentModels;
    @NotNull
    private final Project project;
    public static final Companion Companion = new Companion(null);

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Editor editor2 = event.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"event.editor");
        Document document = editor2.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"event.editor.document");
        this.removeAll(document);
    }

    @Nullable
    public final String getExtensionInfoAtOffset(@NotNull Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Document document = editor2.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        return this.getExtensionInfo(document, caretModel.getOffset());
    }

    @Nullable
    public final String getExtensionInfo(@NotNull Document document, int offset2) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        DocumentExtensionInfoModel documentExtensionInfoModel = (DocumentExtensionInfoModel)this.documentModels.get(document);
        return documentExtensionInfoModel != null ? documentExtensionInfoModel.getExtensionAtOffset(offset2) : null;
    }

    public final void removeAll(@NotNull Document document) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            DocumentExtensionInfoModel documentExtensionInfoModel = (DocumentExtensionInfoModel)this.documentModels.remove(document);
            if (documentExtensionInfoModel == null) break block0;
            documentExtensionInfoModel.dispose();
        }
    }

    public final void update(@NotNull Document document, @NotNull Map<PsiElement, String> actualHints) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull(actualHints, (String)"actualHints");
            if (actualHints.isEmpty()) {
                this.removeAll(document);
                return;
            }
            DocumentExtensionInfoModel updatedModel2 = (DocumentExtensionInfoModel)ApplicationUtilsKt.runReadAction((Function0)new Function0<DocumentExtensionInfoModel>(document, actualHints){
                final /* synthetic */ Document $document;
                final /* synthetic */ Map $actualHints;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final DocumentExtensionInfoModel invoke() {
                    void var1_1;
                    DocumentExtensionInfoModel model2 = new DocumentExtensionInfoModel(this.$document);
                    Map map2 = this.$actualHints;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        void element3;
                        Map.Entry<K, V> entry;
                        Map.Entry<K, V> entry2 = entry = iterator2.next();
                        boolean bl2 = false;
                        map2 = (PsiElement)entry2.getKey();
                        entry2 = entry;
                        bl2 = false;
                        String hint = (String)entry2.getValue();
                        int lineNumber2 = this.$document.getLineNumber(PsiUtilsKt.getEndOffset((PsiElement)element3));
                        int lineEndOffset = this.$document.getLineEndOffset(lineNumber2);
                        model2.markEndOfLine(lineEndOffset, hint);
                    }
                    return var1_1;
                }
                {
                    this.$document = document;
                    this.$actualHints = map2;
                    super(0);
                }
            });
            DocumentExtensionInfoModel documentExtensionInfoModel = this.documentModels.put(document, updatedModel2);
            if (documentExtensionInfoModel == null) break block1;
            documentExtensionInfoModel.dispose();
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinCodeHintsModel(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026mentExtensionInfoModel>()");
        this.documentModels = concurrentMap;
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.addEditorFactoryListener((EditorFactoryListener)this, (Disposable)this.project);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/parameterInfo/custom/KotlinCodeHintsModel$DocumentExtensionInfoModel;", "", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/editor/Document;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "lineEndMarkers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/editor/RangeMarker;", "", "dispose", "", "getExtensionAtOffset", "offset", "", "markEndOfLine", "lineEndOffset", "hint", "idea"})
    private static final class DocumentExtensionInfoModel {
        private final ConcurrentHashMap<RangeMarker, String> lineEndMarkers;
        @NotNull
        private final Document document;

        public final void markEndOfLine(int lineEndOffset, @NotNull String hint) {
            Intrinsics.checkParameterIsNotNull((Object)hint, (String)"hint");
            RangeMarker rangeMarker = this.document.createRangeMarker(lineEndOffset, lineEndOffset);
            Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker, (String)"document.createRangeMark\u2026EndOffset, lineEndOffset)");
            RangeMarker endLineMarker = rangeMarker;
            endLineMarker.setGreedyToRight(true);
            ((Map)this.lineEndMarkers).put(endLineMarker, hint);
        }

        @Nullable
        public final String getExtensionAtOffset(int offset2) {
            return (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(this, offset2){
                final /* synthetic */ DocumentExtensionInfoModel this$0;
                final /* synthetic */ int $offset;

                @Nullable
                public final String invoke() {
                    Object v4;
                    block5: {
                        Set<Map.Entry<K, V>> set2 = DocumentExtensionInfoModel.access$getLineEndMarkers$p(this.this$0).entrySet();
                        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"lineEndMarkers\n                    .entries");
                        Iterable $this$firstOrNull$iv = set2;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            boolean bl;
                            RangeMarker marker;
                            Map.Entry $dstr$marker$_u24__u24 = (Map.Entry)element$iv;
                            boolean bl2 = false;
                            Map.Entry entry = $dstr$marker$_u24__u24;
                            boolean bl3 = false;
                            RangeMarker rangeMarker = marker = (RangeMarker)entry.getKey();
                            Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker, (String)"marker");
                            TextRange textRange = RangeUtilsKt.getRange(rangeMarker);
                            if (textRange == null || textRange.getStartOffset() > this.$offset || this.$offset > textRange.getEndOffset()) {
                                bl = false;
                            } else if (RangeUtilsKt.getEnd(textRange) > this.this$0.getDocument().getTextLength()) {
                                bl = false;
                            } else {
                                int originalLineNumber;
                                int currentOriginalLineEnd;
                                Document document;
                                Intrinsics.checkExpressionValueIsNotNull((Object)marker.getDocument(), (String)"marker.document");
                                String string = document.getText(textRange);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.getText(textRange)");
                                boolean hasNewLine = StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null);
                                bl = !hasNewLine ? textRange.getEndOffset() == this.$offset : (currentOriginalLineEnd = document.getLineEndOffset(originalLineNumber = document.getLineNumber(textRange.getStartOffset()))) == this.$offset;
                            }
                            if (!bl) continue;
                            v4 = element$iv;
                            break block5;
                        }
                        v4 = null;
                    }
                    Map.Entry entry = v4;
                    return entry != null ? (String)entry.getValue() : null;
                }
                {
                    this.this$0 = documentExtensionInfoModel;
                    this.$offset = n;
                    super(0);
                }
            });
        }

        public final void dispose() {
            Enumeration<RangeMarker> keys = this.lineEndMarkers.keys();
            ApplicationManager.getApplication().invokeLater(new Runnable(keys){
                final /* synthetic */ Enumeration $keys;

                public final void run() {
                    Enumeration enumeration = this.$keys;
                    Intrinsics.checkExpressionValueIsNotNull((Object)enumeration, (String)"keys");
                    Iterator iterator2 = CollectionsKt.iterator((Enumeration)enumeration);
                    while (iterator2.hasNext()) {
                        RangeMarker marker = (RangeMarker)iterator2.next();
                        marker.dispose();
                    }
                }
                {
                    this.$keys = enumeration;
                }
            });
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        public DocumentExtensionInfoModel(@NotNull Document document) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            this.document = document;
            this.lineEndMarkers = new ConcurrentHashMap();
        }

        public static final /* synthetic */ ConcurrentHashMap access$getLineEndMarkers$p(DocumentExtensionInfoModel $this) {
            return $this.lineEndMarkers;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/parameterInfo/custom/KotlinCodeHintsModel$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/parameterInfo/custom/KotlinCodeHintsModel;", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
    public static final class Companion {
        @NotNull
        public final KotlinCodeHintsModel getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            KotlinCodeHintsModel kotlinCodeHintsModel = (KotlinCodeHintsModel)project2.getComponent(KotlinCodeHintsModel.class);
            if (kotlinCodeHintsModel == null) {
                String string = "Component `KotlinCodeHintsModel` is expected to be registered";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return kotlinCodeHintsModel;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

