/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.parameterInfo.custom;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.parameterInfo.custom.KotlinCodeHintsModel;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/parameterInfo/custom/ReturnHintLinePainter;", "Lcom/intellij/openapi/editor/EditorLinePainter;", "()V", "getLineExtensions", "", "Lcom/intellij/openapi/editor/LineExtensionInfo;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineNumber", "", "getLineHint", "", "Companion", "idea"})
public final class ReturnHintLinePainter
extends EditorLinePainter {
    @NotNull
    private static final LineExtensionInfo SPACE_LINE_EXTENSION_INFO;
    public static final Companion Companion;

    @Nullable
    public List<LineExtensionInfo> getLineExtensions(@NotNull Project project2, @NotNull VirtualFile file2, int lineNumber2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!file2.isValid()) {
            return null;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
        if (psiFile2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"PsiManager.getInstance(p\u2026File(file) ?: return null");
        PsiFile psiFile3 = psiFile2;
        if (Intrinsics.areEqual((Object)psiFile3.getLanguage(), (Object)((Object)KotlinLanguage.INSTANCE)) ^ true) {
            return null;
        }
        String string = this.getLineHint(project2, file2, lineNumber2);
        if (string == null) {
            return null;
        }
        String hint = string;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        TextAttributes textAttributes = editorColorsManager.getGlobalScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
        LineExtensionInfo hintLineInfo = new LineExtensionInfo(hint, textAttributes);
        return CollectionsKt.listOf((Object[])new LineExtensionInfo[]{SPACE_LINE_EXTENSION_INFO, hintLineInfo});
    }

    private final String getLineHint(Project project2, VirtualFile file2, int lineNumber2) {
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026ment(file) ?: return null");
        Document doc = document;
        if (lineNumber2 >= doc.getLineCount()) {
            return null;
        }
        int lineEndOffset = doc.getLineEndOffset(lineNumber2);
        return KotlinCodeHintsModel.Companion.getInstance(project2).getExtensionInfo(doc, lineEndOffset);
    }

    static {
        Companion = new Companion(null);
        SPACE_LINE_EXTENSION_INFO = new LineExtensionInfo(" ", new TextAttributes());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/parameterInfo/custom/ReturnHintLinePainter$Companion;", "", "()V", "SPACE_LINE_EXTENSION_INFO", "Lcom/intellij/openapi/editor/LineExtensionInfo;", "getSPACE_LINE_EXTENSION_INFO", "()Lcom/intellij/openapi/editor/LineExtensionInfo;", "idea"})
    public static final class Companion {
        @NotNull
        public final LineExtensionInfo getSPACE_LINE_EXTENSION_INFO() {
            return SPACE_LINE_EXTENSION_INFO;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

