/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddConstructorParameterFromSuperTypeCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "constructor", "parameterName", "", "parameterType", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/psi/KtValueArgumentList;Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class AddConstructorParameterFromSuperTypeCallFix
extends KotlinQuickFixAction<KtValueArgumentList> {
    private final String parameterName;
    private final FqName parameterType;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.add.constructor.parameter", this.parameterName);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)this.getElement();
            if (ktValueArgumentList == null) {
                return;
            }
            KtValueArgumentList superTypeCallArgList = ktValueArgumentList;
            KtElementImplStub ktElementImplStub = KtPsiUtilKt.containingClass(superTypeCallArgList);
            if (ktElementImplStub == null || (ktElementImplStub = KtClassKt.createPrimaryConstructorIfAbsent((KtClass)ktElementImplStub)) == null || (ktElementImplStub = ((KtConstructor)ktElementImplStub).getValueParameterList()) == null) {
                return;
            }
            KtElementImplStub constructorParamList = ktElementImplStub;
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)superTypeCallArgList, false, 2, null);
            KtParameter ktParameter = ((KtParameterList)constructorParamList).addParameter(psiFactory.createParameter(this.parameterName + ": " + RenderingUtilsKt.render(this.parameterType)));
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"constructorParamList.add\u2026arameterType.render()}\"))");
            KtParameter constructorParam = ktParameter;
            KtValueArgument ktValueArgument = superTypeCallArgList.addArgument(psiFactory.createArgument(this.parameterName));
            Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgument, (String)"superTypeCallArgList.add\u2026eArgument(parameterName))");
            KtValueArgument superTypeCallArg = ktValueArgument;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, constructorParam, null, 2, null);
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block2;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)superTypeCallArg));
        }
    }

    public AddConstructorParameterFromSuperTypeCallFix(@NotNull KtValueArgumentList constructor2, @NotNull String parameterName2, @NotNull FqName parameterType) {
        Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
        Intrinsics.checkParameterIsNotNull((Object)parameterName2, (String)"parameterName");
        Intrinsics.checkParameterIsNotNull((Object)parameterType, (String)"parameterType");
        super((PsiElement)constructor2);
        this.parameterName = parameterName2;
        this.parameterType = parameterType;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddConstructorParameterFromSuperTypeCallFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtValueArgumentList> createAction(@NotNull Diagnostic diagnostic) {
            boolean bl;
            String parameterName2;
            ValueParameterDescriptor parameter;
            KtValueArgumentList superTypeCallArgList;
            block12: {
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                PsiElement psiElement2 = diagnostic.getPsiElement();
                if (!(psiElement2 instanceof KtValueArgumentList)) {
                    psiElement2 = null;
                }
                KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement2;
                if (ktValueArgumentList == null) {
                    return null;
                }
                superTypeCallArgList = ktValueArgumentList;
                PsiElement psiElement3 = superTypeCallArgList.getParent();
                if (!(psiElement3 instanceof KtSuperTypeCallEntry)) {
                    psiElement3 = null;
                }
                KtSuperTypeCallEntry ktSuperTypeCallEntry = (KtSuperTypeCallEntry)psiElement3;
                if (ktSuperTypeCallEntry == null) {
                    return null;
                }
                KtSuperTypeCallEntry superTypeCall = ktSuperTypeCallEntry;
                KtClass ktClass2 = KtPsiUtilKt.containingClass(superTypeCall);
                if (ktClass2 == null) {
                    return null;
                }
                KtClass containingClass2 = ktClass2;
                Object d = DiagnosticFactory.cast(diagnostic, Errors.NO_VALUE_FOR_PARAMETER);
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"DiagnosticFactory.cast(d\u2026s.NO_VALUE_FOR_PARAMETER)");
                Object a = ((DiagnosticWithParameters1)d).getA();
                Intrinsics.checkExpressionValueIsNotNull(a, (String)"DiagnosticFactory.cast(d\u2026NO_VALUE_FOR_PARAMETER).a");
                parameter = (ValueParameterDescriptor)a;
                if (parameter.getIndex() != superTypeCallArgList.getArguments().size()) {
                    return null;
                }
                Name name2 = parameter.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"parameter.name");
                parameterName2 = RenderingUtilsKt.render(name2);
                Object object = ResolutionUtils.resolveToDescriptorIfAny((KtClassOrObject)containingClass2, (BodyResolveMode)BodyResolveMode.PARTIAL);
                if (object == null || (object = object.getConstructors()) == null || (object = (ClassConstructorDescriptor)CollectionsKt.firstOrNull((Iterable)((Iterable)object))) == null) {
                    return null;
                }
                Object constructor2 = object;
                List<ValueParameterDescriptor> list2 = constructor2.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"constructor.valueParameters");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                        boolean bl2 = false;
                        ValueParameterDescriptor valueParameterDescriptor = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
                        if (!Intrinsics.areEqual((Object)valueParameterDescriptor.getName().asString(), (Object)parameterName2)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            Object object = parameter.getType().getConstructor().getDeclarationDescriptor();
            if (object == null || (object = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object)) == null) {
                return null;
            }
            Object parameterType = object;
            return new AddConstructorParameterFromSuperTypeCallFix(superTypeCallArgList, parameterName2, (FqName)parameterType);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

