/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForExistingElement;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.Mover;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesModel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/Model;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "openInEditorCheckBox", "", "selectedElementsToMove", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "originalClass", "targetClass", "Lcom/intellij/psi/PsiElement;", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "(Lcom/intellij/openapi/project/Project;ZLjava/util/List;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/move/MoveCallback;)V", "getMoveCallback", "()Lcom/intellij/refactoring/move/MoveCallback;", "getOpenInEditorCheckBox", "()Z", "getOriginalClass", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSelectedElementsToMove", "()Ljava/util/List;", "getTargetClass", "()Lcom/intellij/psi/PsiElement;", "computeModelResult", "throwOnConflicts", "getCheckedTargetClass", "Lorg/jetbrains/kotlin/psi/KtElement;", "idea"})
public final class MoveKotlinNestedClassesModel
implements Model<MoveKotlinDeclarationsProcessor> {
    @NotNull
    private final Project project;
    private final boolean openInEditorCheckBox;
    @NotNull
    private final List<KtClassOrObject> selectedElementsToMove;
    @NotNull
    private final KtClassOrObject originalClass;
    @Nullable
    private final PsiElement targetClass;
    @Nullable
    private final MoveCallback moveCallback;

    private final KtElement getCheckedTargetClass() {
        PsiElement psiElement2 = this.targetClass;
        if (psiElement2 == null) {
            throw (Throwable)new ConfigurationException(RefactoringBundle.message((String)"no.destination.class.specified"));
        }
        PsiElement targetClass = psiElement2;
        if (!(targetClass instanceof KtClassOrObject)) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.destination.class.should.be.kotlin.class", new Object[0]));
        }
        if (this.originalClass == targetClass) {
            throw (Throwable)new ConfigurationException(RefactoringBundle.message((String)"source.and.destination.classes.should.be.different"));
        }
        for (KtClassOrObject classOrObject : this.selectedElementsToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)classOrObject, (PsiElement)targetClass, (boolean)false)) continue;
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.cannot.move.inner.class.0.into.itself", String.valueOf(classOrObject.getName())));
        }
        return (KtElement)targetClass;
    }

    @Override
    @NotNull
    public MoveKotlinDeclarationsProcessor computeModelResult() throws ConfigurationException {
        return this.computeModelResult(false);
    }

    @Override
    @NotNull
    public MoveKotlinDeclarationsProcessor computeModelResult(boolean throwOnConflicts) throws ConfigurationException {
        List<KtClassOrObject> elementsToMove = this.selectedElementsToMove;
        KotlinMoveTargetForExistingElement target = new KotlinMoveTargetForExistingElement(this.getCheckedTargetClass());
        MoveDeclarationsDelegate.NestedClass delegate2 = new MoveDeclarationsDelegate.NestedClass(null, null, 3, null);
        MoveDeclarationsDescriptor descriptor2 = new MoveDeclarationsDescriptor(this.project, MoveKotlinDeclarationsProcessorKt.MoveSource((Collection<? extends KtNamedDeclaration>)elementsToMove), target, delegate2, false, false, false, this.moveCallback, this.openInEditorCheckBox, null, false, false, 3584, null);
        return new MoveKotlinDeclarationsProcessor(descriptor2, Mover.Default.INSTANCE, throwOnConflicts);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getOpenInEditorCheckBox() {
        return this.openInEditorCheckBox;
    }

    @NotNull
    public final List<KtClassOrObject> getSelectedElementsToMove() {
        return this.selectedElementsToMove;
    }

    @NotNull
    public final KtClassOrObject getOriginalClass() {
        return this.originalClass;
    }

    @Nullable
    public final PsiElement getTargetClass() {
        return this.targetClass;
    }

    @Nullable
    public final MoveCallback getMoveCallback() {
        return this.moveCallback;
    }

    public MoveKotlinNestedClassesModel(@NotNull Project project2, boolean openInEditorCheckBox, @NotNull List<? extends KtClassOrObject> selectedElementsToMove, @NotNull KtClassOrObject originalClass, @Nullable PsiElement targetClass, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(selectedElementsToMove, (String)"selectedElementsToMove");
        Intrinsics.checkParameterIsNotNull((Object)originalClass, (String)"originalClass");
        this.project = project2;
        this.openInEditorCheckBox = openInEditorCheckBox;
        this.selectedElementsToMove = selectedElementsToMove;
        this.originalClass = originalClass;
        this.targetClass = targetClass;
        this.moveCallback = moveCallback;
    }
}

