/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.run.JvmTestClassUtilsKt;
import org.jetbrains.kotlin.idea.run.KotlinJUnitRunConfigurationProducer;
import org.jetbrains.kotlin.idea.run.KotlinTestNgConfigurationProducer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0000\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\u0012H\u0000\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0000\u0010\u0002\"\u001b\u0010\u0005\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0004\u001a\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0013"}, d2={"isJUnitEnabled", "", "()Z", "isJUnitEnabled$delegate", "Lkotlin/Lazy;", "isTestNgEnabled", "isTestNgEnabled$delegate", "canRunJvmTests", "getTestClassForJvm", "Lcom/intellij/psi/PsiClass;", "location", "Lcom/intellij/execution/Location;", "getTestMethodForJvm", "Lcom/intellij/psi/PsiMethod;", "isPluginEnabled", "id", "", "isJpsJunitConfiguration", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "idea-gradle"})
public final class JvmTestClassUtilsKt {
    private static final Lazy isJUnitEnabled$delegate = LazyKt.lazy((Function0)isJUnitEnabled.2.INSTANCE);
    private static final Lazy isTestNgEnabled$delegate = LazyKt.lazy((Function0)isTestNgEnabled.2.INSTANCE);

    private static final boolean isJUnitEnabled() {
        Lazy lazy = isJUnitEnabled$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    private static final boolean isTestNgEnabled() {
        Lazy lazy = isTestNgEnabled$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    private static final boolean isPluginEnabled(String id) {
        return PluginManagerCore.isPluginInstalled((PluginId)PluginId.getId((String)id)) && !PluginManagerCore.isDisabled((String)id);
    }

    public static final boolean isJpsJunitConfiguration(@NotNull ConfigurationFromContext $this$isJpsJunitConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isJpsJunitConfiguration, (String)"$this$isJpsJunitConfiguration");
        return $this$isJpsJunitConfiguration.isProducedBy(JUnitConfigurationProducer.class) || $this$isJpsJunitConfiguration.isProducedBy(AbstractPatternBasedConfigurationProducer.class);
    }

    public static final boolean canRunJvmTests() {
        return JvmTestClassUtilsKt.isJUnitEnabled() || JvmTestClassUtilsKt.isTestNgEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiClass getTestClassForJvm(@NotNull Location<?> location2) {
        Intrinsics.checkParameterIsNotNull(location2, (String)"location");
        PsiElement psiElement2 = location2.getPsiElement();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement leaf = psiElement2;
        if (JvmTestClassUtilsKt.isJUnitEnabled()) {
            PsiClass psiClass2 = KotlinJUnitRunConfigurationProducer.Companion.getTestClass(leaf);
            if (psiClass2 != null) {
                PsiClass psiClass3 = psiClass2;
                boolean bl = false;
                boolean bl2 = false;
                PsiClass it = psiClass3;
                boolean bl3 = false;
                return it;
            }
        }
        if (JvmTestClassUtilsKt.isTestNgEnabled()) {
            Pair<PsiClass, PsiMethod> pair2 = KotlinTestNgConfigurationProducer.getTestClassAndMethod(leaf);
            if (pair2 != null) {
                void testClass;
                Pair<PsiClass, PsiMethod> pair3 = pair2;
                boolean bl = false;
                boolean bl4 = false;
                Pair<PsiClass, PsiMethod> $dstr$testClass$testMethod = pair3;
                boolean bl5 = false;
                PsiClass psiClass4 = (PsiClass)ExtensionsKt.component1($dstr$testClass$testMethod);
                PsiMethod testMethod = (PsiMethod)ExtensionsKt.component2($dstr$testClass$testMethod);
                return testMethod == null ? testClass : null;
            }
        }
        return null;
    }

    @Nullable
    public static final PsiMethod getTestMethodForJvm(@NotNull Location<?> location2) {
        PsiMethod psiMethod;
        Intrinsics.checkParameterIsNotNull(location2, (String)"location");
        PsiElement psiElement2 = location2.getPsiElement();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement leaf = psiElement2;
        if (JvmTestClassUtilsKt.isJUnitEnabled()) {
            PsiMethod psiMethod2 = KotlinJUnitRunConfigurationProducer.Companion.getTestMethod(leaf);
            if (psiMethod2 != null) {
                PsiMethod psiMethod3 = psiMethod2;
                boolean bl = false;
                boolean bl2 = false;
                PsiMethod it = psiMethod3;
                boolean bl3 = false;
                return it;
            }
        }
        if (JvmTestClassUtilsKt.isTestNgEnabled() && (psiMethod = KotlinTestNgConfigurationProducer.getTestClassAndMethod(leaf)) != null && (psiMethod = (PsiMethod)psiMethod.second) != null) {
            PsiMethod psiMethod4 = psiMethod;
            boolean bl = false;
            boolean bl4 = false;
            PsiMethod it = psiMethod4;
            boolean bl5 = false;
            return it;
        }
        return null;
    }

    public static final /* synthetic */ boolean access$isPluginEnabled(String id) {
        return JvmTestClassUtilsKt.isPluginEnabled(id);
    }
}

