/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.InlayHelperKt;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/InlayScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "toolWindowHandler", "(Lcom/intellij/openapi/fileEditor/TextEditor;Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;)V", "maxInsertOffset", "", "maxLineLength", "minSpaceCount", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "clearInlays", "editor", "createInlay", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "error", "message", "", "handle", "onFinish", "onStart", "printToToolWindow", "idea-jvm"})
public final class InlayScratchOutputHandler
implements ScratchOutputHandler {
    private final int maxLineLength = 120;
    private final int maxInsertOffset = 60;
    private final int minSpaceCount = 4;
    private final TextEditor textEditor;
    private final ScratchOutputHandler toolWindowHandler;

    @Override
    public void onStart(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.toolWindowHandler.onStart(file2);
    }

    @Override
    public void handle(@NotNull ScratchFile file2, @NotNull ScratchExpression expression2, @NotNull ScratchOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (StringsKt.isBlank((CharSequence)output.getText())) {
            return;
        }
        this.createInlay(file2, expression2, output);
        if (output.getType() == ScratchOutputType.ERROR) {
            this.toolWindowHandler.handle(file2, expression2, output);
        }
    }

    @Override
    public void error(@NotNull ScratchFile file2, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.toolWindowHandler.error(file2, message2);
    }

    @Override
    public void onFinish(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.toolWindowHandler.onFinish(file2);
    }

    @Override
    public void clear(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.clearInlays(this.textEditor);
        this.toolWindowHandler.clear(file2);
    }

    private final void createInlay(ScratchFile file2, ScratchExpression expression2, ScratchOutput output) {
        TransactionGuard.submitTransaction((Disposable)((Disposable)file2.getProject()), (Runnable)new Runnable(this, expression2, file2, output){
            final /* synthetic */ InlayScratchOutputHandler this$0;
            final /* synthetic */ ScratchExpression $expression;
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ ScratchOutput $output;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void spaceCount;
                Editor editor2 = InlayScratchOutputHandler.access$getTextEditor$p(this.this$0).getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"textEditor.editor");
                Editor editor3 = editor2;
                int line = this.$expression.getLineStart();
                int lineStartOffset = editor3.getDocument().getLineStartOffset(line);
                int lineEndOffset = editor3.getDocument().getLineEndOffset(line);
                int lineLength = lineEndOffset - lineStartOffset;
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = InlayScratchOutputHandler.access$maxLineLength(this.this$0, this.$file) - lineLength + InlayScratchOutputHandler.access$getMinSpaceCount$p(this.this$0);
                while (spaceCount.element + lineLength > InlayScratchOutputHandler.access$getMaxInsertOffset$p(this.this$0) && spaceCount.element > InlayScratchOutputHandler.access$getMinSpaceCount$p(this.this$0)) {
                    int n = spaceCount.element;
                    spaceCount.element = n + -1;
                }
                Function1<String, Unit> $fun$addInlay$1 = new Function1<String, Unit>(this, (Ref.IntRef)spaceCount, lineLength, editor3, lineEndOffset){
                    final /* synthetic */ createInlay.1 this$0;
                    final /* synthetic */ Ref.IntRef $spaceCount;
                    final /* synthetic */ int $lineLength;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ int $lineEndOffset;

                    public final void invoke(@NotNull String text2) {
                        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
                        String textBeforeNewLine = StringUtil.containsLineBreak((CharSequence)text2) ? StringsKt.substringBefore$default((String)text2, (String)"\n", null, (int)2, null) + "..." : text2;
                        Integer n = InlayScratchOutputHandler.access$getMaxLineLength$p(this.this$0.this$0) - this.$spaceCount.element - this.$lineLength;
                        boolean bl = false;
                        boolean bl2 = false;
                        int it = ((Number)n).intValue();
                        boolean bl3 = false;
                        Integer n2 = it > 5 ? n : null;
                        int maxInlayLength = n2 != null ? n2 : 5;
                        String string = StringUtil.shortenTextWithEllipsis((String)textBeforeNewLine, (int)maxInlayLength, (int)0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.shortenTextWi\u2026wLine, maxInlayLength, 0)");
                        String shortText = string;
                        if (Intrinsics.areEqual((Object)shortText, (Object)text2) ^ true) {
                            InlayScratchOutputHandler.access$printToToolWindow(this.this$0.this$0, this.this$0.$file, this.this$0.$expression, this.this$0.$output);
                        }
                        InlayModel inlayModel = this.$editor.getInlayModel();
                        Intrinsics.checkExpressionValueIsNotNull((Object)inlayModel, (String)"editor.inlayModel");
                        InlayHelperKt.addInlay(inlayModel, this.$lineEndOffset, new InlayScratchFileRenderer(StringsKt.repeat((CharSequence)" ", (int)this.$spaceCount.element) + shortText, this.this$0.$output.getType()));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$spaceCount = intRef;
                        this.$lineLength = n;
                        this.$editor = editor2;
                        this.$lineEndOffset = n2;
                        super(1);
                    }
                };
                InlayModel inlayModel = editor3.getInlayModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)inlayModel, (String)"editor.inlayModel");
                Inlay existing = (Inlay)CollectionsKt.singleOrNull(InlayHelperKt.getInlays(inlayModel, lineEndOffset, lineEndOffset));
                if (existing != null) {
                    existing.dispose();
                    EditorCustomElementRenderer editorCustomElementRenderer = existing.getRenderer();
                    if (editorCustomElementRenderer == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer");
                    }
                    $fun$addInlay$1.invoke(StringsKt.drop((String)(((InlayScratchFileRenderer)editorCustomElementRenderer).getText() + "; " + this.$output.getText()), (int)spaceCount.element));
                } else {
                    $fun$addInlay$1.invoke(this.$output.getText());
                }
            }
            {
                this.this$0 = inlayScratchOutputHandler;
                this.$expression = scratchExpression;
                this.$file = scratchFile;
                this.$output = scratchOutput;
            }
        });
    }

    private final void printToToolWindow(ScratchFile file2, ScratchExpression expression2, ScratchOutput output) {
        if (output.getType() != ScratchOutputType.ERROR) {
            this.toolWindowHandler.handle(file2, expression2, output);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int maxLineLength(ScratchFile file2) {
        void $this$mapTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Editor editor2 = this.textEditor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"textEditor.editor");
        Document document = editor2.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"textEditor.editor.document");
        Document doc = document;
        Iterable $this$flatMap$iv = file2.getExpressions();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ScratchExpression it = (ScratchExpression)element$iv$iv;
            boolean bl = false;
            int n = it.getLineStart();
            Iterable list$iv$iv = (Iterable)new IntRange(n, it.getLineEnd());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int list$iv$iv = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = doc.getLineEndOffset((int)it) - doc.getLineStartOffset((int)it);
            collection.add(n);
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv));
        return n != null ? n : 0;
    }

    private final void clearInlays(TextEditor editor2) {
        TransactionGuard.submitTransaction((Disposable)((Disposable)editor2), (Runnable)new Runnable(editor2){
            final /* synthetic */ TextEditor $editor;

            public final void run() {
                Editor editor2 = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor\n                .editor");
                InlayModel inlayModel = editor2.getInlayModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)inlayModel, (String)"editor\n                .editor.inlayModel");
                Editor editor3 = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
                Document document = editor3.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.editor.document");
                Iterable $this$forEach$iv = InlayHelperKt.getInlays(inlayModel, 0, document.getTextLength());
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Inlay it = (Inlay)element$iv;
                    boolean bl = false;
                    Disposer.dispose((Disposable)((Disposable)it));
                }
            }
            {
                this.$editor = textEditor;
            }
        });
    }

    public InlayScratchOutputHandler(@NotNull TextEditor textEditor, @NotNull ScratchOutputHandler toolWindowHandler) {
        Intrinsics.checkParameterIsNotNull((Object)textEditor, (String)"textEditor");
        Intrinsics.checkParameterIsNotNull((Object)toolWindowHandler, (String)"toolWindowHandler");
        this.textEditor = textEditor;
        this.toolWindowHandler = toolWindowHandler;
        this.maxLineLength = 120;
        this.maxInsertOffset = 60;
        this.minSpaceCount = 4;
    }

    public static final /* synthetic */ TextEditor access$getTextEditor$p(InlayScratchOutputHandler $this) {
        return $this.textEditor;
    }

    public static final /* synthetic */ int access$maxLineLength(InlayScratchOutputHandler $this, ScratchFile file2) {
        return $this.maxLineLength(file2);
    }

    public static final /* synthetic */ int access$getMinSpaceCount$p(InlayScratchOutputHandler $this) {
        return $this.minSpaceCount;
    }

    public static final /* synthetic */ int access$getMaxInsertOffset$p(InlayScratchOutputHandler $this) {
        return $this.maxInsertOffset;
    }

    public static final /* synthetic */ int access$getMaxLineLength$p(InlayScratchOutputHandler $this) {
        return $this.maxLineLength;
    }

    public static final /* synthetic */ void access$printToToolWindow(InlayScratchOutputHandler $this, ScratchFile file2, ScratchExpression expression2, ScratchOutput output) {
        $this.printToToolWindow(file2, expression2, output);
    }
}

