/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.stubindex.IndexUtilsKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinAnnotationsIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinExactPackagesIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFilePartClassIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileStubForIde;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinMultifileClassPartIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinProbablyContractedFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinProbablyNothingFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinProbablyNothingPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinScriptFqnIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinSuperClassIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasShortNameIndex;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.util.TypeIndexUtilKt;

public class IdeStubIndexService
extends StubIndexService {
    @Override
    public void indexFile(@NotNull KotlinFileStub stub, @NotNull IndexSink sink) {
        List<StringRef> partNames;
        FqName partFqName;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(0);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(1);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(1);
        }
        FqName packageFqName = stub.getPackageFqName();
        sink.occurrence(KotlinExactPackagesIndex.getInstance().getKey(), (Object)packageFqName.asString());
        if (stub.isScript()) {
            return;
        }
        FqName facadeFqName = ((KotlinFileStubForIde)stub).getFacadeFqName();
        if (facadeFqName != null) {
            sink.occurrence(KotlinFileFacadeFqNameIndex.INSTANCE.getKey(), (Object)facadeFqName.asString());
            sink.occurrence(KotlinFileFacadeShortNameIndex.INSTANCE.getKey(), (Object)facadeFqName.shortName().asString());
            sink.occurrence(KotlinFileFacadeClassByPackageIndex.INSTANCE.getKey(), (Object)packageFqName.asString());
        }
        if ((partFqName = ((KotlinFileStubForIde)stub).getPartFqName()) != null) {
            sink.occurrence(KotlinFilePartClassIndex.INSTANCE.getKey(), (Object)partFqName.asString());
        }
        if ((partNames = ((KotlinFileStubForIde)stub).getFacadePartSimpleNames()) != null) {
            for (StringRef partName : partNames) {
                String partSimpleName = StringRef.toString((StringRef)partName);
                if (partSimpleName == null) continue;
                FqName multiFileClassPartFqName = packageFqName.child(Name.identifier(partSimpleName));
                sink.occurrence(KotlinMultifileClassPartIndex.INSTANCE.getKey(), (Object)multiFileClassPartFqName.asString());
            }
        }
    }

    @Override
    public void indexClass(@NotNull KotlinClassStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(2);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(3);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(2);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(3);
        }
        IdeStubIndexService.processNames(sink, stub.getName(), stub.getFqName(), stub.isTopLevel());
        if (stub.isInterface()) {
            sink.occurrence(KotlinClassShortNameIndex.getInstance().getKey(), (Object)"DefaultImpls");
        }
        IdeStubIndexService.indexSuperNames(stub, sink);
    }

    @Override
    public void indexObject(@NotNull KotlinObjectStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(4);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(5);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(5);
        }
        IdeStubIndexService.processNames(sink, stub.getName(), stub.getFqName(), stub.isTopLevel());
        IdeStubIndexService.indexSuperNames(stub, sink);
    }

    private static void processNames(@NotNull IndexSink sink, String shortName, FqName fqName2, boolean level) {
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(6);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(6);
        }
        if (shortName != null) {
            sink.occurrence(KotlinClassShortNameIndex.getInstance().getKey(), (Object)shortName);
        }
        if (fqName2 != null) {
            sink.occurrence(KotlinFullClassNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            if (level) {
                sink.occurrence(KotlinTopLevelClassByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            }
        }
    }

    private static void indexSuperNames(KotlinClassOrObjectStub<? extends KtClassOrObject> stub, IndexSink sink) {
        for (String superName : stub.getSuperNames()) {
            sink.occurrence(KotlinSuperClassIndex.getInstance().getKey(), (Object)superName);
        }
        if (!(stub instanceof KotlinClassStub)) {
            return;
        }
        KotlinModifierListStub modifierListStub = IdeStubIndexService.getModifierListStub(stub);
        if (modifierListStub == null) {
            return;
        }
        if (modifierListStub.hasModifier(KtTokens.ENUM_KEYWORD)) {
            sink.occurrence(KotlinSuperClassIndex.getInstance().getKey(), (Object)Enum.class.getSimpleName());
        }
        if (modifierListStub.hasModifier(KtTokens.ANNOTATION_KEYWORD)) {
            sink.occurrence(KotlinSuperClassIndex.getInstance().getKey(), (Object)Annotation.class.getSimpleName());
        }
    }

    @Nullable
    private static KotlinModifierListStub getModifierListStub(@NotNull KotlinClassOrObjectStub<? extends KtClassOrObject> stub) {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(7);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(7);
        }
        return (KotlinModifierListStub)stub.findChildStubByType(KtStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public void indexFunction(@NotNull KotlinFunctionStub stub, @NotNull IndexSink sink) {
        FqName fqName2;
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(8);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(9);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(9);
        }
        if ((name2 = stub.getName()) != null) {
            sink.occurrence(KotlinFunctionShortNameIndex.getInstance().getKey(), (Object)name2);
            if (TypeIndexUtilKt.isProbablyNothing((KtTypeReference)((KtNamedFunction)stub.getPsi()).getTypeReference())) {
                sink.occurrence(KotlinProbablyNothingFunctionShortNameIndex.getInstance().getKey(), (Object)name2);
            }
            if (stub.mayHaveContract()) {
                sink.occurrence(KotlinProbablyContractedFunctionShortNameIndex.getInstance().getKey(), (Object)name2);
            }
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinTopLevelFunctionFqnNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(KotlinTopLevelFunctionByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            IndexUtilsKt.indexTopLevelExtension(stub, sink);
        }
        IndexUtilsKt.indexInternals(stub, sink);
    }

    @Override
    public void indexTypeAlias(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        FqName fqName2;
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(10);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(11);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(11);
        }
        if ((name2 = stub.getName()) != null) {
            sink.occurrence(KotlinTypeAliasShortNameIndex.getInstance().getKey(), (Object)name2);
        }
        IndexUtilsKt.indexTypeAliasExpansion(stub, sink);
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinTopLevelTypeAliasFqNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(KotlinTopLevelTypeAliasByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
        }
    }

    @Override
    public void indexProperty(@NotNull KotlinPropertyStub stub, @NotNull IndexSink sink) {
        FqName fqName2;
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(12);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(13);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(12);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(13);
        }
        if ((name2 = stub.getName()) != null) {
            sink.occurrence(KotlinPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
            if (TypeIndexUtilKt.isProbablyNothing((KtTypeReference)((KtProperty)stub.getPsi()).getTypeReference())) {
                sink.occurrence(KotlinProbablyNothingPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
            }
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(KotlinTopLevelPropertyFqnNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(KotlinTopLevelPropertyByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            IndexUtilsKt.indexTopLevelExtension(stub, sink);
        }
        IndexUtilsKt.indexInternals(stub, sink);
    }

    @Override
    public void indexParameter(@NotNull KotlinParameterStub stub, @NotNull IndexSink sink) {
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(14);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(15);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(14);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(15);
        }
        if ((name2 = stub.getName()) != null && stub.hasValOrVar()) {
            sink.occurrence(KotlinPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
        }
    }

    @Override
    public void indexAnnotation(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        String name2;
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(16);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(17);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(16);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(17);
        }
        if ((name2 = stub.getShortName()) == null) {
            return;
        }
        sink.occurrence(KotlinAnnotationsIndex.getInstance().getKey(), (Object)name2);
        KotlinFileStub fileStub = IdeStubIndexService.getContainingFileStub(stub);
        if (fileStub != null) {
            List<KotlinImportDirectiveStub> aliasImportStubs = fileStub.findImportsByAlias(name2);
            for (KotlinImportDirectiveStub importStub : aliasImportStubs) {
                FqName importedFqName = importStub.getImportedFqName();
                if (importedFqName == null) continue;
                sink.occurrence(KotlinAnnotationsIndex.getInstance().getKey(), (Object)importedFqName.shortName().asString());
            }
        }
    }

    private static KotlinFileStub getContainingFileStub(StubElement stub) {
        for (StubElement parent2 = stub.getParentStub(); parent2 != null; parent2 = parent2.getParentStub()) {
            if (!(parent2 instanceof KotlinFileStub)) continue;
            return (KotlinFileStub)parent2;
        }
        return null;
    }

    @Override
    public void indexScript(@NotNull KotlinScriptStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(18);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$1(19);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(18);
        }
        if (sink == null) {
            IdeStubIndexService.$$$reportNull$$$0(19);
        }
        sink.occurrence(KotlinScriptFqnIndex.getInstance().getKey(), (Object)stub.getFqName().asString());
    }

    @Override
    @NotNull
    public KotlinFileStub createFileStub(@NotNull KtFile file2) {
        if (file2 == null) {
            IdeStubIndexService.$$$reportNull$$$1(20);
        }
        if (file2 == null) {
            IdeStubIndexService.$$$reportNull$$$0(20);
        }
        StringRef packageFqName = StringRef.fromString((String)file2.getPackageFqNameByTree().asString());
        boolean isScript = file2.isScriptByTree();
        if (file2.hasTopLevelCallables()) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(file2);
            StringRef facadeFqNameRef = StringRef.fromString((String)fileClassInfo.getFacadeClassFqName().asString());
            StringRef partSimpleName = StringRef.fromString((String)fileClassInfo.getFileClassFqName().shortName().asString());
            return new KotlinFileStubForIde(file2, packageFqName, isScript, facadeFqNameRef, partSimpleName, null);
        }
        return new KotlinFileStubForIde(file2, packageFqName, isScript, null, null, null);
    }

    @Override
    public void serializeFileStub(@NotNull KotlinFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$1(21);
        }
        if (dataStream == null) {
            IdeStubIndexService.$$$reportNull$$$1(22);
        }
        if (stub == null) {
            IdeStubIndexService.$$$reportNull$$$0(21);
        }
        if (dataStream == null) {
            IdeStubIndexService.$$$reportNull$$$0(22);
        }
        KotlinFileStubForIde fileStub = (KotlinFileStubForIde)stub;
        dataStream.writeName(fileStub.getPackageFqName().asString());
        dataStream.writeBoolean(fileStub.isScript());
        FqName facadeFqName = fileStub.getFacadeFqName();
        dataStream.writeName(facadeFqName != null ? facadeFqName.asString() : null);
        dataStream.writeName(StringRef.toString((StringRef)fileStub.getPartSimpleName()));
        List<StringRef> facadePartNames = fileStub.getFacadePartSimpleNames();
        if (facadePartNames == null) {
            dataStream.writeInt(0);
        } else {
            dataStream.writeInt(facadePartNames.size());
            for (StringRef partName : facadePartNames) {
                dataStream.writeName(StringRef.toString((StringRef)partName));
            }
        }
    }

    @Override
    @NotNull
    public KotlinFileStub deserializeFileStub(@NotNull StubInputStream dataStream) throws IOException {
        StringRef packageFqNameAsString;
        if (dataStream == null) {
            IdeStubIndexService.$$$reportNull$$$1(23);
        }
        if (dataStream == null) {
            IdeStubIndexService.$$$reportNull$$$0(23);
        }
        if ((packageFqNameAsString = dataStream.readName()) == null) {
            throw new IllegalStateException("Can't read package fqname from stream");
        }
        boolean isScript = dataStream.readBoolean();
        StringRef facadeStringRef = dataStream.readName();
        StringRef partSimpleName = dataStream.readName();
        int numPartNames = dataStream.readInt();
        ArrayList<StringRef> facadePartNames = new ArrayList<StringRef>();
        for (int i2 = 0; i2 < numPartNames; ++i2) {
            StringRef partNameRef = dataStream.readName();
            facadePartNames.add(partNameRef);
        }
        return new KotlinFileStubForIde(null, packageFqNameAsString, isScript, facadeStringRef, partSimpleName, facadePartNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "indexFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "indexClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "indexObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getModifierListStub";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "indexFunction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "indexTypeAlias";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "indexProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "indexParameter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "indexAnnotation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "indexScript";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileStub";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "serializeFileStub";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "deserializeFileStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "indexFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "indexClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "indexObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getModifierListStub";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "indexFunction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "indexTypeAlias";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "indexProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "indexParameter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "indexAnnotation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "indexScript";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileStub";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "serializeFileStub";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "deserializeFileStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

