/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.UtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0002*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"typeConversionMap", "", "", "getTypeConversionMethod", "Lcom/intellij/psi/PsiExpression;", "expectedType", "Lcom/intellij/psi/PsiType;", "isMainMethodParameter", "", "Lcom/intellij/psi/PsiVariable;", "needTypeConversion", "expected", "j2k"})
public final class TypeConverterKt {
    private static final Map<String, String> typeConversionMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"java.lang.Byte", (Object)"byte"), TuplesKt.to((Object)"java.lang.Short", (Object)"short"), TuplesKt.to((Object)"java.lang.Integer", (Object)"int"), TuplesKt.to((Object)"java.lang.Long", (Object)"long"), TuplesKt.to((Object)"java.lang.Float", (Object)"float"), TuplesKt.to((Object)"java.lang.Double", (Object)"double"), TuplesKt.to((Object)"java.lang.Character", (Object)"char")});

    @Nullable
    public static final String getTypeConversionMethod(@NotNull PsiExpression $this$getTypeConversionMethod, @NotNull PsiType expectedType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getTypeConversionMethod, (String)"$this$getTypeConversionMethod");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        PsiType psiType2 = $this$getTypeConversionMethod.getType();
        if (psiType2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType2, (String)"this.type ?: return null");
        PsiType actualType = psiType2;
        if (Intrinsics.areEqual((Object)actualType, (Object)expectedType)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)expectedType.getCanonicalText(), (Object)"java.lang.String")) {
            return "toString";
        }
        PsiType psiType3 = expectedType;
        return Intrinsics.areEqual((Object)psiType3, (Object)PsiType.BYTE) ? "toByte" : (Intrinsics.areEqual((Object)psiType3, (Object)PsiType.SHORT) ? "toShort" : (Intrinsics.areEqual((Object)psiType3, (Object)PsiType.INT) ? "toInt" : (Intrinsics.areEqual((Object)psiType3, (Object)PsiType.LONG) ? "toLong" : (Intrinsics.areEqual((Object)psiType3, (Object)PsiType.FLOAT) ? "toFloat" : (Intrinsics.areEqual((Object)psiType3, (Object)PsiType.DOUBLE) ? "toDouble" : (Intrinsics.areEqual((Object)psiType3, (Object)PsiType.CHAR) ? "toChar" : null))))));
    }

    public static final boolean needTypeConversion(@NotNull PsiType $this$needTypeConversion, @NotNull PsiType expected) {
        Intrinsics.checkParameterIsNotNull((Object)$this$needTypeConversion, (String)"$this$needTypeConversion");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        String string = expected.getCanonicalText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expected.canonicalText");
        String expectedStr = string;
        String string2 = $this$needTypeConversion.getCanonicalText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"canonicalText");
        String actualStr = string2;
        return Intrinsics.areEqual((Object)expectedStr, (Object)actualStr) ^ true && Intrinsics.areEqual((Object)expectedStr, (Object)typeConversionMap.get(actualStr)) ^ true && Intrinsics.areEqual((Object)actualStr, (Object)typeConversionMap.get(expectedStr)) ^ true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isMainMethodParameter(@NotNull PsiVariable $this$isMainMethodParameter) {
        if (!($this$isMainMethodParameter instanceof PsiParameter)) return false;
        PsiElement psiElement2 = ((PsiParameter)$this$isMainMethodParameter).getDeclarationScope();
        if (!(psiElement2 instanceof PsiMethod)) {
            psiElement2 = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement2;
        if (psiMethod == null) return false;
        boolean bl = UtilsKt.isMainMethod(psiMethod);
        if (!bl) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isMainMethodParameter(PsiVariable $this$access_u24isMainMethodParameter) {
        return TypeConverterKt.isMainMethodParameter($this$access_u24isMainMethodParameter);
    }
}

