/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.QualifiedExpression;
import org.jetbrains.kotlin.j2k.ast.ThisExpression;
import org.jetbrains.kotlin.j2k.usageProcessing.ConvertedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ElementRenamedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ExternalCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.UsageProcessing;
import org.jetbrains.kotlin.j2k.usageProcessing.UseAccessorsJavaCodeProcessor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/UsageProcessing;", "field", "Lcom/intellij/psi/PsiField;", "propertyName", "", "isNullable", "", "replaceReadWithFieldReference", "replaceWriteWithFieldReference", "(Lcom/intellij/psi/PsiField;Ljava/lang/String;ZZZ)V", "convertedCodeProcessor", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "getConvertedCodeProcessor", "()Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "javaCodeProcessors", "", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "getJavaCodeProcessors", "()Ljava/util/List;", "setJavaCodeProcessors", "(Ljava/util/List;)V", "kotlinCodeProcessors", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ElementRenamedCodeProcessor;", "getKotlinCodeProcessors", "targetElement", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "()Lcom/intellij/psi/PsiElement;", "MyConvertedCodeProcessor", "j2k"})
public final class FieldToPropertyProcessing
implements UsageProcessing {
    @Nullable
    private final ConvertedCodeProcessor convertedCodeProcessor;
    @NotNull
    private List<? extends ExternalCodeProcessor> javaCodeProcessors;
    @NotNull
    private final List<ElementRenamedCodeProcessor> kotlinCodeProcessors;
    private final PsiField field;
    private final String propertyName;
    private final boolean isNullable;
    private final boolean replaceReadWithFieldReference;
    private final boolean replaceWriteWithFieldReference;

    @Override
    @NotNull
    public PsiElement getTargetElement() {
        return (PsiElement)this.field;
    }

    @Override
    @Nullable
    public ConvertedCodeProcessor getConvertedCodeProcessor() {
        return this.convertedCodeProcessor;
    }

    @Override
    @NotNull
    public List<ExternalCodeProcessor> getJavaCodeProcessors() {
        return this.javaCodeProcessors;
    }

    public void setJavaCodeProcessors(@NotNull List<? extends ExternalCodeProcessor> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
        this.javaCodeProcessors = list2;
    }

    @NotNull
    public List<ElementRenamedCodeProcessor> getKotlinCodeProcessors() {
        return this.kotlinCodeProcessors;
    }

    public FieldToPropertyProcessing(@NotNull PsiField field2, @NotNull String propertyName, boolean isNullable2, boolean replaceReadWithFieldReference, boolean replaceWriteWithFieldReference) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        this.field = field2;
        this.propertyName = propertyName;
        this.isNullable = isNullable2;
        this.replaceReadWithFieldReference = replaceReadWithFieldReference;
        this.replaceWriteWithFieldReference = replaceWriteWithFieldReference;
        this.convertedCodeProcessor = Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ^ true || this.replaceReadWithFieldReference || this.replaceWriteWithFieldReference ? new MyConvertedCodeProcessor() : null;
        if (this.field.hasModifierProperty("private")) {
            list2 = CollectionsKt.emptyList();
        } else if (Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ^ true) {
            Object[] objectArray = new ExternalCodeProcessor[2];
            objectArray[0] = new ElementRenamedCodeProcessor(this.propertyName);
            PsiElementFactory psiElementFactory = PsiElementFactory.SERVICE.getInstance((Project)this.field.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementFactory, (String)"PsiElementFactory.SERVIC\u2026etInstance(field.project)");
            objectArray[1] = new UseAccessorsJavaCodeProcessor(psiElementFactory, this.propertyName);
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            PsiElementFactory psiElementFactory = PsiElementFactory.SERVICE.getInstance((Project)this.field.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementFactory, (String)"PsiElementFactory.SERVIC\u2026etInstance(field.project)");
            list2 = CollectionsKt.listOf((Object)new UseAccessorsJavaCodeProcessor(psiElementFactory, this.propertyName));
        }
        this.javaCodeProcessors = list2;
        this.kotlinCodeProcessors = Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ^ true ? CollectionsKt.listOf((Object)new ElementRenamedCodeProcessor(this.propertyName)) : CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing$MyConvertedCodeProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "(Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing;)V", "convertVariableUsage", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "expression", "Lcom/intellij/psi/PsiReferenceExpression;", "codeConverter", "Lorg/jetbrains/kotlin/j2k/CodeConverter;", "j2k"})
    private final class MyConvertedCodeProcessor
    implements ConvertedCodeProcessor {
        @Override
        @Nullable
        public Expression convertVariableUsage(@NotNull PsiReferenceExpression expression2, @NotNull CodeConverter codeConverter) {
            PsiReferenceExpression psiReferenceExpression;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)codeConverter, (String)"codeConverter");
            boolean useFieldReference = FieldToPropertyProcessing.this.replaceReadWithFieldReference && PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)expression2)) || FieldToPropertyProcessing.this.replaceWriteWithFieldReference && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)expression2));
            Identifier identifier2 = Identifier.Companion.withNoPrototype$default(Identifier.Companion, useFieldReference ? "field" : FieldToPropertyProcessing.this.propertyName, FieldToPropertyProcessing.this.isNullable, false, null, 12, null);
            PsiExpression qualifier2 = expression2.getQualifierExpression();
            if (qualifier2 != null && !useFieldReference) {
                return new QualifiedExpression(CodeConverter.convertExpression$default(codeConverter, qualifier2, false, 2, null), identifier2, UtilsKt.dot(expression2));
            }
            PsiElementFactory elementFactory = PsiElementFactory.SERVICE.getInstance((Project)expression2.getProject());
            try {
                PsiExpression psiExpression = elementFactory.createExpressionFromText(identifier2.getName(), (PsiElement)expression2);
                if (!(psiExpression instanceof PsiReferenceExpression)) {
                    psiExpression = null;
                }
                PsiReferenceExpression psiReferenceExpression2 = (PsiReferenceExpression)psiExpression;
                if (psiReferenceExpression2 == null) {
                    return identifier2;
                }
                psiReferenceExpression = psiReferenceExpression2;
            }
            catch (IncorrectOperationException e) {
                return identifier2;
            }
            PsiReferenceExpression refExpr = psiReferenceExpression;
            return refExpr.resolve() == null ? (Expression)identifier2 : (Expression)new QualifiedExpression((Expression)ElementKt.assignNoPrototype((Element)new ThisExpression(Identifier.Companion.getEmpty())), identifier2, null);
        }

        @Override
        @Nullable
        public Expression convertMethodUsage(@NotNull PsiMethodCallExpression methodCall, @NotNull CodeConverter codeConverter) {
            Intrinsics.checkParameterIsNotNull((Object)methodCall, (String)"methodCall");
            Intrinsics.checkParameterIsNotNull((Object)codeConverter, (String)"codeConverter");
            return ConvertedCodeProcessor.DefaultImpls.convertMethodUsage(this, methodCall, codeConverter);
        }
    }
}

