/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClassMarker;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;
import org.jetbrains.kotlin.resolve.jvm.KotlinSafeClassFinder;

public class KotlinJavaPsiFacade {
    private volatile KotlinPsiElementFinderWrapper[] elementFinders;
    private volatile SoftReference<PackageCache> packageCache;
    private final Project project;
    private final LightModifierList emptyModifierList;

    public static KotlinJavaPsiFacade getInstance(Project project2) {
        return (KotlinJavaPsiFacade)ServiceManager.getService((Project)project2, KotlinJavaPsiFacade.class);
    }

    public KotlinJavaPsiFacade(@NotNull Project project2) {
        if (project2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(0);
        }
        this.project = project2;
        this.emptyModifierList = new LightModifierList(PsiManager.getInstance((Project)project2), (Language)KotlinLanguage.INSTANCE, new String[0]);
        final PsiModificationTracker modificationTracker2 = PsiManager.getInstance((Project)project2).getModificationTracker();
        MessageBus bus = project2.getMessageBus();
        bus.connect().subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){
            private long lastTimeSeen = -1L;

            public void modificationCountChanged() {
                long now = modificationTracker2.getJavaStructureModificationCount();
                if (this.lastTimeSeen != now) {
                    this.lastTimeSeen = now;
                    KotlinJavaPsiFacade.this.packageCache = null;
                }
            }
        });
    }

    public void clearPackageCaches() {
        this.packageCache = null;
    }

    public LightModifierList getEmptyModifierList() {
        return this.emptyModifierList;
    }

    public JavaClass findClass(@NotNull JavaClassFinder.Request request, @NotNull GlobalSearchScope scope2) {
        if (request == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(1);
        }
        if (scope2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(2);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ClassId classId = request.getClassId();
        String qualifiedName2 = classId.asSingleFqName().asString();
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName2, scope2);
            if (classes2.length != 0) {
                return KotlinJavaPsiFacade.createJavaClass(classId, classes2[0]);
            }
            return null;
        }
        for (KotlinPsiElementFinderWrapper finder : this.finders()) {
            Object aClass2;
            if (finder instanceof CliFinder) {
                aClass2 = ((CliFinder)finder).findClass(request, scope2);
                if (aClass2 == null) continue;
                return aClass2;
            }
            aClass2 = finder.findClass(qualifiedName2, scope2);
            if (aClass2 == null) continue;
            return KotlinJavaPsiFacade.createJavaClass(classId, aClass2);
        }
        return null;
    }

    @NotNull
    private static JavaClass createJavaClass(@NotNull ClassId classId, @NotNull PsiClass psiClass2) {
        if (classId == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(3);
        }
        if (psiClass2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(4);
        }
        JavaClassImpl javaClass = new JavaClassImpl(psiClass2);
        FqName fqName2 = classId.asSingleFqName();
        if (!fqName2.equals(javaClass.getFqName())) {
            throw new IllegalStateException("Requested " + fqName2 + ", got " + javaClass.getFqName());
        }
        if (psiClass2 instanceof KtLightClassMarker) {
            throw new IllegalStateException("Kotlin light classes should not be found by JavaPsiFacade, resolving: " + fqName2);
        }
        JavaClassImpl javaClassImpl = javaClass;
        if (javaClassImpl == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(5);
        }
        return javaClassImpl;
    }

    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        KotlinPsiElementFinderWrapper[] finders;
        if (packageFqName == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(6);
        }
        if ((finders = this.finders()).length == 1 && finders[0] instanceof CliFinder) {
            return ((CliFinder)finders[0]).knownClassNamesInPackage(packageFqName);
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(7);
        }
        if (scope2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(8);
        }
        String packageName = StringUtil.getPackageName((String)qualifiedName2);
        PsiPackage pkg = this.findPackage(packageName, scope2);
        String className2 = StringUtil.getShortName((String)qualifiedName2);
        if (pkg == null && packageName.length() < qualifiedName2.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope2);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName((String)className2, (PsiClass[])containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    KotlinJavaPsiFacade.$$$reportNull$$$0(9);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                KotlinJavaPsiFacade.$$$reportNull$$$0(10);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null || !pkg.containsClassNamed(className2)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                KotlinJavaPsiFacade.$$$reportNull$$$0(11);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className2, scope2);
        if (psiClassArray == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(12);
        }
        return psiClassArray;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] finders() {
        KotlinPsiElementFinderWrapper[] answer = this.elementFinders;
        if (answer == null) {
            answer = this.calcFinders();
            this.elementFinders = answer;
        }
        if (answer == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(13);
        }
        return answer;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] calcFinders() {
        ArrayList<CliFinder> elementFinders = new ArrayList<CliFinder>();
        JavaFileManager javaFileManager = KotlinJavaPsiFacade.findJavaFileManager(this.project);
        elementFinders.add((CliFinder)(javaFileManager instanceof KotlinCliJavaFileManager ? new CliFinder((KotlinCliJavaFileManager)javaFileManager) : new NonCliFinder(this.project, javaFileManager)));
        List nonKotlinFinders = ArraysKt.filter((Object[])this.getProject().getExtensions(PsiElementFinder.EP_NAME), finder -> finder instanceof KotlinSafeClassFinder || !(finder instanceof NonClasspathClassFinder) && !(finder instanceof KotlinFinderMarker) && !(finder instanceof PsiElementFinderImpl));
        elementFinders.addAll(CollectionsKt.map((Iterable)nonKotlinFinders, KotlinJavaPsiFacade::wrap));
        KotlinPsiElementFinderWrapper[] kotlinPsiElementFinderWrapperArray = elementFinders.toArray(new KotlinPsiElementFinderWrapper[elementFinders.size()]);
        if (kotlinPsiElementFinderWrapperArray == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(14);
        }
        return kotlinPsiElementFinderWrapperArray;
    }

    @NotNull
    private static JavaFileManager findJavaFileManager(@NotNull Project project2) {
        JavaFileManager javaFileManager;
        if (project2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(15);
        }
        if ((javaFileManager = (JavaFileManager)ServiceManager.getService((Project)project2, JavaFileManager.class)) == null) {
            throw new IllegalStateException("JavaFileManager component is not found in project");
        }
        JavaFileManager javaFileManager2 = javaFileManager;
        if (javaFileManager2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(16);
        }
        return javaFileManager2;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName2, GlobalSearchScope searchScope2) {
        Pair key;
        PsiPackage aPackage;
        if (qualifiedName2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(17);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        PackageCache cache2 = (PackageCache)SoftReference.dereference(this.packageCache);
        if (cache2 == null) {
            cache2 = new PackageCache();
            this.packageCache = new SoftReference((Object)cache2);
        }
        if ((aPackage = (PsiPackage)cache2.packageInScopeCache.get(key = new Pair((Object)qualifiedName2, (Object)searchScope2))) != null) {
            return aPackage;
        }
        KotlinPsiElementFinderWrapper[] finders = this.filteredFinders();
        Boolean packageFoundInAllScope = (Boolean)cache2.hasPackageInAllScopeCache.get(qualifiedName2);
        if (packageFoundInAllScope != null) {
            if (!packageFoundInAllScope.booleanValue()) {
                return null;
            }
            for (KotlinPsiElementFinderWrapper finder : finders) {
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName2, searchScope2)) == null) continue;
                return (PsiPackage)ConcurrencyUtil.cacheOrGet(cache2.packageInScopeCache, (Object)key, (Object)aPackage);
            }
        } else {
            for (KotlinPsiElementFinderWrapper finder : finders) {
                aPackage = finder.findPackage(qualifiedName2, searchScope2);
                if (aPackage == null) continue;
                return (PsiPackage)ConcurrencyUtil.cacheOrGet(cache2.packageInScopeCache, (Object)key, (Object)aPackage);
            }
            boolean found2 = false;
            for (KotlinPsiElementFinderWrapper finder : finders) {
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName2, GlobalSearchScope.allScope((Project)this.project))) == null) continue;
                found2 = true;
                break;
            }
            cache2.hasPackageInAllScopeCache.put(qualifiedName2, found2);
        }
        return null;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (dumbService.isDumb()) {
            List list2 = dumbService.filterByDumbAwareness(Arrays.asList(finders));
            finders = list2.toArray(new KotlinPsiElementFinderWrapper[list2.size()]);
        }
        if (finders == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(18);
        }
        return finders;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.project;
        if (project2 == null) {
            KotlinJavaPsiFacade.$$$reportNull$$$0(19);
        }
        return project2;
    }

    public static KotlinPsiElementFinderWrapper wrap(PsiElementFinder finder) {
        return finder instanceof DumbAware ? new KotlinPsiElementFinderWrapperImplDumbAware(finder) : new KotlinPsiElementFinderWrapperImpl(finder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesInDumbMode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "finders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFinders";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaFileManager";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredFinders";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createJavaClass";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "knownClassNamesInPackage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassesInDumbMode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findJavaFileManager";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonCliFinder
    implements KotlinPsiElementFinderWrapper,
    DumbAware {
        private final JavaFileManager javaFileManager;
        private final PsiManager psiManager;
        private final PackageIndex packageIndex;

        public NonCliFinder(@NotNull Project project2, @NotNull JavaFileManager javaFileManager) {
            if (project2 == null) {
                NonCliFinder.$$$reportNull$$$0(0);
            }
            if (javaFileManager == null) {
                NonCliFinder.$$$reportNull$$$0(1);
            }
            this.javaFileManager = javaFileManager;
            this.packageIndex = PackageIndex.getInstance((Project)project2);
            this.psiManager = PsiManager.getInstance((Project)project2);
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName2 == null) {
                NonCliFinder.$$$reportNull$$$0(2);
            }
            if (scope2 == null) {
                NonCliFinder.$$$reportNull$$$0(3);
            }
            return this.javaFileManager.findClass(qualifiedName2, scope2);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
            Query dirs2;
            if (qualifiedName2 == null) {
                NonCliFinder.$$$reportNull$$$0(4);
            }
            if (scope2 == null) {
                NonCliFinder.$$$reportNull$$$0(5);
            }
            return NonCliFinder.hasDirectoriesInScope((Query<VirtualFile>)(dirs2 = this.packageIndex.getDirsByPackageName(qualifiedName2, true)), scope2) ? new PsiPackageImpl(this.psiManager, qualifiedName2) : null;
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }

        private static boolean hasDirectoriesInScope(Query<VirtualFile> dirs2, final GlobalSearchScope scope2) {
            CommonProcessors.FindProcessor<VirtualFile> findProcessor = new CommonProcessors.FindProcessor<VirtualFile>(){

                protected boolean accept(VirtualFile file2) {
                    return scope2.accept(file2);
                }
            };
            dirs2.forEach((Processor)findProcessor);
            return findProcessor.isFound();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaFileManager";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$NonCliFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClass";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CliFinder
    implements KotlinPsiElementFinderWrapper,
    DumbAware {
        private final KotlinCliJavaFileManager javaFileManager;

        public CliFinder(@NotNull KotlinCliJavaFileManager javaFileManager) {
            if (javaFileManager == null) {
                CliFinder.$$$reportNull$$$0(0);
            }
            this.javaFileManager = javaFileManager;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName2 == null) {
                CliFinder.$$$reportNull$$$0(1);
            }
            if (scope2 == null) {
                CliFinder.$$$reportNull$$$0(2);
            }
            return this.javaFileManager.findClass(qualifiedName2, scope2);
        }

        public JavaClass findClass(@NotNull JavaClassFinder.Request request, @NotNull GlobalSearchScope scope2) {
            if (request == null) {
                CliFinder.$$$reportNull$$$0(3);
            }
            if (scope2 == null) {
                CliFinder.$$$reportNull$$$0(4);
            }
            return this.javaFileManager.findClass(request, scope2);
        }

        @Nullable
        public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
            if (packageFqName == null) {
                CliFinder.$$$reportNull$$$0(5);
            }
            return this.javaFileManager.knownClassNamesInPackage(packageFqName);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName2 == null) {
                CliFinder.$$$reportNull$$$0(6);
            }
            if (scope2 == null) {
                CliFinder.$$$reportNull$$$0(7);
            }
            return this.javaFileManager.findPackage(qualifiedName2);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaFileManager";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageFqName";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$CliFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "knownClassNamesInPackage";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KotlinPsiElementFinderWrapperImplDumbAware
    extends KotlinPsiElementFinderWrapperImpl
    implements DumbAware {
        private KotlinPsiElementFinderWrapperImplDumbAware(PsiElementFinder finder) {
            super(finder);
        }
    }

    private static class KotlinPsiElementFinderWrapperImpl
    implements KotlinPsiElementFinderWrapper {
        private final PsiElementFinder finder;

        private KotlinPsiElementFinderWrapperImpl(@NotNull PsiElementFinder finder) {
            if (finder == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(0);
            }
            this.finder = finder;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName2 == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(1);
            }
            if (scope2 == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(2);
            }
            return this.finder.findClass(qualifiedName2, scope2);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName2 == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(3);
            }
            if (scope2 == null) {
                KotlinPsiElementFinderWrapperImpl.$$$reportNull$$$0(4);
            }
            return this.finder.findPackage(qualifiedName2);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return true;
        }

        public String toString() {
            return this.finder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClass";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface KotlinPsiElementFinderWrapper {
        public PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public PsiPackage findPackage(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public boolean isSameResultForAnyScope();
    }

    private static class PackageCache {
        final ConcurrentMap<Pair<String, GlobalSearchScope>, PsiPackage> packageInScopeCache = ContainerUtil.newConcurrentMap();
        final ConcurrentMap<String, Boolean> hasPackageInAllScopeCache = ContainerUtil.newConcurrentMap();

        private PackageCache() {
        }
    }
}

