/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.kotlin;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.kotlin.KotlinAbstractUExpression;
import org.jetbrains.uast.kotlin.KotlinConverter;
import org.jetbrains.uast.kotlin.KotlinInternalUastUtilsKt;
import org.jetbrains.uast.kotlin.KotlinUFunctionCallExpression;
import org.jetbrains.uast.kotlin.KotlinUSimpleReferenceExpression;
import org.jetbrains.uast.kotlin.KotlinUastLanguagePluginKt;
import org.jetbrains.uast.kotlin.KotlinUastResolveProviderService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0010\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u0014H\u0016JA\u0010\u000f\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0016\u0010\u0016\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00150\u00140\u0017\u00a2\u0006\u0002\u0010\u0018J$\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0010\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u0014H\u0016J9\u0010\u0019\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00150\u00140\u0017H\u0016\u00a2\u0006\u0002\u0010\u001bJ=\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001d\"\b\b\u0000\u0010\u0015*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00150\u00140\u0017H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0016J$\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010&\u001a\u00020\"H\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000e\u00a8\u0006+"}, d2={"Lorg/jetbrains/uast/kotlin/KotlinUastLanguagePlugin;", "Lorg/jetbrains/uast/UastLanguagePlugin;", "()V", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "priority", "", "getPriority", "()I", "isJvmElement", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "convertElement", "Lorg/jetbrains/uast/UElement;", "element", "parent", "requiredType", "Ljava/lang/Class;", "T", "expectedTypes", "", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/uast/UElement;[Ljava/lang/Class;)Lorg/jetbrains/uast/UElement;", "convertElementWithParent", "requiredTypes", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/Class;)Lorg/jetbrains/uast/UElement;", "convertToAlternatives", "Lkotlin/sequences/Sequence;", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/Class;)Lkotlin/sequences/Sequence;", "getConstructorCallExpression", "Lorg/jetbrains/uast/UastLanguagePlugin$ResolvedConstructor;", "fqName", "", "getMethodCallExpression", "Lorg/jetbrains/uast/UastLanguagePlugin$ResolvedMethod;", "containingClassFqName", "methodName", "isExpressionValueUsed", "Lorg/jetbrains/uast/UExpression;", "isFileSupported", "fileName", "uast-kotlin"})
public final class KotlinUastLanguagePlugin
implements UastLanguagePlugin {
    private final int priority = 10;

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinLanguage), (String)"KotlinLanguage.INSTANCE");
        return kotlinLanguage;
    }

    public boolean isFileSupported(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return StringsKt.endsWith((String)fileName, (String)".kt", (boolean)false) || StringsKt.endsWith((String)fileName, (String)".kts", (boolean)false);
    }

    private final boolean isJvmElement(@NotNull PsiElement $this$isJvmElement) {
        KotlinUastResolveProviderService resolveProvider = (KotlinUastResolveProviderService)ServiceManager.getService((Project)$this$isJvmElement.getProject(), KotlinUastResolveProviderService.class);
        return resolveProvider.isJvmElement($this$isJvmElement);
    }

    @Nullable
    public UElement convertElement(@NotNull PsiElement element3, @Nullable UElement parent2, @Nullable Class<? extends UElement> requiredType) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!this.isJvmElement(element3)) {
            return null;
        }
        return KotlinConverter.INSTANCE.convertDeclarationOrElement(element3, parent2, KotlinUastLanguagePluginKt.access$elementTypes(requiredType));
    }

    @Nullable
    public UElement convertElementWithParent(@NotNull PsiElement element3, @Nullable Class<? extends UElement> requiredType) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!this.isJvmElement(element3)) {
            return null;
        }
        if (element3 instanceof PsiFile) {
            return KotlinConverter.INSTANCE.convertDeclaration$uast_kotlin(element3, null, KotlinUastLanguagePluginKt.access$elementTypes(requiredType));
        }
        if (element3 instanceof KtLightClassForFacade) {
            return KotlinConverter.INSTANCE.convertDeclaration$uast_kotlin(element3, null, KotlinUastLanguagePluginKt.access$elementTypes(requiredType));
        }
        return KotlinConverter.INSTANCE.convertDeclarationOrElement(element3, null, KotlinUastLanguagePluginKt.access$elementTypes(requiredType));
    }

    @Nullable
    public UastLanguagePlugin.ResolvedMethod getMethodCallExpression(@NotNull PsiElement element3, @Nullable String containingClassFqName, @NotNull String methodName2) {
        PsiElement parent2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)methodName2, (String)"methodName");
        if (!(element3 instanceof KtCallExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)element3, KotlinInternalUastUtilsKt.analyze((KtElement)element3));
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor resultingDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(resultingDescriptor instanceof FunctionDescriptor) || Intrinsics.areEqual((Object)((FunctionDescriptor)resultingDescriptor).getName().asString(), (Object)methodName2) ^ true) {
            return null;
        }
        PsiElement psiElement2 = parent2 = ((KtCallExpression)element3).getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent");
        UElement uElement = this.convertElementWithParent(psiElement2, (Class<? extends UElement>)null);
        if (uElement == null) {
            return null;
        }
        UElement parentUElement = uElement;
        KotlinUFunctionCallExpression uExpression = new KotlinUFunctionCallExpression((KtCallElement)element3, parentUElement, resolvedCall3);
        PsiMethod psiMethod = uExpression.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        if (Intrinsics.areEqual((Object)method.getName(), (Object)methodName2) ^ true) {
            return null;
        }
        return new UastLanguagePlugin.ResolvedMethod((UCallExpression)uExpression, method);
    }

    @Nullable
    public UastLanguagePlugin.ResolvedConstructor getConstructorCallExpression(@NotNull PsiElement element3, @NotNull String fqName2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        if (!(element3 instanceof KtCallExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)element3, KotlinInternalUastUtilsKt.analyze((KtElement)element3));
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor resultingDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(resultingDescriptor instanceof ConstructorDescriptor) || Intrinsics.areEqual((Object)((object = ((ConstructorDescriptor)resultingDescriptor).getReturnType().getConstructor().getDeclarationDescriptor()) != null && (object = object.getName()) != null ? ((Name)object).asString() : null), (Object)fqName2) ^ true) {
            return null;
        }
        PsiElement psiElement2 = KotlinConverter.INSTANCE.unwrapElements$uast_kotlin(((KtCallExpression)element3).getParent());
        if (psiElement2 == null) {
            return null;
        }
        PsiElement parent2 = psiElement2;
        UElement uElement = this.convertElementWithParent(parent2, (Class<? extends UElement>)null);
        if (uElement == null) {
            return null;
        }
        UElement parentUElement = uElement;
        KotlinUFunctionCallExpression uExpression = new KotlinUFunctionCallExpression((KtCallElement)element3, parentUElement, resolvedCall3);
        PsiMethod psiMethod = uExpression.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        PsiClass psiClass2 = method.getContainingClass();
        if (psiClass2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"method.containingClass ?: return null");
        PsiClass containingClass2 = psiClass2;
        return new UastLanguagePlugin.ResolvedConstructor((UCallExpression)uExpression, method, containingClass2);
    }

    public boolean isExpressionValueUsed(@NotNull UExpression element3) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        UExpression uExpression = element3;
        if (uExpression instanceof KotlinUSimpleReferenceExpression.KotlinAccessorCallExpression) {
            bl = ((KotlinUSimpleReferenceExpression.KotlinAccessorCallExpression)element3).getSetterValue() != null;
        } else if (uExpression instanceof KotlinAbstractUExpression) {
            PsiElement psiElement2 = element3.getSourcePsi();
            if (!(psiElement2 instanceof KtElement)) {
                psiElement2 = null;
            }
            KtElement ktElement = (KtElement)psiElement2;
            if (ktElement == null) {
                return false;
            }
            KtElement ktElement2 = ktElement;
            Boolean bl2 = (Boolean)KotlinInternalUastUtilsKt.analyze(ktElement2).get(BindingContext.USED_AS_EXPRESSION, ktElement2);
            if (bl2 == null) {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final <T extends UElement> T convertElement(@NotNull PsiElement element3, @Nullable UElement parent2, @NotNull Class<? extends T>[] expectedTypes) {
        UElement uElement;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(expectedTypes, (String)"expectedTypes");
        if (!this.isJvmElement(element3)) {
            return null;
        }
        Class[] nonEmptyExpectedTypes = KotlinUastLanguagePluginKt.access$nonEmptyOr(expectedTypes, UastContextKt.DEFAULT_TYPES_LIST);
        UElement uElement2 = KotlinConverter.INSTANCE.convertDeclaration$uast_kotlin(element3, parent2, nonEmptyExpectedTypes);
        if (uElement2 == null) {
            uElement2 = uElement = KotlinConverter.INSTANCE.convertPsiElement$uast_kotlin(element3, parent2, nonEmptyExpectedTypes);
        }
        if (!(uElement2 instanceof UElement)) {
            uElement = null;
        }
        return (T)uElement;
    }

    @Nullable
    public <T extends UElement> T convertElementWithParent(@NotNull PsiElement element3, @NotNull Class<? extends T>[] requiredTypes) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(requiredTypes, (String)"requiredTypes");
        return this.convertElement(element3, null, requiredTypes);
    }

    @NotNull
    public <T extends UElement> Sequence<T> convertToAlternatives(@NotNull PsiElement element3, @NotNull Class<? extends T>[] requiredTypes) {
        Sequence sequence2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(requiredTypes, (String)"requiredTypes");
        if (!this.isJvmElement(element3)) {
            sequence2 = SequencesKt.emptySequence();
        } else if (element3 instanceof KtFile) {
            sequence2 = KotlinConverter.INSTANCE.convertKtFile((KtFile)element3, null, requiredTypes);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<T>");
            }
        } else if (element3 instanceof KtProperty && !((KtProperty)element3).isLocal()) {
            sequence2 = KotlinConverter.INSTANCE.convertNonLocalProperty((KtProperty)element3, null, requiredTypes);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<T>");
            }
        } else if (element3 instanceof KtParameter) {
            sequence2 = KotlinConverter.INSTANCE.convertParameter((KtParameter)element3, null, requiredTypes);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<T>");
            }
        } else if (element3 instanceof KtClassOrObject) {
            sequence2 = KotlinConverter.INSTANCE.convertClassOrObject((KtClassOrObject)element3, null, requiredTypes);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<T>");
            }
        } else {
            Object[] objectArray = new UElement[1];
            T t = this.convertElementWithParent(element3, KotlinUastLanguagePluginKt.access$nonEmptyOr(requiredTypes, UastContextKt.DEFAULT_TYPES_LIST));
            if (!(t instanceof UElement)) {
                t = null;
            }
            objectArray[0] = t;
            sequence2 = SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray));
        }
        return sequence2;
    }

    @NotNull
    public UExpression getInitializerBody(@NotNull PsiClassInitializer element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return UastLanguagePlugin.DefaultImpls.getInitializerBody((UastLanguagePlugin)this, (PsiClassInitializer)element3);
    }

    @Nullable
    public UExpression getInitializerBody(@NotNull PsiVariable element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return UastLanguagePlugin.DefaultImpls.getInitializerBody((UastLanguagePlugin)this, (PsiVariable)element3);
    }

    @Nullable
    public UExpression getMethodBody(@NotNull PsiMethod element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return UastLanguagePlugin.DefaultImpls.getMethodBody((UastLanguagePlugin)this, (PsiMethod)element3);
    }
}

