/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentFoundCondition;
import org.fest.swing.core.ComponentLookupScope;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.NameMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.fixture.AbstractComponentFixture;
import org.fest.swing.fixture.ComponentContainerFixture;
import org.fest.swing.fixture.ComponentFixtureExtension;
import org.fest.swing.fixture.ContainerFixture;
import org.fest.swing.fixture.DialogFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JCheckBoxFixture;
import org.fest.swing.fixture.JComboBoxFixture;
import org.fest.swing.fixture.JFileChooserFixture;
import org.fest.swing.fixture.JLabelFixture;
import org.fest.swing.fixture.JListFixture;
import org.fest.swing.fixture.JMenuItemFinder;
import org.fest.swing.fixture.JMenuItemFixture;
import org.fest.swing.fixture.JOptionPaneFixture;
import org.fest.swing.fixture.JPanelFixture;
import org.fest.swing.fixture.JProgressBarFixture;
import org.fest.swing.fixture.JRadioButtonFixture;
import org.fest.swing.fixture.JScrollBarFixture;
import org.fest.swing.fixture.JScrollPaneFixture;
import org.fest.swing.fixture.JSliderFixture;
import org.fest.swing.fixture.JSpinnerFixture;
import org.fest.swing.fixture.JSplitPaneFixture;
import org.fest.swing.fixture.JTabbedPaneFixture;
import org.fest.swing.fixture.JTableFixture;
import org.fest.swing.fixture.JTextComponentFixture;
import org.fest.swing.fixture.JToggleButtonFixture;
import org.fest.swing.fixture.JToolBarFixture;
import org.fest.swing.fixture.JTreeFixture;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;
import org.fest.util.Preconditions;

public abstract class AbstractContainerFixture<S, C extends Container, D extends ComponentDriver>
extends AbstractComponentFixture<S, C, D>
implements ComponentContainerFixture,
ContainerFixture<C> {
    private static final Timeout DEFAULT_DIALOG_LOOKUP_TIMEOUT = Timeout.timeout(100L);
    private final JMenuItemFinder menuItemFinder;

    public AbstractContainerFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull Class<? extends C> type) {
        super(selfType, robot, type);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target());
    }

    public AbstractContainerFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nullable String name, @Nonnull Class<? extends C> type) {
        super(selfType, robot, name, type);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target());
    }

    public AbstractContainerFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull C target) {
        super(selfType, robot, target);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JButtonFixture button() {
        return new JButtonFixture(this.robot(), this.findByType(JButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JButtonFixture button(@Nonnull GenericTypeMatcher<? extends JButton> matcher) {
        return new JButtonFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JButtonFixture button(@Nullable String name) {
        return new JButtonFixture(this.robot(), this.findByName(name, JButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JCheckBoxFixture checkBox() {
        return new JCheckBoxFixture(this.robot(), this.findByType(JCheckBox.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JCheckBoxFixture checkBox(@Nonnull GenericTypeMatcher<? extends JCheckBox> matcher) {
        return new JCheckBoxFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JCheckBoxFixture checkBox(@Nullable String name) {
        return new JCheckBoxFixture(this.robot(), this.findByName(name, JCheckBox.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JComboBoxFixture comboBox() {
        return new JComboBoxFixture(this.robot(), this.findByType(JComboBox.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JComboBoxFixture comboBox(@Nonnull GenericTypeMatcher<? extends JComboBox> matcher) {
        return new JComboBoxFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JComboBoxFixture comboBox(@Nullable String name) {
        return new JComboBoxFixture(this.robot(), this.findByName(name, JComboBox.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog() {
        return this.dialog(this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nonnull Timeout timeout) {
        TypeMatcher matcher = new TypeMatcher(Dialog.class, this.requireShowing());
        return this.findDialog(matcher, timeout);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nonnull GenericTypeMatcher<? extends Dialog> matcher) {
        return this.dialog(matcher, this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nonnull GenericTypeMatcher<? extends Dialog> matcher, @Nonnull Timeout timeout) {
        return this.findDialog(matcher, timeout);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nullable String name) {
        return this.dialog(name, this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nullable String name, @Nonnull Timeout timeout) {
        NameMatcher matcher = new NameMatcher(name, Dialog.class, this.requireShowing());
        return this.findDialog(matcher, timeout);
    }

    @Nonnull
    private DialogFixture findDialog(@Nonnull ComponentMatcher matcher, @Nonnull Timeout timeout) {
        String description = "dialog to be found using matcher " + matcher;
        ComponentFoundCondition condition = new ComponentFoundCondition(description, this.robot().finder(), matcher);
        Pause.pause((Condition)condition, timeout);
        Dialog dialog = (Dialog)condition.found();
        return new DialogFixture(this.robot(), (Dialog)Preconditions.checkNotNull((Object)dialog));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser() {
        return this.fileChooser(this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nonnull Timeout timeout) {
        TypeMatcher matcher = new TypeMatcher(JFileChooser.class, this.requireShowing());
        return this.findFileChooser(matcher, timeout);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nonnull GenericTypeMatcher<? extends JFileChooser> matcher) {
        return this.fileChooser(matcher, this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nonnull GenericTypeMatcher<? extends JFileChooser> matcher, @Nonnull Timeout timeout) {
        return this.findFileChooser(matcher, timeout);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nullable String name) {
        return new JFileChooserFixture(this.robot(), this.findByName(name, JFileChooser.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nullable String name, @Nonnull Timeout timeout) {
        NameMatcher matcher = new NameMatcher(name, JFileChooser.class, this.requireShowing());
        return this.findFileChooser(matcher, timeout);
    }

    @Nonnull
    private JFileChooserFixture findFileChooser(@Nonnull ComponentMatcher matcher, @Nonnull Timeout timeout) {
        String description = "file chooser to be found using matcher " + matcher;
        ComponentFoundCondition condition = new ComponentFoundCondition(description, this.robot().finder(), matcher);
        Pause.pause((Condition)condition, timeout);
        JFileChooser fileChooser = (JFileChooser)condition.found();
        return new JFileChooserFixture(this.robot(), (JFileChooser)Preconditions.checkNotNull((Object)fileChooser));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JLabelFixture label() {
        return new JLabelFixture(this.robot(), this.findByType(JLabel.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JLabelFixture label(@Nonnull GenericTypeMatcher<? extends JLabel> matcher) {
        return new JLabelFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JLabelFixture label(@Nullable String name) {
        return new JLabelFixture(this.robot(), this.findByName(name, JLabel.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JListFixture list() {
        return new JListFixture(this.robot(), this.findByType(JList.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JListFixture list(@Nonnull GenericTypeMatcher<? extends JList> matcher) {
        return new JListFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JListFixture list(@Nullable String name) {
        return new JListFixture(this.robot(), this.findByName(name, JList.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JMenuItemFixture menuItemWithPath(String ... path) {
        return new JMenuItemFixture(this.robot(), this.menuItemFinder.menuItemWithPath(path));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JMenuItemFixture menuItem(@Nullable String name) {
        boolean requireShowing = ComponentLookupScope.SHOWING_ONLY.equals((Object)this.robot().settings().componentLookupScope());
        return new JMenuItemFixture(this.robot(), this.finder().findByName((Container)this.target(), name, JMenuItem.class, requireShowing));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JMenuItemFixture menuItem(@Nonnull GenericTypeMatcher<? extends JMenuItem> matcher) {
        return new JMenuItemFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JOptionPaneFixture optionPane() {
        return this.optionPane(this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JOptionPaneFixture optionPane(@Nonnull Timeout timeout) {
        TypeMatcher matcher = new TypeMatcher(JOptionPane.class, this.requireShowing());
        String description = "option pane to be found using matcher " + matcher;
        ComponentFoundCondition condition = new ComponentFoundCondition(description, this.robot().finder(), (ComponentMatcher)matcher);
        Pause.pause((Condition)condition, timeout);
        JOptionPane optionPane = (JOptionPane)condition.found();
        return new JOptionPaneFixture(this.robot(), (JOptionPane)Preconditions.checkNotNull((Object)optionPane));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPanelFixture panel() {
        return new JPanelFixture(this.robot(), this.findByType(JPanel.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPanelFixture panel(@Nonnull GenericTypeMatcher<? extends JPanel> matcher) {
        return new JPanelFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPanelFixture panel(@Nullable String name) {
        return new JPanelFixture(this.robot(), this.findByName(name, JPanel.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JProgressBarFixture progressBar() {
        return new JProgressBarFixture(this.robot(), this.findByType(JProgressBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JProgressBarFixture progressBar(@Nonnull GenericTypeMatcher<? extends JProgressBar> matcher) {
        return new JProgressBarFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JProgressBarFixture progressBar(@Nullable String name) {
        return new JProgressBarFixture(this.robot(), this.findByName(name, JProgressBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JRadioButtonFixture radioButton() {
        return new JRadioButtonFixture(this.robot(), this.findByType(JRadioButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JRadioButtonFixture radioButton(@Nonnull GenericTypeMatcher<? extends JRadioButton> matcher) {
        return new JRadioButtonFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JRadioButtonFixture radioButton(@Nullable String name) {
        return new JRadioButtonFixture(this.robot(), this.findByName(name, JRadioButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollBarFixture scrollBar() {
        return new JScrollBarFixture(this.robot(), this.findByType(JScrollBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollBarFixture scrollBar(@Nonnull GenericTypeMatcher<? extends JScrollBar> matcher) {
        return new JScrollBarFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollBarFixture scrollBar(@Nullable String name) {
        return new JScrollBarFixture(this.robot(), this.findByName(name, JScrollBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollPaneFixture scrollPane() {
        return new JScrollPaneFixture(this.robot(), this.findByType(JScrollPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollPaneFixture scrollPane(@Nonnull GenericTypeMatcher<? extends JScrollPane> matcher) {
        return new JScrollPaneFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollPaneFixture scrollPane(@Nullable String name) {
        return new JScrollPaneFixture(this.robot(), this.findByName(name, JScrollPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSliderFixture slider() {
        return new JSliderFixture(this.robot(), this.findByType(JSlider.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSliderFixture slider(@Nonnull GenericTypeMatcher<? extends JSlider> matcher) {
        return new JSliderFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSliderFixture slider(@Nullable String name) {
        return new JSliderFixture(this.robot(), this.findByName(name, JSlider.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSpinnerFixture spinner() {
        return new JSpinnerFixture(this.robot(), this.findByType(JSpinner.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSpinnerFixture spinner(@Nonnull GenericTypeMatcher<? extends JSpinner> matcher) {
        return new JSpinnerFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSpinnerFixture spinner(@Nullable String name) {
        return new JSpinnerFixture(this.robot(), this.findByName(name, JSpinner.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSplitPaneFixture splitPane() {
        return new JSplitPaneFixture(this.robot(), this.findByType(JSplitPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSplitPaneFixture splitPane(@Nonnull GenericTypeMatcher<? extends JSplitPane> matcher) {
        return new JSplitPaneFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSplitPaneFixture splitPane(@Nullable String name) {
        return new JSplitPaneFixture(this.robot(), this.findByName(name, JSplitPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTabbedPaneFixture tabbedPane() {
        return new JTabbedPaneFixture(this.robot(), this.findByType(JTabbedPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTabbedPaneFixture tabbedPane(@Nonnull GenericTypeMatcher<? extends JTabbedPane> matcher) {
        return new JTabbedPaneFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTabbedPaneFixture tabbedPane(@Nullable String name) {
        return new JTabbedPaneFixture(this.robot(), this.findByName(name, JTabbedPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTableFixture table() {
        return new JTableFixture(this.robot(), this.findByType(JTable.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTableFixture table(@Nonnull GenericTypeMatcher<? extends JTable> matcher) {
        return new JTableFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTableFixture table(@Nullable String name) {
        return new JTableFixture(this.robot(), this.findByName(name, JTable.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTextComponentFixture textBox() {
        return new JTextComponentFixture(this.robot(), this.findByType(JTextComponent.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTextComponentFixture textBox(@Nonnull GenericTypeMatcher<? extends JTextComponent> matcher) {
        return new JTextComponentFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTextComponentFixture textBox(@Nullable String name) {
        return new JTextComponentFixture(this.robot(), this.findByName(name, JTextComponent.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToggleButtonFixture toggleButton() {
        return new JToggleButtonFixture(this.robot(), this.findByType(JToggleButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToggleButtonFixture toggleButton(@Nonnull GenericTypeMatcher<? extends JToggleButton> matcher) {
        return new JToggleButtonFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToggleButtonFixture toggleButton(@Nullable String name) {
        return new JToggleButtonFixture(this.robot(), this.findByName(name, JToggleButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToolBarFixture toolBar() {
        return new JToolBarFixture(this.robot(), this.findByType(JToolBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToolBarFixture toolBar(@Nonnull GenericTypeMatcher<? extends JToolBar> matcher) {
        return new JToolBarFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToolBarFixture toolBar(@Nullable String name) {
        return new JToolBarFixture(this.robot(), this.findByName(name, JToolBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTreeFixture tree() {
        return new JTreeFixture(this.robot(), this.findByType(JTree.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTreeFixture tree(@Nonnull GenericTypeMatcher<? extends JTree> matcher) {
        return new JTreeFixture(this.robot(), this.find(matcher));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTreeFixture tree(@Nullable String name) {
        return new JTreeFixture(this.robot(), this.findByName(name, JTree.class));
    }

    @Nonnull
    protected final <T extends Component> T findByType(@Nonnull Class<T> type) {
        return this.finder().findByType((Container)this.target(), type, this.requireShowing());
    }

    @Nonnull
    protected final <T extends Component> T findByName(@Nullable String name, @Nonnull Class<T> type) {
        return this.finder().findByName((Container)this.target(), name, type, this.requireShowing());
    }

    @Nonnull
    protected final <T extends Component> T find(@Nonnull GenericTypeMatcher<? extends T> matcher) {
        return this.finder().find((Container)this.target(), matcher);
    }

    @Nonnull
    @RunsInEDT
    public <T extends Component, F extends AbstractComponentFixture<?, T, ?>> F with(@Nonnull ComponentFixtureExtension<T, F> extension) {
        return extension.createFixture(this.robot(), (Container)this.target());
    }

    @Nonnull
    protected final ComponentFinder finder() {
        return this.robot().finder();
    }

    @Override
    @Nonnull
    public Timeout defaultDialogLookupTimeout() {
        return DEFAULT_DIALOG_LOOKUP_TIMEOUT;
    }
}

