/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTable;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.data.TableCell;
import org.fest.swing.driver.JTableDriver;
import org.fest.swing.fixture.ColorFixture;
import org.fest.swing.fixture.FontFixture;
import org.fest.swing.fixture.ItemFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTableFixture;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class JTableCellFixture
implements ItemFixture<JTableCellFixture> {
    private final JTableFixture table;
    private final TableCell cell;
    private final JTable target;
    private final JTableDriver driver;

    protected JTableCellFixture(@Nonnull JTableFixture table, @Nonnull TableCell cell) {
        this(table, cell, (JTable)table.target(), (JTableDriver)table.driver());
    }

    @VisibleForTesting
    JTableCellFixture(@Nonnull JTableFixture table, @Nonnull TableCell cell, @Nonnull JTable target, @Nonnull JTableDriver driver) {
        this.table = (JTableFixture)Preconditions.checkNotNull((Object)table);
        this.cell = (TableCell)Preconditions.checkNotNull((Object)cell);
        this.target = target;
        this.driver = driver;
    }

    @Override
    @Nonnull
    public JTableCellFixture select() {
        this.table.selectCell(this.cell());
        return this;
    }

    @Override
    @Nonnull
    public JTableCellFixture click() {
        this.table.click(this.cell(), MouseButton.LEFT_BUTTON);
        return this;
    }

    @Override
    @Nonnull
    public JTableCellFixture click(@Nonnull MouseClickInfo mouseClickInfo) {
        this.table.click(this.cell(), mouseClickInfo);
        return this;
    }

    @Override
    @Nonnull
    public JTableCellFixture doubleClick() {
        this.table.click(this.cell(), MouseButton.LEFT_BUTTON, 2);
        return this;
    }

    @Override
    @Nonnull
    public JTableCellFixture rightClick() {
        return this.click(MouseButton.RIGHT_BUTTON);
    }

    @Override
    @Nonnull
    public JTableCellFixture click(@Nonnull MouseButton button) {
        this.table.click(this.cell(), button);
        return this;
    }

    @Nonnull
    public JTableCellFixture startEditing() {
        this.driver.startCellEditing(this.target, this.cell());
        return this;
    }

    @Nonnull
    public JTableCellFixture stopEditing() {
        this.driver.stopCellEditing(this.target, this.cell());
        return this;
    }

    @Nonnull
    public JTableCellFixture cancelEditing() {
        this.driver.cancelCellEditing(this.target, this.cell());
        return this;
    }

    public Component editor() {
        return this.driver.cellEditor(this.target, this.cell());
    }

    @Nonnull
    public JTableCellFixture enterValue(@Nonnull String value) {
        this.driver.enterValueInCell(this.target, this.cell(), value);
        return this;
    }

    @Nonnull
    public JTableCellFixture requireValue(@Nullable String value) {
        this.table.requireCellValue(this.cell(), value);
        return this;
    }

    @Nonnull
    public JTableCellFixture requireValue(@Nonnull Pattern pattern) {
        this.table.requireCellValue(this.cell(), pattern);
        return this;
    }

    public FontFixture font() {
        return this.table.fontAt(this.cell());
    }

    @Nonnull
    public ColorFixture background() {
        return this.table.backgroundAt(this.cell());
    }

    @Nonnull
    public ColorFixture foreground() {
        return this.table.foregroundAt(this.cell());
    }

    @Override
    @Nullable
    public String value() {
        return this.table.valueAt(this.cell());
    }

    @Override
    @Nonnull
    public JTableCellFixture drag() {
        this.table.drag(this.cell());
        return this;
    }

    @Override
    @Nonnull
    public JTableCellFixture drop() {
        this.table.drop(this.cell());
        return this;
    }

    @Override
    @Nonnull
    public JPopupMenuFixture showPopupMenu() {
        return this.table.showPopupMenuAt(this.cell());
    }

    @Nonnull
    public JTableCellFixture requireEditable() {
        this.table.requireEditable(this.cell());
        return this;
    }

    @Nonnull
    public JTableCellFixture requireNotEditable() {
        this.table.requireNotEditable(this.cell());
        return this;
    }

    public int row() {
        return this.cell.row;
    }

    public int column() {
        return this.cell.column;
    }

    @Nonnull
    @VisibleForTesting
    JTableFixture tableFixture() {
        return this.table;
    }

    @Nonnull
    @VisibleForTesting
    TableCell cell() {
        return this.cell;
    }
}

