/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.JNITypeParser;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayTypeImpl
extends ReferenceTypeImpl
implements ArrayType {
    protected ArrayTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    public ArrayReference newInstance(int length) {
        try {
            return (ArrayReference)((Object)JDWP.ArrayType.NewInstance.process((VirtualMachineImpl)this.vm, (ArrayTypeImpl)this, (int)length).newArray);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public String componentSignature() {
        return this.signature().substring(1);
    }

    @Override
    public String componentTypeName() {
        JNITypeParser parser = new JNITypeParser(this.componentSignature());
        return parser.typeName();
    }

    Type type() throws ClassNotLoadedException {
        return this.findType(this.componentSignature());
    }

    @Override
    void addVisibleMethods(Map<String, Method> map, Set<InterfaceType> seenInterfaces) {
    }

    @Override
    public List<Method> allMethods() {
        return new ArrayList<Method>(0);
    }

    Type findComponentType(String signature) throws ClassNotLoadedException {
        return this.findType(signature);
    }

    @Override
    public Type componentType() throws ClassNotLoadedException {
        return this.findComponentType(this.componentSignature());
    }

    static boolean isComponentAssignable(Type destination, Type source) {
        if (source instanceof PrimitiveType) {
            return source.equals(destination);
        }
        if (destination instanceof PrimitiveType) {
            return false;
        }
        ReferenceTypeImpl refSource = (ReferenceTypeImpl)source;
        ReferenceTypeImpl refDestination = (ReferenceTypeImpl)destination;
        return refSource.isAssignableTo(refDestination);
    }

    @Override
    boolean isAssignableTo(ReferenceType destType) {
        if (destType instanceof ArrayType) {
            try {
                Type destComponentType = ((ArrayType)destType).componentType();
                return ArrayTypeImpl.isComponentAssignable(destComponentType, this.componentType());
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
        }
        if (destType instanceof InterfaceType) {
            return destType.name().equals("java.lang.Cloneable");
        }
        return destType.name().equals("java.lang.Object");
    }

    List<ReferenceType> inheritedTypes() {
        return new ArrayList<ReferenceType>(0);
    }

    @Override
    void getModifiers() {
        if (this.modifiers != -1) {
            return;
        }
        try {
            Type t = this.componentType();
            if (t instanceof PrimitiveType) {
                this.modifiers = 17;
            } else {
                ReferenceType rt = (ReferenceType)t;
                this.modifiers = rt.modifiers();
            }
        }
        catch (ClassNotLoadedException cnle) {
            cnle.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "array class " + this.name() + " (" + this.loaderString() + ")";
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public boolean isVerified() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean failedToInitialize() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return false;
    }
}

