/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.streams;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.AbstractInput;
import kotlinx.io.core.ByteReadPacketBase;
import kotlinx.io.core.Input;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.pool.ObjectPool;
import kotlinx.io.streams.ByteArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkotlinx/io/streams/InputStreamAsInput;", "Lkotlinx/io/core/AbstractInput;", "Lkotlinx/io/core/Input;", "stream", "Ljava/io/InputStream;", "pool", "Lkotlinx/io/pool/ObjectPool;", "Lkotlinx/io/core/IoBuffer;", "(Ljava/io/InputStream;Lkotlinx/io/pool/ObjectPool;)V", "closeSource", "", "fill", "kotlinx-io-jvm"})
public final class InputStreamAsInput
extends AbstractInput
implements Input {
    private final InputStream stream;

    @Override
    @Nullable
    protected IoBuffer fill() {
        byte[] buffer = ByteArraysKt.getByteArrayPool().borrow();
        try {
            IoBuffer ioBuffer;
            int rc = this.stream.read(buffer, 0, 4096 - ByteReadPacketBase.Companion.getReservedSize());
            if (rc >= 0) {
                IoBuffer ioBuffer2;
                IoBuffer it = ioBuffer2 = this.getPool().borrow();
                it.reserveEndGap(ByteReadPacketBase.Companion.getReservedSize());
                it.writeFully(buffer, 0, rc);
                ioBuffer = ioBuffer2;
            } else {
                ioBuffer = null;
            }
            IoBuffer result = ioBuffer;
            ByteArraysKt.getByteArrayPool().recycle(buffer);
            return result;
        }
        catch (Throwable t) {
            ByteArraysKt.getByteArrayPool().recycle(buffer);
            throw t;
        }
    }

    @Override
    protected void closeSource() {
        this.stream.close();
    }

    public InputStreamAsInput(@NotNull InputStream stream, @NotNull ObjectPool<IoBuffer> pool) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        Intrinsics.checkParameterIsNotNull(pool, (String)"pool");
        super(null, 0L, pool, 3, null);
        this.stream = stream;
    }
}

