/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ImportLayoutPanel;
import com.intellij.application.options.PackagePanel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.ImportsLayoutSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public abstract class CodeStyleImportsPanelBase
extends JPanel {
    private final PackageEntryTable myPackageList;
    private JCheckBox myCbUseFQClassNames;
    private JCheckBox myCbUseSingleClassImports;
    protected JCheckBox myCbInsertInnerClassImports;
    private JTextField myClassCountField;
    private JTextField myNamesCountField;
    private JBTable myPackageTable;
    private JPanel myGeneralPanel;
    private JPanel myPackagesPanel;
    private JPanel myImportsLayoutPanel;
    private JPanel myWholePanel;
    private ImportLayoutPanel myImportLayoutPanel;

    public CodeStyleImportsPanelBase() {
        this.$$$setupUI$$$();
        this.myPackageList = new PackageEntryTable();
        this.setLayout(new BorderLayout());
        this.add((Component)this.myWholePanel, "Center");
        this.myGeneralPanel.add((Component)this.createGeneralOptionsPanel(), "Center");
        this.createImportPanel();
        this.createPackagePanel();
    }

    public abstract void reset(CodeStyleSettings var1);

    public abstract void apply(CodeStyleSettings var1);

    public abstract boolean isModified(CodeStyleSettings var1);

    private void createImportPanel() {
        this.myImportLayoutPanel = new ImportLayoutPanel(){

            @Override
            public void refresh() {
                CodeStyleImportsPanelBase.this.refreshTable(CodeStyleImportsPanelBase.this.myPackageTable, CodeStyleImportsPanelBase.this.myPackageList);
                CodeStyleImportsPanelBase.this.refreshTable(this.getImportLayoutTable(), this.getImportLayoutList());
            }
        };
        this.myImportsLayoutPanel.add((Component)this.myImportLayoutPanel, "Center");
    }

    private void createPackagePanel() {
        this.myPackageTable = ImportLayoutPanel.createTableForPackageEntries(this.myPackageList, this.myImportLayoutPanel);
        this.myPackagesPanel.add((Component)PackagePanel.createPackagesPanel(this.myPackageTable, this.myPackageList), "Center");
    }

    private JPanel createGeneralOptionsPanel() {
        OptionGroup group = new OptionGroup(ApplicationBundle.message((String)"title.general", (Object[])new Object[0]));
        this.myCbUseSingleClassImports = new JCheckBox(JavaBundle.message((String)"checkbox.use.single.class.import", (Object[])new Object[0]));
        group.add((JComponent)this.myCbUseSingleClassImports);
        this.myCbUseFQClassNames = new JCheckBox(JavaBundle.message((String)"checkbox.use.fully.qualified.class.names", (Object[])new Object[0]));
        group.add((JComponent)this.myCbUseFQClassNames);
        this.myCbInsertInnerClassImports = new JCheckBox(JavaBundle.message((String)"checkbox.insert.imports.for.inner.classes", (Object[])new Object[0]));
        group.add((JComponent)this.myCbInsertInnerClassImports);
        this.fillCustomOptions(group);
        this.myClassCountField = new JTextField(3);
        this.myNamesCountField = new JTextField(3);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)new JLabel(JavaBundle.message((String)"editbox.class.count.to.use.import.with.star", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)3), 0, 0));
        panel2.add((Component)this.myClassCountField, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)1), 0, 0));
        panel2.add((Component)new JLabel(JavaBundle.message((String)"editbox.names.count.to.use.static.import.with.star", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.insetsLeft((int)3), 0, 0));
        panel2.add((Component)this.myNamesCountField, new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 17, 0, (Insets)JBUI.insetsLeft((int)1), 0, 0));
        group.add((JComponent)panel2);
        return group.createPanel();
    }

    private void refreshTable(JBTable table, PackageEntryTable packageTable) {
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        table.createDefaultColumnsFromModel();
        model.fireTableDataChanged();
        ImportLayoutPanel.resizeColumns(packageTable, table, this.myImportLayoutPanel.areStaticImportsEnabled());
    }

    public void resetLayoutSettings(ImportsLayoutSettings settings) {
        this.myCbUseFQClassNames.setSelected(settings.isUseFqClassNames());
        this.myCbUseSingleClassImports.setSelected(settings.isUseSingleClassImports());
        this.myCbInsertInnerClassImports.setSelected(settings.isInsertInnerClassImports());
        this.myClassCountField.setText(Integer.toString(settings.getClassCountToUseImportOnDemand()));
        this.myNamesCountField.setText(Integer.toString(settings.getNamesCountToUseImportOnDemand()));
        this.myImportLayoutPanel.getImportLayoutList().copyFrom(settings.getImportLayoutTable());
        this.myPackageList.copyFrom(settings.getPackagesToUseImportOnDemand());
        this.myImportLayoutPanel.getCbLayoutStaticImportsSeparately().setSelected(settings.isLayoutStaticImportsSeparately());
        JBTable importLayoutTable = this.myImportLayoutPanel.getImportLayoutTable();
        AbstractTableModel model = (AbstractTableModel)importLayoutTable.getModel();
        model.fireTableDataChanged();
        model = (AbstractTableModel)this.myPackageTable.getModel();
        model.fireTableDataChanged();
        if (importLayoutTable.getRowCount() > 0) {
            importLayoutTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.myPackageTable.getRowCount() > 0) {
            this.myPackageTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void applyLayoutSettings(ImportsLayoutSettings settings) {
        int value22;
        this.stopTableEditing();
        settings.setLayoutStaticImportsSeparately(this.myImportLayoutPanel.areStaticImportsEnabled());
        settings.setUseFqClassNames(this.myCbUseFQClassNames.isSelected());
        settings.setUseSingleClassImports(this.myCbUseSingleClassImports.isSelected());
        settings.setInsertInnerClassImports(this.myCbInsertInnerClassImports.isSelected());
        try {
            value22 = Integer.parseInt(this.myClassCountField.getText());
            settings.setClassCountToUseImportOnDemand(value22);
        }
        catch (NumberFormatException value22) {
            // empty catch block
        }
        try {
            value22 = Integer.parseInt(this.myNamesCountField.getText());
            settings.setNamesCountToUseImportOnDemand(value22);
        }
        catch (NumberFormatException value3) {
            // empty catch block
        }
        PackageEntryTable list = this.myImportLayoutPanel.getImportLayoutList();
        settings.getImportLayoutTable().copyFrom(CodeStyleImportsPanelBase.getCopyWithoutEmptyPackages(list));
        settings.getPackagesToUseImportOnDemand().copyFrom(CodeStyleImportsPanelBase.getCopyWithoutEmptyPackages(this.myPackageList));
    }

    public boolean isModifiedLayoutSettings(ImportsLayoutSettings settings) {
        boolean isModified = CodeStyleImportsPanelBase.isModified((JCheckBox)this.myImportLayoutPanel.getCbLayoutStaticImportsSeparately(), settings.isLayoutStaticImportsSeparately());
        isModified |= CodeStyleImportsPanelBase.isModified(this.myCbUseFQClassNames, settings.isUseFqClassNames());
        isModified |= CodeStyleImportsPanelBase.isModified(this.myCbUseSingleClassImports, settings.isUseSingleClassImports());
        isModified |= CodeStyleImportsPanelBase.isModified(this.myCbInsertInnerClassImports, settings.isInsertInnerClassImports());
        isModified |= CodeStyleImportsPanelBase.isModified(this.myClassCountField, settings.getClassCountToUseImportOnDemand());
        isModified |= CodeStyleImportsPanelBase.isModified(this.myNamesCountField, settings.getNamesCountToUseImportOnDemand());
        PackageEntryTable list = this.myImportLayoutPanel.getImportLayoutList();
        isModified |= CodeStyleImportsPanelBase.isModified(CodeStyleImportsPanelBase.getCopyWithoutEmptyPackages(list), settings.getImportLayoutTable());
        return isModified |= CodeStyleImportsPanelBase.isModified(CodeStyleImportsPanelBase.getCopyWithoutEmptyPackages(this.myPackageList), settings.getPackagesToUseImportOnDemand());
    }

    private void stopTableEditing() {
        TableUtil.stopEditing((JTable)this.myImportLayoutPanel.getImportLayoutTable());
        TableUtil.stopEditing((JTable)this.myPackageTable);
    }

    protected void fillCustomOptions(OptionGroup group) {
    }

    @NotNull
    private static PackageEntryTable getCopyWithoutEmptyPackages(PackageEntryTable table) {
        PackageEntryTable packageEntryTable;
        try {
            PackageEntryTable copy = (PackageEntryTable)table.clone();
            copy.removeEmptyPackages();
            packageEntryTable = copy;
        }
        catch (CloneNotSupportedException ignored) {
            throw new IllegalStateException("Clone should be supported");
        }
        if (packageEntryTable == null) {
            CodeStyleImportsPanelBase.$$$reportNull$$$0(0);
        }
        return packageEntryTable;
    }

    private static boolean isModified(JTextField textField, int value2) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value2;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected static boolean isModified(JCheckBox checkBox, boolean value2) {
        return checkBox.isSelected() != value2;
    }

    private static boolean isModified(PackageEntryTable list, PackageEntryTable table) {
        if (list.getEntryCount() != table.getEntryCount()) {
            return true;
        }
        for (int i = 0; i < list.getEntryCount(); ++i) {
            PackageEntry entry2;
            PackageEntry entry1 = list.getEntryAt(i);
            if (entry1.equals((Object)(entry2 = table.getEntryAt(i)))) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel5);
        this.myGeneralPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(-1, -1));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPackagesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(-1, -1));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myImportsLayoutPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        jPanel5.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleImportsPanelBase", "getCopyWithoutEmptyPackages"));
    }
}

