/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R-\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\t\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \u0007*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n0\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/completion/CompletionMemory;", "", "()V", "CHOSEN_METHODS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiMethod;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LAST_CHOSEN_METHODS", "Ljava/util/LinkedList;", "Lcom/intellij/openapi/editor/RangeMarker;", "addToMemory", "", "document", "Lcom/intellij/openapi/editor/Document;", "marker", "createChosenMethodMarker", "method", "nameRange", "Lcom/intellij/openapi/util/TextRange;", "getAnchorRange", "call", "Lcom/intellij/psi/PsiCall;", "getChosenMethod", "haveSameRange", "", "s1", "Lcom/intellij/openapi/util/Segment;", "s2", "registerChosenMethod", "intellij.java.impl"})
public final class CompletionMemory {
    private static final Key<LinkedList<RangeMarker>> LAST_CHOSEN_METHODS;
    private static final Key<SmartPsiElementPointer<PsiMethod>> CHOSEN_METHODS;
    public static final CompletionMemory INSTANCE;

    @JvmStatic
    public static final void registerChosenMethod(@NotNull PsiMethod method, @NotNull PsiCall call) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        TextRange textRange = INSTANCE.getAnchorRange(call);
        if (textRange == null) {
            return;
        }
        TextRange nameRange = textRange;
        PsiFile psiFile = call.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"call.containingFile");
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"call.containingFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"call.containingFile.view\u2026ovider.document ?: return");
        Document document2 = document;
        PsiElement psiElement = CompletionUtil.getOriginalOrSelf((PsiElement)((PsiElement)method));
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"CompletionUtil.getOriginalOrSelf(method)");
        INSTANCE.addToMemory(document2, INSTANCE.createChosenMethodMarker(document2, (PsiMethod)psiElement, nameRange));
    }

    private final TextRange getAnchorRange(PsiCall call) {
        Object object;
        PsiCall psiCall = call;
        if (psiCall instanceof PsiMethodCallExpression) {
            PsiReferenceExpression psiReferenceExpression = ((PsiMethodCallExpression)call).getMethodExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression, (String)"call.methodExpression");
            PsiElement psiElement = psiReferenceExpression.getReferenceNameElement();
            object = psiElement != null ? psiElement.getTextRange() : null;
        } else {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement;
            object = psiCall instanceof PsiNewExpression ? ((psiJavaCodeReferenceElement = ((PsiNewExpression)call).getClassOrAnonymousClassReference()) != null && (psiJavaCodeReferenceElement = psiJavaCodeReferenceElement.getReferenceNameElement()) != null ? psiJavaCodeReferenceElement.getTextRange() : null) : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void addToMemory(Document document, RangeMarker marker) {
        LinkedList<RangeMarker> completedMethods = new LinkedList<RangeMarker>();
        LinkedList linkedList = (LinkedList)document.getUserData(LAST_CHOSEN_METHODS);
        if (linkedList != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            LinkedList linkedList2 = linkedList;
            boolean bl = false;
            boolean bl2 = false;
            LinkedList it = linkedList2;
            boolean bl3 = false;
            LinkedList linkedList3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)linkedList3, (String)"it");
            Iterable iterable = linkedList3;
            LinkedList<RangeMarker> linkedList4 = completedMethods;
            boolean $i$f$filter = false;
            void var12_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RangeMarker it2 = (RangeMarker)element$iv$iv;
                boolean bl4 = false;
                if (!(it2.isValid() && !INSTANCE.haveSameRange((Segment)it2, (Segment)marker))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            linkedList4.addAll(list);
        }
        while (completedMethods.size() > 10) {
            completedMethods.remove(0);
        }
        document.putUserData(LAST_CHOSEN_METHODS, completedMethods);
        completedMethods.add(marker);
    }

    private final RangeMarker createChosenMethodMarker(Document document, PsiMethod method, TextRange nameRange) {
        RangeMarker rangeMarker = document.createRangeMarker(nameRange.getStartOffset(), nameRange.getEndOffset());
        Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker, (String)"document.createRangeMark\u2026set, nameRange.endOffset)");
        RangeMarker marker = rangeMarker;
        marker.putUserData(CHOSEN_METHODS, (Object)SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method));
        return marker;
    }

    @JvmStatic
    @Nullable
    public static final PsiMethod getChosenMethod(@NotNull PsiCall call) {
        SmartPsiElementPointer marker;
        SmartPsiElementPointer smartPsiElementPointer;
        SmartPsiElementPointer smartPsiElementPointer2;
        LinkedList completedMethods;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        TextRange textRange = INSTANCE.getAnchorRange(call);
        if (textRange == null) {
            return null;
        }
        TextRange range = textRange;
        PsiFile psiFile = call.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"call.containingFile");
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"call.containingFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        LinkedList linkedList = completedMethods = document != null ? (LinkedList)document.getUserData(LAST_CHOSEN_METHODS) : null;
        if (linkedList != null) {
            Object v5;
            block4: {
                LinkedList linkedList2 = linkedList;
                boolean bl = false;
                boolean bl2 = false;
                LinkedList it = linkedList2;
                boolean bl3 = false;
                Iterable iterable = it;
                boolean bl4 = false;
                Iterable iterable2 = iterable;
                boolean bl5 = false;
                for (Object t : iterable2) {
                    RangeMarker m = (RangeMarker)t;
                    boolean bl6 = false;
                    if (!INSTANCE.haveSameRange((Segment)m, (Segment)range)) continue;
                    v5 = t;
                    break block4;
                }
                v5 = null;
            }
            smartPsiElementPointer2 = v5;
        } else {
            smartPsiElementPointer2 = null;
        }
        return (smartPsiElementPointer = (marker = smartPsiElementPointer2)) != null && (smartPsiElementPointer = (SmartPsiElementPointer)smartPsiElementPointer.getUserData(CHOSEN_METHODS)) != null ? (PsiMethod)smartPsiElementPointer.getElement() : null;
    }

    private final boolean haveSameRange(Segment s1, Segment s2) {
        return s1.getStartOffset() == s2.getStartOffset() && s1.getEndOffset() == s2.getEndOffset();
    }

    private CompletionMemory() {
    }

    static {
        CompletionMemory completionMemory;
        INSTANCE = completionMemory = new CompletionMemory();
        Key key2 = Key.create((String)"COMPLETED_METHODS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<LinkedList<Ra\u2026er>>(\"COMPLETED_METHODS\")");
        LAST_CHOSEN_METHODS = key2;
        Key key3 = Key.create((String)"CHOSEN_METHODS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key3, (String)"Key.create<SmartPsiEleme\u2026ethod>>(\"CHOSEN_METHODS\")");
        CHOSEN_METHODS = key3;
    }
}

