/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.simple;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;

public abstract class ParenthesesTailType
extends TailType {
    protected abstract boolean isSpaceBeforeParentheses(CommonCodeStyleSettings var1, Editor var2, int var3);

    protected abstract boolean isSpaceWithinParentheses(CommonCodeStyleSettings var1, Editor var2, int var3);

    public int processTail(Editor editor, int tailOffset) {
        Document document;
        CommonCodeStyleSettings styleSettings = CommonCodeStyleSettings.getLocalCodeStyleSettings((Editor)editor, (int)tailOffset);
        if (this.isSpaceBeforeParentheses(styleSettings, editor, tailOffset)) {
            tailOffset = ParenthesesTailType.insertChar((Editor)editor, (int)tailOffset, (char)' ');
        }
        if (tailOffset < (document = editor.getDocument()).getTextLength() && document.getCharsSequence().charAt(tailOffset) == '(') {
            return ParenthesesTailType.moveCaret((Editor)editor, (int)tailOffset, (int)1);
        }
        if (this.isSpaceWithinParentheses(styleSettings, editor, tailOffset = ParenthesesTailType.insertChar((Editor)editor, (int)tailOffset, (char)'('))) {
            tailOffset = ParenthesesTailType.insertChar((Editor)editor, (int)tailOffset, (char)' ');
            tailOffset = ParenthesesTailType.insertChar((Editor)editor, (int)tailOffset, (char)' ');
            tailOffset = ParenthesesTailType.insertChar((Editor)editor, (int)tailOffset, (char)')');
            ParenthesesTailType.moveCaret((Editor)editor, (int)tailOffset, (int)-2);
        } else {
            tailOffset = ParenthesesTailType.insertChar((Editor)editor, (int)tailOffset, (char)')');
            ParenthesesTailType.moveCaret((Editor)editor, (int)tailOffset, (int)-1);
            TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(editor);
        }
        return tailOffset;
    }
}

