/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ProjectSdkSetupValidator;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkPopupBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectSdkSetupValidator
implements ProjectSdkSetupValidator {
    public static final JavaProjectSdkSetupValidator INSTANCE = new JavaProjectSdkSetupValidator();

    public boolean isApplicableFor(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile;
        if (project == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(1);
        }
        if (file.getFileType() != JavaClassFileType.INSTANCE && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null) {
            return psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
        }
        return false;
    }

    @Nullable
    public String getErrorMessage(@NotNull Project project, @NotNull VirtualFile file) {
        Sdk sdk;
        Module module;
        if (project == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null && !module.isDisposed() && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null) {
            if (ModuleRootManager.getInstance((Module)module).isSdkInherited()) {
                return JavaUiBundle.message("project.sdk.not.defined", new Object[0]);
            }
            return JavaUiBundle.message("module.sdk.not.defined", new Object[0]);
        }
        return null;
    }

    @NotNull
    private static SdkPopupBuilder preparePopup(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(5);
        }
        SdkPopupBuilder sdkPopupBuilder = SdkPopupFactory.newBuilder().withProject(project).withSdkTypeFilter(type2 -> type2 instanceof JavaSdkType).updateSdkForFile(file);
        if (sdkPopupBuilder == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(6);
        }
        return sdkPopupBuilder;
    }

    @NotNull
    public EditorNotificationPanel.ActionHandler getFixHandler(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(7);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(8);
        }
        EditorNotificationPanel.ActionHandler actionHandler = JavaProjectSdkSetupValidator.preparePopup(project, file).buildEditorNotificationPanelHandler();
        if (actionHandler == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(9);
        }
        return actionHandler;
    }

    @Deprecated
    public void doFix(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(10);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(11);
        }
        JavaProjectSdkSetupValidator.preparePopup(project, file).buildPopup().showInFocusCenter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaProjectSdkSetupValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaProjectSdkSetupValidator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preparePopup";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFixHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

