/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateAnnotationMethodFromUsageFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationAttributeNameFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;

    public AddAnnotationAttributeNameFix(PsiNameValuePair pair2, String name2) {
        super((PsiElement)pair2);
        this.myName = name2;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.annotation.attribute.name", this.myName);
        if (string == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.annotation.attribute.name.family.name", new Object[0]);
        if (string == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(5);
        }
        AddAnnotationAttributeNameFix.doFix((PsiNameValuePair)startElement, this.myName);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(9);
        }
        return super.isAvailable(project, file, startElement, endElement) && startElement instanceof PsiNameValuePair;
    }

    @NotNull
    public static List<IntentionAction> createFixes(@NotNull PsiNameValuePair pair2) {
        PsiAnnotationMemberValue value2;
        if (pair2 == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(10);
        }
        if ((value2 = pair2.getValue()) == null || pair2.getName() != null) {
            List<IntentionAction> list = Collections.emptyList();
            if (list == null) {
                AddAnnotationAttributeNameFix.$$$reportNull$$$0(11);
            }
            return list;
        }
        Collection<String> methodNames = AddAnnotationAttributeNameFix.getAvailableAnnotationMethodNames(pair2);
        List list = ContainerUtil.map2List(methodNames, name2 -> new AddAnnotationAttributeNameFix(pair2, (String)name2));
        if (list == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(12);
        }
        return list;
    }

    public static void doFix(@NotNull PsiNameValuePair annotationParameter, @NotNull String name2) {
        if (annotationParameter == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(13);
        }
        if (name2 == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(14);
        }
        String text2 = AddAnnotationAttributeNameFix.buildReplacementText(annotationParameter, name2);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)annotationParameter.getProject());
        PsiAnnotation newAnnotation = factory.createAnnotationFromText("@A(" + text2 + " )", (PsiElement)annotationParameter);
        annotationParameter.replace((PsiElement)newAnnotation.getParameterList().getAttributes()[0]);
    }

    private static String buildReplacementText(@NotNull PsiNameValuePair annotationParameter, @NotNull String name2) {
        PsiAnnotationMemberValue value2;
        if (annotationParameter == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(16);
        }
        return (value2 = annotationParameter.getValue()) != null ? name2 + "=" + value2.getText() : name2 + "=";
    }

    public static boolean isCompatibleReturnType(@NotNull PsiMethod psiMethod, @Nullable PsiType valueType) {
        PsiType expectedType;
        if (psiMethod == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(17);
        }
        if ((expectedType = psiMethod.getReturnType()) == null || valueType == null || expectedType.isAssignableFrom(valueType)) {
            return true;
        }
        if (expectedType instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)expectedType).getComponentType();
            return componentType.isAssignableFrom(valueType);
        }
        return false;
    }

    @NotNull
    private static Collection<String> getAvailableAnnotationMethodNames(@NotNull PsiNameValuePair pair2) {
        PsiAnnotationParameterList parameterList;
        PsiClass annotationClass;
        PsiElement parent;
        PsiAnnotationMemberValue value2;
        if (pair2 == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(18);
        }
        if ((value2 = pair2.getValue()) != null && pair2.getName() == null && (parent = pair2.getParent()) instanceof PsiAnnotationParameterList && (annotationClass = AddAnnotationAttributeNameFix.getAnnotationClass(parameterList = (PsiAnnotationParameterList)parent)) != null) {
            Set<String> usedNames = AddAnnotationAttributeNameFix.getUsedAttributeNames(parameterList);
            Collection availableMethods = Arrays.stream(annotationClass.getMethods()).filter(PsiAnnotationMethod.class::isInstance).filter(psiMethod -> !usedNames.contains(psiMethod.getName())).collect(Collectors.toList());
            if (!availableMethods.isEmpty()) {
                PsiType valueType = CreateAnnotationMethodFromUsageFix.getAnnotationValueType(value2);
                Collection collection = availableMethods.stream().filter(psiMethod -> AddAnnotationAttributeNameFix.isCompatibleReturnType(psiMethod, valueType)).map(PsiMethod::getName).collect(Collectors.toSet());
                if (collection == null) {
                    AddAnnotationAttributeNameFix.$$$reportNull$$$0(19);
                }
                return collection;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public static Set<String> getUsedAttributeNames(@NotNull PsiAnnotationParameterList parameterList) {
        if (parameterList == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(21);
        }
        Set<String> set = Arrays.stream(parameterList.getAttributes()).map(PsiNameValuePair::getName).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(22);
        }
        return set;
    }

    @Nullable
    private static PsiClass getAnnotationClass(@NotNull PsiAnnotationParameterList parameterList) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement reference;
        PsiElement parent;
        if (parameterList == null) {
            AddAnnotationAttributeNameFix.$$$reportNull$$$0(23);
        }
        if ((parent = parameterList.getParent()) instanceof PsiAnnotation && (reference = ((PsiAnnotation)parent).getNameReferenceElement()) != null && (resolved = reference.resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType()) {
            return (PsiClass)resolved;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationParameter";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddAnnotationAttributeNameFix";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableAnnotationMethodNames";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedAttributeNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacementText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleReturnType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableAnnotationMethodNames";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getUsedAttributeNames";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

