/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BringVariableIntoScopeFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(BringVariableIntoScopeFix.class);
    private final PsiReferenceExpression myUnresolvedReference;
    private volatile PsiLocalVariable myOutOfScopeVariable;

    BringVariableIntoScopeFix(@NotNull PsiReferenceExpression unresolvedReference) {
        if (unresolvedReference == null) {
            BringVariableIntoScopeFix.$$$reportNull$$$0(0);
        }
        this.myUnresolvedReference = unresolvedReference;
    }

    @NotNull
    public String getText() {
        PsiLocalVariable variable = this.myOutOfScopeVariable;
        String varText = variable == null || !variable.isValid() ? "" : PsiFormatUtil.formatVariable((PsiVariable)variable, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        String string = QuickFixBundle.message("bring.variable.to.scope.text", varText);
        if (string == null) {
            BringVariableIntoScopeFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("bring.variable.to.scope.family", new Object[0]);
        if (string == null) {
            BringVariableIntoScopeFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            BringVariableIntoScopeFix.$$$reportNull$$$0(3);
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (!this.myUnresolvedReference.isValid() || !BaseIntentionAction.canModify((PsiElement)this.myUnresolvedReference)) {
            return false;
        }
        PsiLocalVariable variable = this.myOutOfScopeVariable;
        if (variable != null && !variable.isValid()) {
            return false;
        }
        if (this.myUnresolvedReference.isQualified()) {
            return false;
        }
        final String referenceName = this.myUnresolvedReference.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)this.myUnresolvedReference, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class});
        if (!(container instanceof PsiCodeBlock)) {
            return false;
        }
        while (container.getParent() instanceof PsiStatement || container.getParent() instanceof PsiCatchSection) {
            container = container.getParent();
        }
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            PsiLocalVariable myOutOfScopeVariable;

            Visitor() {
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
            }

            public void visitExpression(PsiExpression expression2) {
            }

            public void visitLocalVariable(PsiLocalVariable variable) {
                if (referenceName.equals(variable.getName())) {
                    this.myOutOfScopeVariable = this.myOutOfScopeVariable == null ? variable : null;
                }
            }
        }
        Visitor visitor2 = new Visitor();
        container.accept((PsiElementVisitor)visitor2);
        this.myOutOfScopeVariable = variable = visitor2.myOutOfScopeVariable;
        return variable != null && !(variable instanceof PsiResourceVariable);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        PsiLocalVariable child;
        PsiLocalVariable outOfScopeVariable;
        if (project == null) {
            BringVariableIntoScopeFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            BringVariableIntoScopeFix.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((outOfScopeVariable = this.myOutOfScopeVariable) != null);
        PsiManager manager = file.getManager();
        outOfScopeVariable.normalizeDeclaration();
        PsiUtil.setModifierProperty((PsiModifierListOwner)outOfScopeVariable, (String)"final", (boolean)false);
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)outOfScopeVariable, (PsiElement)this.myUnresolvedReference);
        LOG.assertTrue(commonParent != null);
        Object object = child = outOfScopeVariable.getTextRange().getStartOffset() < this.myUnresolvedReference.getTextRange().getStartOffset() ? outOfScopeVariable : this.myUnresolvedReference;
        while (child.getParent() != commonParent) {
            child = child.getParent();
        }
        PsiDeclarationStatement newDeclaration = (PsiDeclarationStatement)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createStatementFromText("int i = 0", null);
        PsiVariable variable = (PsiVariable)newDeclaration.getDeclaredElements()[0].replace((PsiElement)outOfScopeVariable);
        if (variable.getInitializer() != null) {
            variable.getInitializer().delete();
        }
        while (!(child instanceof PsiStatement) || !(child.getParent() instanceof PsiCodeBlock)) {
            child = child.getParent();
            commonParent = commonParent.getParent();
        }
        LOG.assertTrue(commonParent != null);
        PsiDeclarationStatement added = (PsiDeclarationStatement)commonParent.addBefore((PsiElement)newDeclaration, (PsiElement)child);
        PsiElement[] declaredElements = added.getDeclaredElements();
        LOG.assertTrue(declaredElements.length > 0, (Object)added.getText());
        PsiLocalVariable addedVar = (PsiLocalVariable)declaredElements[0];
        assert (addedVar != null) : added;
        CodeStyleManager.getInstance((Project)manager.getProject()).reformat(commonParent);
        PsiExpression initializer = outOfScopeVariable.getInitializer();
        if (initializer != null) {
            PsiExpressionStatement assignment = (PsiExpressionStatement)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createStatementFromText(outOfScopeVariable.getName() + "= e;", null);
            Objects.requireNonNull(((PsiAssignmentExpression)assignment.getExpression()).getRExpression()).replace((PsiElement)initializer);
            assignment = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)manager.getProject()).reformat((PsiElement)assignment);
            PsiDeclarationStatement declStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)outOfScopeVariable, PsiDeclarationStatement.class);
            LOG.assertTrue(declStatement != null);
            PsiElement parent = declStatement.getParent();
            if (parent instanceof PsiForStatement) {
                declStatement.replace((PsiElement)assignment);
            } else {
                parent.addAfter((PsiElement)assignment, (PsiElement)declStatement);
            }
        }
        if (outOfScopeVariable.isValid()) {
            outOfScopeVariable.delete();
        }
        if (HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(this.myUnresolvedReference, (PsiVariable)addedVar, (Map<PsiElement, Collection<PsiReferenceExpression>>)new THashMap(), file) != null) {
            BringVariableIntoScopeFix.initialize(addedVar);
        }
    }

    private static void initialize(PsiLocalVariable variable) throws IncorrectOperationException {
        PsiType type2 = variable.getType();
        String init2 = PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        PsiExpression initializer = factory.createExpressionFromText(init2, (PsiElement)variable);
        variable.setInitializer(initializer);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/BringVariableIntoScopeFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/BringVariableIntoScopeFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

