/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLocalFromUsageFix
extends CreateVarFromUsageFix {
    private static final Logger LOG = Logger.getInstance(CreateLocalFromUsageFix.class);

    public CreateLocalFromUsageFix(PsiReferenceExpression referenceExpression) {
        super(referenceExpression);
    }

    @Override
    public String getText(String varName) {
        return CreateLocalFromUsageFix.getMessage(varName);
    }

    @NotNull
    public static String getMessage(String varName) {
        String string = CommonQuickFixBundle.message((String)"fix.create.title.x", (Object[])new Object[]{JavaElementKind.LOCAL_VARIABLE.object(), varName});
        if (string == null) {
            CreateLocalFromUsageFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiMethod method;
        PsiExpression expression2;
        if (!super.isAvailableImpl(offset)) {
            return false;
        }
        if (this.myReferenceExpression.isQualified()) {
            return false;
        }
        PsiStatement anchor = CreateLocalFromUsageFix.getAnchor(new PsiExpression[]{this.myReferenceExpression});
        if (anchor == null) {
            return false;
        }
        return !(anchor instanceof PsiExpressionStatement) || !((expression2 = ((PsiExpressionStatement)anchor).getExpression()) instanceof PsiMethodCallExpression) || (method = ((PsiMethodCallExpression)expression2).resolveMethod()) == null || !method.isConstructor();
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) {
        PsiAssignmentExpression assignment;
        PsiType type2;
        if (project == null) {
            CreateLocalFromUsageFix.$$$reportNull$$$0(1);
        }
        String varName = this.myReferenceExpression.getReferenceName();
        if (CreateFromUsageUtils.isValidReference((PsiReference)this.myReferenceExpression, false) || varName == null) {
            return;
        }
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiType[] expectedTypes = CreateFromUsageUtils.guessType((PsiExpression)this.myReferenceExpression, false);
        final SmartTypePointer defaultType = SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(expectedTypes[0]);
        PsiType preferredType = TypeSelectorManagerImpl.getPreferredType(expectedTypes, expectedTypes[0]);
        PsiType psiType = type2 = preferredType != null ? preferredType : expectedTypes[0];
        if (LambdaUtil.notInferredType((PsiType)type2)) {
            type2 = PsiType.getJavaLangObject((PsiManager)this.myReferenceExpression.getManager(), (GlobalSearchScope)file.getResolveScope());
        }
        PsiExpression initializer = null;
        boolean isInline = false;
        PsiReferenceExpression[] expressions2 = CreateFromUsageUtils.collectExpressions((PsiExpression)this.myReferenceExpression, PsiMember.class, PsiFile.class);
        PsiStatement anchor = CreateLocalFromUsageFix.getAnchor((PsiExpression[])expressions2);
        if (anchor == null && (anchor = CreateLocalFromUsageFix.getAnchor((PsiExpression[])(expressions2 = new PsiExpression[]{this.myReferenceExpression}))) == null) {
            return;
        }
        if (anchor instanceof PsiExpressionStatement && ((PsiExpressionStatement)anchor).getExpression() instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)((PsiExpressionStatement)anchor).getExpression()).getLExpression().textMatches((PsiElement)this.myReferenceExpression)) {
            initializer = assignment.getRExpression();
            isInline = true;
        }
        PsiDeclarationStatement decl = factory.createVariableDeclarationStatement(varName, type2, initializer);
        TypeExpression expression2 = new TypeExpression(project, expectedTypes);
        if (isInline) {
            PsiElement nextSibling;
            PsiExpression expr2 = ((PsiExpressionStatement)anchor).getExpression();
            PsiElement semicolon = expr2.getNextSibling();
            if (semicolon != null && (nextSibling = semicolon.getNextSibling()) != null) {
                decl.addRange(nextSibling, anchor.getLastChild());
            }
            decl = (PsiDeclarationStatement)anchor.replace((PsiElement)decl);
        } else {
            decl = (PsiDeclarationStatement)anchor.getParent().addBefore((PsiElement)decl, (PsiElement)anchor);
        }
        PsiVariable var = (PsiVariable)decl.getDeclaredElements()[0];
        boolean isFinal = JavaCodeStyleSettings.getInstance((PsiFile)file).GENERATE_FINAL_LOCALS && !CreateFromUsageUtils.isAccessedForWriting((PsiExpression[])expressions2);
        PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)isFinal);
        var = (PsiVariable)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)var);
        if (var == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)var);
        PsiTypeElement typeElement = var.getTypeElement();
        LOG.assertTrue(typeElement != null);
        builder.replaceElement((PsiElement)typeElement, AbstractJavaInplaceIntroducer.createExpression(expression2, typeElement.getText()));
        builder.setEndVariableAfter((PsiElement)var.getNameIdentifier());
        Template template = builder.buildTemplate();
        final Editor newEditor = CreateLocalFromUsageFix.positionCursor(project, file, (PsiElement)var);
        if (newEditor == null) {
            return;
        }
        TextRange range = var.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        CreateLocalFromUsageFix.startTemplate(newEditor, template, project, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(newEditor.getDocument());
                int offset = newEditor.getCaretModel().getOffset();
                PsiLocalVariable localVariable = (PsiLocalVariable)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiLocalVariable.class, (boolean)false);
                if (localVariable != null) {
                    TypeSelectorManagerImpl.typeSelected(localVariable.getType(), defaultType.getType());
                    ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance((Project)project).reformat((PsiElement)localVariable));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalFromUsageFix$1", "templateFinished"));
            }
        });
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return false;
    }

    @Nullable
    private static PsiStatement getAnchor(PsiExpression ... expressionOccurrences) {
        PsiExpression parent = expressionOccurrences[0];
        int minOffset = expressionOccurrences[0].getTextRange().getStartOffset();
        for (int i = 1; i < expressionOccurrences.length; ++i) {
            LOG.assertTrue((parent = PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)expressionOccurrences[i])) != null);
            minOffset = Math.min(minOffset, expressionOccurrences[i].getTextRange().getStartOffset());
        }
        PsiCodeBlock block = null;
        while (parent != null) {
            if (parent instanceof PsiCodeBlock) {
                block = (PsiCodeBlock)parent;
                break;
            }
            if (parent instanceof PsiSwitchLabeledRuleStatement) {
                parent = ((PsiSwitchLabeledRuleStatement)parent).getEnclosingSwitchBlock();
                continue;
            }
            parent = parent.getParent();
        }
        if (block == null) {
            return null;
        }
        PsiStatement[] statements = block.getStatements();
        for (int i = 1; i < statements.length; ++i) {
            if (statements[i].getTextRange().getStartOffset() <= minOffset) continue;
            return statements[i - 1];
        }
        return statements[statements.length - 1];
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.local.from.usage.family", new Object[0]);
        if (string == null) {
            CreateLocalFromUsageFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalFromUsageFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalFromUsageFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

