/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddVariableInitializerFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorParameterFromFieldFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitializeFinalFieldInConstructorFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(InitializeFinalFieldInConstructorFix.class);

    public InitializeFinalFieldInConstructorFix(@NotNull PsiField field) {
        if (field == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)field);
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("initialize.final.field.in.constructor.name", new Object[0]);
        if (string == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiField field;
        if (project == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(6);
        }
        if ((field = (PsiField)ObjectUtils.tryCast((Object)startElement, PsiField.class)) == null) {
            return false;
        }
        if (!field.isValid() || field.hasModifierProperty("static") || field.hasInitializer()) {
            return false;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null || containingClass.getName() == null) {
            return false;
        }
        PsiManager manager = field.getManager();
        return manager != null && BaseIntentionAction.canModify((PsiElement)field);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiField field;
        if (project == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(7);
        }
        if (file == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(10);
        }
        if ((field = (PsiField)ObjectUtils.tryCast((Object)startElement, PsiField.class)) == null) {
            return;
        }
        PsiClass myClass = field.getContainingClass();
        if (myClass == null) {
            return;
        }
        if (myClass.getConstructors().length == 0) {
            InitializeFinalFieldInConstructorFix.createDefaultConstructor(myClass, project, editor, file);
        }
        PsiMethod[] ctors = CreateConstructorParameterFromFieldFix.filterConstructorsIfFieldAlreadyAssigned(myClass.getConstructors(), field).toArray(PsiMethod.EMPTY_ARRAY);
        List<PsiMethod> constructors = InitializeFinalFieldInConstructorFix.choose(ctors, project);
        ApplicationManager.getApplication().runWriteAction(() -> InitializeFinalFieldInConstructorFix.addFieldInitialization(constructors, field, project, editor));
    }

    private static void addFieldInitialization(@NotNull List<? extends PsiMethod> constructors, @NotNull PsiField field, @NotNull Project project, @Nullable Editor editor) {
        if (constructors == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(11);
        }
        if (field == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(12);
        }
        if (project == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(13);
        }
        if (constructors.isEmpty()) {
            return;
        }
        LookupElement[] suggestedInitializers = AddVariableInitializerFix.suggestInitializer((PsiVariable)field);
        ArrayList<PsiExpression> rExpressions = new ArrayList<PsiExpression>(constructors.size());
        for (PsiMethod psiMethod : constructors) {
            rExpressions.add(InitializeFinalFieldInConstructorFix.addFieldInitialization(psiMethod, suggestedInitializers, field, project));
        }
        Document doc = Objects.requireNonNull(PsiDocumentManager.getInstance((Project)project).getDocument(field.getContainingFile()));
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
        AddVariableInitializerFix.runAssignmentTemplate(rExpressions, suggestedInitializers, editor);
    }

    @NotNull
    private static PsiExpression addFieldInitialization(@NotNull PsiMethod constructor, LookupElement @NotNull [] suggestedInitializers, @NotNull PsiField field, @NotNull Project project) {
        PsiCodeBlock methodBody2;
        if (constructor == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(14);
        }
        if (field == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(15);
        }
        if (project == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(16);
        }
        if (suggestedInitializers == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(17);
        }
        if ((methodBody2 = constructor.getBody()) == null) {
            CreateFromUsageUtils.setupMethodBody(constructor);
            methodBody2 = constructor.getBody();
            LOG.assertTrue(methodBody2 != null);
        }
        String fieldName = field.getName();
        String stmtText = fieldName + " = " + suggestedInitializers[0].getPsiElement().getText() + ";";
        if (InitializeFinalFieldInConstructorFix.methodContainsParameterWithName(constructor, fieldName)) {
            stmtText = "this." + stmtText;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiExpressionStatement addedStatement = (PsiExpressionStatement)methodBody2.add(codeStyleManager.reformat((PsiElement)factory.createStatementFromText(stmtText, (PsiElement)methodBody2)));
        PsiExpression psiExpression = Objects.requireNonNull(((PsiAssignmentExpression)addedStatement.getExpression()).getRExpression());
        if (psiExpression == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(18);
        }
        return psiExpression;
    }

    private static boolean methodContainsParameterWithName(@NotNull PsiMethod constructor, @NotNull String name2) {
        if (constructor == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(19);
        }
        if (name2 == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(20);
        }
        for (PsiParameter parameter2 : constructor.getParameterList().getParameters()) {
            if (!name2.equals(parameter2.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<PsiMethod> choose(PsiMethod @NotNull [] ctors, @NotNull Project project) {
        if (project == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(21);
        }
        if (ctors == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(22);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List<PsiMethod> list = Arrays.asList(ctors);
            if (list == null) {
                InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (ctors.length == 1) {
            List<PsiMethod> list = Collections.singletonList(ctors[0]);
            if (list == null) {
                InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(24);
            }
            return list;
        }
        if (ctors.length > 1) {
            MemberChooser chooser = new MemberChooser((ClassMember[])InitializeFinalFieldInConstructorFix.toPsiMethodMemberArray(ctors), false, true, project);
            chooser.setTitle(QuickFixBundle.message("initialize.final.field.in.constructor.choose.dialog.title", new Object[0]));
            chooser.show();
            List chosenMembers = chooser.getSelectedElements();
            if (chosenMembers != null) {
                List<PsiMethod> list = Arrays.asList(InitializeFinalFieldInConstructorFix.toPsiMethodArray(chosenMembers));
                if (list == null) {
                    InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(25);
                }
                return list;
            }
        }
        List<PsiMethod> list = Collections.emptyList();
        if (list == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(26);
        }
        return list;
    }

    private static PsiMethodMember @NotNull [] toPsiMethodMemberArray(PsiMethod @NotNull [] methods) {
        if (methods == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(27);
        }
        PsiMethodMember[] result = new PsiMethodMember[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new PsiMethodMember(methods[i]);
        }
        if (result == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(28);
        }
        return result;
    }

    private static PsiMethod @NotNull [] toPsiMethodArray(@NotNull List<? extends PsiMethodMember> methodMembers) {
        if (methodMembers == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(29);
        }
        PsiMethod[] result = new PsiMethod[methodMembers.size()];
        int i = 0;
        for (PsiMethodMember psiMethodMember : methodMembers) {
            result[i++] = (PsiMethod)psiMethodMember.getElement();
        }
        if (result == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(30);
        }
        return result;
    }

    private static void createDefaultConstructor(PsiClass psiClass, @NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(31);
        }
        AddDefaultConstructorFix defaultConstructorFix = new AddDefaultConstructorFix(psiClass);
        ApplicationManager.getApplication().runWriteAction(() -> defaultConstructorFix.invoke(project, editor, file));
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            InitializeFinalFieldInConstructorFix.$$$reportNull$$$0(32);
        }
        return currentFile;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 16: 
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructors";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedInitializers";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctors";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodMembers";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addFieldInitialization";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiMethodMemberArray";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiMethodArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addFieldInitialization";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "methodContainsParameterWithName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "choose";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toPsiMethodMemberArray";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "toPsiMethodArray";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultConstructor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

