/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.RunRefactoringAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.extractInterface.ExtractInterfaceHandler;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler;
import com.intellij.refactoring.memberPullUp.JavaPullUpHandler;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PullAsAbstractUpFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(PullAsAbstractUpFix.class);
    private final String myName;

    public PullAsAbstractUpFix(PsiMethod psiMethod, String name2) {
        super((PsiElement)psiMethod);
        this.myName = name2;
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CommonBundle.message((String)"title.pull.up", (Object[])new Object[0]);
        if (string == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(5);
        }
        return startElement instanceof PsiMethod && ((PsiMethod)startElement).getContainingClass() != null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(9);
        }
        final PsiMethod method = (PsiMethod)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(method.getContainingFile())) {
            return;
        }
        final PsiClass containingClass = method.getContainingClass();
        LOG.assertTrue(containingClass != null);
        PsiManager manager = containingClass.getManager();
        if (containingClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)containingClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass != null && BaseIntentionAction.canModify((PsiElement)baseClass)) {
                PullAsAbstractUpFix.pullUp(method, containingClass, baseClass);
            }
        } else {
            LinkedHashSet classesToPullUp = new LinkedHashSet();
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getExtendsListTypes());
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getImplementsListTypes());
            if (classesToPullUp.isEmpty()) {
                new ExtractInterfaceHandler().invoke(project, new PsiElement[]{containingClass}, null);
            } else if (classesToPullUp.size() == 1) {
                PullAsAbstractUpFix.pullUp(method, containingClass, (PsiClass)classesToPullUp.iterator().next());
            } else if (editor != null) {
                NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])classesToPullUp.toArray(PsiClass.EMPTY_ARRAY)), (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)"Choose super class", (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                    public boolean execute(@NotNull PsiClass aClass) {
                        if (aClass == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        PullAsAbstractUpFix.pullUp(method, containingClass, aClass);
                        return false;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix$1", "execute"));
                    }
                }, (PsiElement)((PsiElement)classesToPullUp.iterator().next())).showInBestPositionFor(editor);
            }
        }
    }

    private static void collectClassesToPullUp(PsiManager manager, LinkedHashSet<? super PsiClass> classesToPullUp, PsiClassType[] extendsListTypes) {
        for (PsiClassType extendsListType : extendsListTypes) {
            PsiClass resolve2 = extendsListType.resolve();
            if (resolve2 == null || !BaseIntentionAction.canModify((PsiElement)resolve2)) continue;
            classesToPullUp.add((PsiClass)resolve2);
        }
    }

    private static void pullUp(PsiMethod method, PsiClass containingClass, PsiClass baseClass) {
        if (!FileModificationService.getInstance().prepareFileForWrite(baseClass.getContainingFile())) {
            return;
        }
        MemberInfo memberInfo = new MemberInfo((PsiMember)method);
        memberInfo.setChecked(true);
        memberInfo.setToAbstract(true);
        new PullUpProcessor(containingClass, baseClass, new MemberInfo[]{memberInfo}, new DocCommentPolicy(0)).run();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void registerQuickFix(@NotNull PsiMethod methodWithOverrides, @NotNull QuickFixActionRegistrar registrar) {
        PsiClass containingClass;
        if (methodWithOverrides == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(10);
        }
        if (registrar == null) {
            PullAsAbstractUpFix.$$$reportNull$$$0(11);
        }
        if ((containingClass = methodWithOverrides.getContainingClass()) == null) {
            return;
        }
        PsiManager manager = containingClass.getManager();
        boolean canBePulledUp = true;
        String name2 = "Pull method '" + methodWithOverrides.getName() + "' up";
        if (containingClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)containingClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null) {
                return;
            }
            if (!BaseIntentionAction.canModify((PsiElement)baseClass)) {
                return;
            }
            if (!baseClass.hasModifierProperty("abstract")) {
                name2 = "Pull method '" + methodWithOverrides.getName() + "' up and make it abstract";
            }
        } else {
            LinkedHashSet classesToPullUp = new LinkedHashSet();
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getExtendsListTypes());
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getImplementsListTypes());
            if (classesToPullUp.isEmpty()) {
                name2 = "Extract method '" + methodWithOverrides.getName() + "' to new interface";
                canBePulledUp = false;
            } else if (classesToPullUp.size() == 1) {
                PsiClass baseClass = (PsiClass)classesToPullUp.iterator().next();
                name2 = "Pull method '" + methodWithOverrides.getName() + "' to '" + baseClass.getName() + "'";
                if (!baseClass.hasModifierProperty("abstract")) {
                    name2 = name2 + " and make it abstract";
                }
            }
            registrar.register((IntentionAction)new RunRefactoringAction(new ExtractInterfaceHandler(), "Extract interface"));
            registrar.register((IntentionAction)new RunRefactoringAction((RefactoringActionHandler)new ExtractSuperclassHandler(), "Extract superclass"));
        }
        if (canBePulledUp) {
            registrar.register((IntentionAction)new RunRefactoringAction(new JavaPullUpHandler(), "Pull members up"));
        }
        registrar.register((IntentionAction)new PullAsAbstractUpFix(methodWithOverrides, name2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodWithOverrides";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/PullAsAbstractUpFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerQuickFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

