/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceIteratorForEachLoopWithIteratorForLoopFix
implements IntentionAction {
    private final PsiForeachStatement myStatement;

    public ReplaceIteratorForEachLoopWithIteratorForLoopFix(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            ReplaceIteratorForEachLoopWithIteratorForLoopFix.$$$reportNull$$$0(0);
        }
        this.myStatement = statement;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ReplaceIteratorForEachLoopWithIteratorForLoopFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("replace.for.each.loop.with.iterator.for.loop", new Object[0]);
        if (string == null) {
            ReplaceIteratorForEachLoopWithIteratorForLoopFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ReplaceIteratorForEachLoopWithIteratorForLoopFix.$$$reportNull$$$0(3);
        }
        return this.myStatement.isValid() && BaseIntentionAction.canModify((PsiElement)this.myStatement);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiModifierList modifierList;
        PsiExpression iteratedValue2;
        if (project == null) {
            ReplaceIteratorForEachLoopWithIteratorForLoopFix.$$$reportNull$$$0(4);
        }
        if ((iteratedValue2 = this.myStatement.getIteratedValue()) == null) {
            return;
        }
        PsiType iteratedValueType = iteratedValue2.getType();
        if (iteratedValueType == null) {
            return;
        }
        PsiParameter iterationParameter = this.myStatement.getIterationParameter();
        String iterationParameterName = iterationParameter.getName();
        PsiStatement forEachBody = this.myStatement.getBody();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        String name2 = new VariableNameGenerator((PsiElement)this.myStatement, VariableKind.LOCAL_VARIABLE).byName("it", "iter", "iterator").generate(true);
        PsiForStatement newForLoop = (PsiForStatement)elementFactory.createStatementFromText("for (Iterator " + name2 + " = initializer; " + name2 + ".hasNext();) { Object next = " + name2 + ".next(); }", (PsiElement)this.myStatement);
        PsiDeclarationStatement newDeclaration = (PsiDeclarationStatement)newForLoop.getInitialization();
        if (newDeclaration == null) {
            return;
        }
        PsiLocalVariable newIteratorVariable = (PsiLocalVariable)newDeclaration.getDeclaredElements()[0];
        PsiTypeElement newIteratorTypeElement = elementFactory.createTypeElement(iteratedValueType);
        newIteratorVariable.getTypeElement().replace((PsiElement)newIteratorTypeElement);
        newIteratorVariable.setInitializer(iteratedValue2);
        PsiBlockStatement newBody = (PsiBlockStatement)newForLoop.getBody();
        if (newBody == null) {
            return;
        }
        PsiCodeBlock newBodyBlock = newBody.getCodeBlock();
        PsiDeclarationStatement newFirstStatement = (PsiDeclarationStatement)newBodyBlock.getStatements()[0];
        PsiLocalVariable newItemVariable = (PsiLocalVariable)newFirstStatement.getDeclaredElements()[0];
        PsiTypeElement newItemTypeElement = elementFactory.createTypeElement(iterationParameter.getType());
        newItemVariable.getTypeElement().replace((PsiElement)newItemTypeElement);
        newItemVariable.setName(iterationParameterName);
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file);
        if (((JavaCodeStyleSettings)codeStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_LOCALS && (modifierList = newItemVariable.getModifierList()) != null) {
            modifierList.setModifierProperty("final", true);
        }
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        newForLoop = (PsiForStatement)javaStyleManager.shortenClassReferences((PsiElement)newForLoop);
        newForLoop = (PsiForStatement)styleManager.reformat((PsiElement)newForLoop);
        if (forEachBody instanceof PsiBlockStatement) {
            PsiCodeBlock bodyCodeBlock = ((PsiBlockStatement)forEachBody).getCodeBlock();
            PsiElement firstBodyElement = bodyCodeBlock.getFirstBodyElement();
            PsiElement lastBodyElement = bodyCodeBlock.getLastBodyElement();
            if (firstBodyElement != null && lastBodyElement != null) {
                newBodyBlock.addRangeAfter(firstBodyElement, lastBodyElement, (PsiElement)newFirstStatement);
            }
        } else if (forEachBody != null && !(forEachBody instanceof PsiEmptyStatement)) {
            newBodyBlock.addAfter((PsiElement)forEachBody, (PsiElement)newFirstStatement);
        }
        this.myStatement.replace((PsiElement)newForLoop);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceIteratorForEachLoopWithIteratorForLoopFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceIteratorForEachLoopWithIteratorForLoopFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

