/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems.ui;

import com.intellij.codeInsight.daemon.problems.ui.ProjectProblemsView;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ui/ProjectProblemsViewImpl;", "Lcom/intellij/codeInsight/daemon/problems/ui/ProjectProblemsView;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "panel", "Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel;", "addProblem", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "message", "", "place", "Lcom/intellij/pom/Navigatable;", "executor", "Ljava/util/concurrent/Executor;", "getProblems", "", "init", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "removeProblems", "intellij.java.impl"})
public final class ProjectProblemsViewImpl
implements ProjectProblemsView {
    private final NewErrorTreeViewPanel panel;
    private final ScheduledExecutorService executorService;
    private final Project project;

    @Override
    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkParameterIsNotNull((Object)toolWindow, (String)"toolWindow");
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        Content content = contentManager2.getFactory().createContent((JComponent)this.panel, "", false);
        Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"contentManager.factory.c\u2026Content(panel, \"\", false)");
        Content content2 = content;
        contentManager2.addContent(content2);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)new Disposable(contentManager2){
            final /* synthetic */ ContentManager $contentManager;

            public final void dispose() {
                this.$contentManager.removeAllContents(true);
            }
            {
                this.$contentManager = contentManager;
            }
        });
    }

    @Override
    public void addProblem(@NotNull VirtualFile file, @NotNull String message2, @NotNull Navigatable place) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        this.panel.addMessage(4, new String[]{message2}, file.getName(), place, null, null, null);
    }

    @Override
    @NotNull
    public Executor executor() {
        return this.executorService;
    }

    @Override
    public void removeProblems(@NotNull VirtualFile file, @Nullable Navigatable place) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (place == null) {
            this.panel.removeAllInGroup(file.getName());
        } else {
            this.panel.removeMessage(4, file.getName(), place);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Navigatable> getProblems(@NotNull VirtualFile file) {
        void $this$mapNotNullTo$iv$iv;
        NavigatableMessageElement[] messages;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        NavigatableMessageElement[] navigatableMessageElementArray = this.panel.getNavigatableMessages(file.getName());
        if (navigatableMessageElementArray == null) {
            return CollectionsKt.emptyList();
        }
        NavigatableMessageElement[] $this$mapNotNull$iv = messages = navigatableMessageElementArray;
        boolean $i$f$mapNotNull = false;
        NavigatableMessageElement[] navigatableMessageElementArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var10_10 = $this$forEach$iv$iv$iv;
        int n = ((void)var10_10).length;
        for (int i = 0; i < n; ++i) {
            Navigatable navigatable;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var10_10[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (v1.getNavigatable() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Navigatable it$iv$iv = navigatable;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public ProjectProblemsViewImpl(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.panel = new NewErrorTreeViewPanel(this.project, null, false, true, null);
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"ProblemsViewPoolExecutor", (int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"AppExecutorUtil.createBo\u2026lemsViewPoolExecutor\", 1)");
        this.executorService = scheduledExecutorService;
        if (Registry.is((String)"project.problems.view")) {
            Disposer.register((Disposable)((Disposable)this.project), (Disposable)new Disposable(){

                public final void dispose() {
                    Disposer.dispose((Disposable)((Disposable)panel));
                }
            });
        }
    }
}

