/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.source.jsp.jspJava.JspMethodCall;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class MethodCallFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        PsiExpressionList argList = null;
        if (psiElement instanceof PsiMethodCallExpression && !(psiElement instanceof JspMethodCall)) {
            argList = ((PsiMethodCallExpression)psiElement).getArgumentList();
        } else if (psiElement instanceof PsiNewExpression) {
            argList = ((PsiNewExpression)psiElement).getArgumentList();
        }
        int caret = editor.getCaretModel().getOffset();
        if (argList != null && !MethodCallFixer.hasRParenth(argList)) {
            PsiExpression[] args;
            PsiCallExpression innermostCall = (PsiCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiElement.getContainingFile(), (int)(caret - 1), PsiCallExpression.class, (boolean)false);
            if (innermostCall == null) {
                return;
            }
            argList = innermostCall.getArgumentList();
            if (argList == null) {
                return;
            }
            int endOffset = -1;
            for (PsiElement child = argList.getFirstChild(); child != null; child = child.getNextSibling()) {
                PsiErrorElement errorElement;
                if (!(child instanceof PsiErrorElement) || !(errorElement = (PsiErrorElement)child).getErrorDescription().contains("')'")) continue;
                endOffset = errorElement.getTextRange().getStartOffset();
                break;
            }
            if (endOffset == -1) {
                endOffset = argList.getTextRange().getEndOffset();
            }
            if ((args = argList.getExpressions()).length > 0 && MethodCallFixer.startLine(editor, (PsiElement)argList) != MethodCallFixer.startLine(editor, (PsiElement)args[0]) && caret < args[0].getTextRange().getStartOffset()) {
                endOffset = argList.getTextRange().getStartOffset() + 1;
            }
            if (!DumbService.isDumb((Project)argList.getProject())) {
                int caretArg = ContainerUtil.indexOf(Arrays.asList(args), arg -> arg.getTextRange().containsOffset(caret));
                Integer argCount = MethodCallFixer.getMinimalParameterCount(innermostCall);
                if (argCount != null && argCount > 0 && argCount < args.length) {
                    endOffset = Math.min(endOffset, args[Math.max(argCount - 1, caretArg)].getTextRange().getEndOffset());
                }
            }
            endOffset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)(endOffset - 1), (String)" \t\n") + 1;
            editor.getDocument().insertString(endOffset, (CharSequence)")");
        }
    }

    private static boolean hasRParenth(PsiExpressionList args) {
        PsiElement parenth = args.getLastChild();
        return parenth != null && ")".equals(parenth.getText());
    }

    @Nullable
    private static Integer getMinimalParameterCount(PsiCallExpression call) {
        int paramCount = Integer.MAX_VALUE;
        for (CandidateInfo candidate : PsiResolveHelper.SERVICE.getInstance((Project)call.getProject()).getReferencedMethodCandidates(call, false)) {
            PsiElement element = candidate.getElement();
            if (!(element instanceof PsiMethod)) continue;
            paramCount = Math.min(paramCount, ((PsiMethod)element).getParameterList().getParametersCount());
        }
        return paramCount == Integer.MAX_VALUE ? null : Integer.valueOf(paramCount);
    }

    private static int startLine(Editor editor, PsiElement psiElement) {
        return editor.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

