/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class JavaStatementsSurrounder
implements Surrounder {
    JavaStatementsSurrounder() {
    }

    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            JavaStatementsSurrounder.$$$reportNull$$$0(0);
        }
        return ContainerUtil.find((Object[])elements, PsiSwitchLabelStatementBase.class::isInstance) == null;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
        PsiElement container;
        if (project == null) {
            JavaStatementsSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            JavaStatementsSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            JavaStatementsSurrounder.$$$reportNull$$$0(3);
        }
        if ((container = elements[0].getParent()) == null) {
            return null;
        }
        return this.surroundStatements(project, editor, container, elements);
    }

    @Nullable
    protected abstract TextRange surroundStatements(Project var1, Editor var2, PsiElement var3, PsiElement[] var4) throws IncorrectOperationException;

    @NotNull
    protected PsiStatement addAfter(PsiStatement statement, PsiElement container, PsiElement[] statements) {
        if (container instanceof PsiSwitchLabeledRuleStatement && !(statement instanceof PsiBlockStatement)) {
            Project project = container.getProject();
            PsiManager manager = PsiManager.getInstance((Project)project);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            PsiBlockStatement blockStatement = (PsiBlockStatement)factory.createStatementFromText("{\n}", null);
            blockStatement = (PsiBlockStatement)codeStyleManager.reformat((PsiElement)blockStatement);
            blockStatement = (PsiBlockStatement)container.addAfter((PsiElement)blockStatement, statements[statements.length - 1]);
            PsiStatement psiStatement = (PsiStatement)blockStatement.getCodeBlock().add((PsiElement)statement);
            if (psiStatement == null) {
                JavaStatementsSurrounder.$$$reportNull$$$0(4);
            }
            return psiStatement;
        }
        PsiStatement psiStatement = (PsiStatement)container.addAfter((PsiElement)statement, statements[statements.length - 1]);
        if (psiStatement == null) {
            JavaStatementsSurrounder.$$$reportNull$$$0(5);
        }
        return psiStatement;
    }

    protected static void addRangeWithinContainer(PsiCodeBlock codeBlock, PsiElement container, PsiElement[] statements, boolean canBreak) {
        if (container instanceof PsiSwitchLabeledRuleStatement && statements.length == 1) {
            PsiElement statement = statements[0];
            if (statement instanceof PsiExpressionStatement && canBreak) {
                JavaStatementsSurrounder.addYield(codeBlock, (PsiExpressionStatement)statement);
                return;
            }
            if (statement instanceof PsiBlockStatement) {
                JavaStatementsSurrounder.addCodeBlockContents(codeBlock, (PsiBlockStatement)statement);
                return;
            }
        }
        codeBlock.addRange(statements[0], statements[statements.length - 1]);
    }

    private static void addYield(PsiCodeBlock codeBlock, PsiExpressionStatement statement) {
        PsiExpressionStatement wrappedStatement = (PsiExpressionStatement)codeBlock.add((PsiElement)statement);
        CommentTracker tracker = new CommentTracker();
        tracker.markUnchanged(wrappedStatement.getExpression());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)codeBlock.getProject());
        PsiYieldStatement yieldStatement = (PsiYieldStatement)factory.createStatementFromText("yield 0;", (PsiElement)statement);
        yieldStatement = (PsiYieldStatement)tracker.replaceAndRestoreComments((PsiElement)wrappedStatement, (PsiElement)yieldStatement);
        PsiExpression yieldExpression = yieldStatement.getExpression();
        assert (yieldExpression != null) : DebugUtil.psiToString((PsiElement)yieldStatement, (boolean)false);
        yieldExpression.replace((PsiElement)statement.getExpression());
    }

    protected static void addCodeBlockContents(PsiCodeBlock codeBlock, PsiBlockStatement statement) {
        PsiBlockStatement tempStatement = (PsiBlockStatement)codeBlock.add((PsiElement)statement);
        PsiCodeBlock tempBlock = tempStatement.getCodeBlock();
        PsiJavaToken lBrace = tempBlock.getLBrace();
        PsiJavaToken rBrace = tempBlock.getRBrace();
        if (lBrace != null && rBrace != null) {
            CommentTracker tracker = new CommentTracker();
            for (PsiElement element = lBrace.getNextSibling(); element != null && element != rBrace; element = element.getNextSibling()) {
                tracker.markUnchanged(element);
                codeBlock.addBefore(element, (PsiElement)tempStatement);
            }
            tracker.deleteAndRestoreComments((PsiElement)tempStatement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/surroundWith/JavaStatementsSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/surroundWith/JavaStatementsSurrounder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addAfter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "surroundElements";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

