/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Collections;
import java.util.List;

public class JavaWithTryCatchSurrounder
extends JavaStatementsSurrounder {
    protected boolean myGenerateFinally;

    public String getTemplateDescription() {
        return JavaBundle.message((String)"surround.with.try.catch.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, true)).length == 0) {
            return null;
        }
        List<PsiClassType> exceptions = ExceptionUtil.getUnhandledExceptions(statements);
        if (exceptions.isEmpty() && (exceptions = ExceptionUtil.getThrownExceptions(statements)).isEmpty()) {
            exceptions = Collections.singletonList(factory.createTypeByFQClassName("java.lang.Exception", container.getResolveScope()));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("try{\n}");
        for (PsiClassType exception : exceptions) {
            buffer.append("catch(Exception e){\n}");
        }
        if (this.myGenerateFinally) {
            buffer.append("finally{\n}");
        }
        String text2 = buffer.toString();
        PsiTryStatement tryStatement = (PsiTryStatement)factory.createStatementFromText(text2, null);
        tryStatement = (PsiTryStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)tryStatement);
        tryStatement = (PsiTryStatement)this.addAfter((PsiStatement)tryStatement, container, statements);
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        SurroundWithUtil.indentCommentIfNecessary(tryBlock, statements);
        JavaWithTryCatchSurrounder.addRangeWithinContainer(tryBlock, container, statements, true);
        PsiCatchSection[] catchSections = tryStatement.getCatchSections();
        for (int i = 0; i < exceptions.size(); ++i) {
            PsiCatchSection catchSection;
            PsiClassType exception = exceptions.get(i);
            String name2 = new VariableNameGenerator((PsiElement)tryBlock, VariableKind.PARAMETER).byType((PsiType)exception).byName("e", "ex", "exc").generate(false);
            try {
                catchSection = factory.createCatchSection((PsiType)exception, name2, (PsiElement)tryBlock);
            }
            catch (IncorrectOperationException e) {
                Messages.showErrorDialog((Project)project, (String)JavaBundle.message((String)"surround.with.try.catch.incorrect.template.message", (Object[])new Object[0]), (String)JavaBundle.message((String)"surround.with.try.catch.incorrect.template.title", (Object[])new Object[0]));
                return null;
            }
            catchSection = (PsiCatchSection)catchSections[i].replace((PsiElement)catchSection);
            codeStyleManager.shortenClassReferences((PsiElement)catchSection);
        }
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        PsiCodeBlock firstCatch = tryStatement.getCatchBlocks()[0];
        return SurroundWithUtil.getRangeToSelect(firstCatch);
    }
}

