/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaInstanceofValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelation;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ExpressionTypeMemoryState
extends DfaMemoryStateImpl {
    private static final Logger LOG = Logger.getInstance(ExpressionTypeMemoryState.class);
    public static final TObjectHashingStrategy<PsiExpression> EXPRESSION_HASHING_STRATEGY = new TObjectHashingStrategy<PsiExpression>(){

        public int computeHashCode(PsiExpression object) {
            if (object instanceof PsiReferenceExpression) {
                return Objects.hashCode(((PsiReferenceExpression)object).getReferenceName()) * 31 + 1;
            }
            if (object instanceof PsiMethodCallExpression) {
                return Objects.hashCode(((PsiMethodCallExpression)object).getMethodExpression().getReferenceName()) * 31 + 2;
            }
            return object.getNode().getElementType().hashCode();
        }

        public boolean equals(@NotNull PsiExpression o1, @NotNull PsiExpression o2) {
            if (o1 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                1.$$$reportNull$$$0(1);
            }
            if (JavaPsiEquivalenceUtil.areExpressionsEquivalent(o1, o2)) {
                if (this.computeHashCode(o1) != this.computeHashCode(o2)) {
                    LOG.error("different hashCodes: " + o1 + "; " + o2 + "; " + this.computeHashCode(o1) + "!=" + this.computeHashCode(o2));
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/guess/impl/ExpressionTypeMemoryState$1";
            objectArray[2] = "equals";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final boolean myHonorAssignments;
    private MultiMap<PsiExpression, PsiType> myStates;

    public ExpressionTypeMemoryState(DfaValueFactory factory, boolean honorAssignments) {
        super(factory);
        this.myHonorAssignments = honorAssignments;
        this.myStates = MultiMap.createSet(EXPRESSION_HASHING_STRATEGY);
    }

    private ExpressionTypeMemoryState(ExpressionTypeMemoryState toCopy) {
        super(toCopy);
        this.myHonorAssignments = toCopy.myHonorAssignments;
        this.myStates = toCopy.myStates;
    }

    @Override
    protected DfType filterDfTypeOnAssignment(DfaVariableValue var, @NotNull DfType dfType) {
        if (dfType == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(0);
        }
        if (this.myHonorAssignments) {
            return dfType;
        }
        if (ControlFlowAnalyzer.isTempVariable(var) || !(dfType instanceof DfReferenceType) || var.getPsiVariable() instanceof PsiParameter && var.getPsiVariable().getParent().getParent() instanceof PsiLambdaExpression) {
            return dfType;
        }
        return ((DfReferenceType)dfType).dropTypeConstraint();
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        return new ExpressionTypeMemoryState(this);
    }

    @Override
    public boolean isSuperStateOf(DfaMemoryStateImpl that) {
        if (!super.isSuperStateOf(that)) {
            return false;
        }
        MultiMap<PsiExpression, PsiType> thatStates = ((ExpressionTypeMemoryState)that).myStates;
        if (thatStates == this.myStates) {
            return true;
        }
        for (Map.Entry entry : this.myStates.entrySet()) {
            Collection thisTypes = (Collection)entry.getValue();
            Collection thatTypes = thatStates.get(entry.getKey());
            if (thatTypes.containsAll(thisTypes)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean applyCondition(DfaCondition dfaCond) {
        if (dfaCond instanceof DfaRelation) {
            DfaRelation rel = (DfaRelation)dfaCond;
            DfaValue leftOperand2 = rel.getLeftOperand();
            DfaValue rightOperand2 = rel.getRightOperand();
            RelationType relation = rel.getRelation();
            if (leftOperand2 instanceof DfaInstanceofValue && (relation == RelationType.EQ || relation == RelationType.NE)) {
                DfaInstanceofValue value2 = (DfaInstanceofValue)leftOperand2;
                Boolean val = DfConstantType.getConstantOfType(rightOperand2.getDfType(), Boolean.class);
                if (val != null) {
                    boolean negated;
                    boolean bl = negated = relation == RelationType.EQ != val;
                    if (!negated) {
                        this.setExpressionType(value2.getExpression(), value2.getCastType());
                    }
                    return super.applyCondition(negated ? value2.getRelation().negate() : value2.getRelation());
                }
            }
        }
        return super.applyCondition(dfaCond);
    }

    MultiMap<PsiExpression, PsiType> getStates() {
        return this.myStates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpressionTypeMemoryState that = (ExpressionTypeMemoryState)o;
        return this.myStates.equals(that.myStates);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myStates.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " states=[" + this.myStates + "]";
    }

    void removeExpressionType(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(1);
        }
        if (this.myStates.containsKey((Object)expression2)) {
            MultiMap<PsiExpression, PsiType> oldStates = this.myStates;
            this.myStates = MultiMap.createSet(EXPRESSION_HASHING_STRATEGY);
            for (Map.Entry entry : oldStates.entrySet()) {
                if (EXPRESSION_HASHING_STRATEGY.equals(entry.getKey(), (Object)expression2)) continue;
                this.myStates.putValues(entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    void setExpressionType(@NotNull PsiExpression expression2, @NotNull PsiType type2) {
        if (expression2 == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(3);
        }
        if (!this.myStates.get((Object)expression2).contains(type2)) {
            MultiMap<PsiExpression, PsiType> oldStates = this.myStates;
            this.myStates = MultiMap.createSet(EXPRESSION_HASHING_STRATEGY);
            this.myStates.putAllValues(oldStates);
            this.myStates.putValue((Object)expression2, (Object)type2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/guess/impl/ExpressionTypeMemoryState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "filterDfTypeOnAssignment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeExpressionType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setExpressionType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

