/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.JavaInlayHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0016J\b\u0010#\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006%"}, d2={"Lcom/intellij/codeInsight/hints/JavaInlayParameterHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "()V", "defaultBlackList", "", "", "ignoreOneCharOneDigitHints", "Lcom/intellij/codeInsight/hints/Option;", "getIgnoreOneCharOneDigitHints", "()Lcom/intellij/codeInsight/hints/Option;", "isShowHintWhenExpressionTypeIsClear", "isShowHintsForEnumConstants", "isShowHintsForNewExpressions", "showForBuilderLikeMethods", "getShowForBuilderLikeMethods", "showForParamsWithSameType", "getShowForParamsWithSameType", "showIfMethodNameContainsParameterName", "getShowIfMethodNameContainsParameterName", "canShowHintsWhenDisabled", "", "getDefaultBlackList", "getHintInfo", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "element", "Lcom/intellij/psi/PsiElement;", "getMainCheckboxText", "getMethodInfo", "method", "Lcom/intellij/psi/PsiMethod;", "getParameterHints", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "getSettingsPreview", "getSupportedOptions", "isExhaustive", "Companion", "intellij.java.impl"})
public final class JavaInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    private final Set<String> defaultBlackList = SetsKt.setOf((Object[])new String[]{"(begin*, end*)", "(start*, end*)", "(first*, last*)", "(first*, second*)", "(from*, to*)", "(min*, max*)", "(key, value)", "(format, arg*)", "(message)", "(message, error)", "*Exception", "*.set*(*)", "*.add(*)", "*.set(*,*)", "*.get(*)", "*.create(*)", "*.getProperty(*)", "*.setProperty(*,*)", "*.print(*)", "*.println(*)", "*.append(*)", "*.charAt(*)", "*.indexOf(*)", "*.contains(*)", "*.startsWith(*)", "*.endsWith(*)", "*.equals(*)", "*.equal(*)", "*.compareTo(*)", "*.compare(*,*)", "java.lang.Math.*", "org.slf4j.Logger.*", "*.singleton(*)", "*.singletonList(*)", "*.Set.of", "*.ImmutableList.of", "*.ImmutableMultiset.of", "*.ImmutableSortedMultiset.of", "*.ImmutableSortedSet.of", "*.Arrays.asList"});
    @NotNull
    private final Option showIfMethodNameContainsParameterName;
    @NotNull
    private final Option showForParamsWithSameType;
    @NotNull
    private final Option showForBuilderLikeMethods;
    @NotNull
    private final Option ignoreOneCharOneDigitHints;
    @NotNull
    private final Option isShowHintWhenExpressionTypeIsClear;
    @NotNull
    private final Option isShowHintsForEnumConstants;
    @NotNull
    private final Option isShowHintsForNewExpressions;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public HintInfo.MethodInfo getHintInfo(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof PsiCallExpression && !(element instanceof PsiEnumConstant)) {
            PsiElement resolvedElement;
            PsiElement psiElement;
            PsiMethod psiMethod = JavaMethodCallElement.isCompletionMode((PsiCall)element) ? CompletionMemory.getChosenMethod((PsiCall)element) : null;
            if (psiMethod != null) {
                psiElement = (PsiElement)psiMethod;
            } else {
                JavaResolveResult javaResolveResult = ((PsiCallExpression)element).resolveMethodGenerics();
                Intrinsics.checkExpressionValueIsNotNull((Object)javaResolveResult, (String)"element.resolveMethodGenerics()");
                psiElement = resolvedElement = javaResolveResult.getElement();
            }
            if (resolvedElement instanceof PsiMethod) {
                return this.getMethodInfo((PsiMethod)resolvedElement);
            }
        }
        return null;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof PsiCall) {
            if (element instanceof PsiEnumConstant && !this.isShowHintsForEnumConstants.get()) {
                return CollectionsKt.emptyList();
            }
            if (element instanceof PsiNewExpression && !this.isShowHintsForNewExpressions.get()) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.toList((Iterable)JavaInlayHintsProvider.INSTANCE.hints((PsiCall)element));
        }
        return CollectionsKt.emptyList();
    }

    public boolean canShowHintsWhenDisabled() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final HintInfo.MethodInfo getMethodInfo(PsiMethod method) {
        void $this$mapTo$iv$iv;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"method.containingClass ?: return null");
        PsiClass containingClass = psiClass;
        String string = StringUtil.getQualifiedName((String)containingClass.getQualifiedName(), (String)method.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.getQualifiedN\u2026alifiedName, method.name)");
        String fullMethodName = string;
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"method.parameterList.parameters");
        PsiParameter[] $this$map$iv = psiParameterArray;
        boolean $i$f$map = false;
        PsiParameter[] psiParameterArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var10_9 = $this$mapTo$iv$iv;
        int n = ((void)var10_9).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_13 = item$iv$iv = var10_9[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
            String string2 = v4.getName();
            collection.add(string2);
        }
        List paramNames = (List)destination$iv$iv;
        return new HintInfo.MethodInfo(fullMethodName, paramNames);
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        return this.defaultBlackList;
    }

    @NotNull
    public final Option getShowIfMethodNameContainsParameterName() {
        return this.showIfMethodNameContainsParameterName;
    }

    @NotNull
    public final Option getShowForParamsWithSameType() {
        return this.showForParamsWithSameType;
    }

    @NotNull
    public final Option getShowForBuilderLikeMethods() {
        return this.showForBuilderLikeMethods;
    }

    @NotNull
    public final Option getIgnoreOneCharOneDigitHints() {
        return this.ignoreOneCharOneDigitHints;
    }

    @NotNull
    public final Option isShowHintWhenExpressionTypeIsClear() {
        return this.isShowHintWhenExpressionTypeIsClear;
    }

    @NotNull
    public final Option isShowHintsForEnumConstants() {
        return this.isShowHintsForEnumConstants;
    }

    @NotNull
    public final Option isShowHintsForNewExpressions() {
        return this.isShowHintsForNewExpressions;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        return CollectionsKt.listOf((Object[])new Option[]{this.showIfMethodNameContainsParameterName, this.showForParamsWithSameType, this.showForBuilderLikeMethods, this.ignoreOneCharOneDigitHints, this.isShowHintsForEnumConstants, this.isShowHintsForNewExpressions, this.isShowHintWhenExpressionTypeIsClear});
    }

    @NotNull
    public String getSettingsPreview() {
        return "class A {\n  native void foo(String name, boolean isChanged);\n  \n  void bar() {\n    foo(\"\", false);\n  }\n}";
    }

    public boolean isExhaustive() {
        return true;
    }

    @NotNull
    public String getMainCheckboxText() {
        String string = JavaBundle.message((String)"settings.inlay.java.show.parameter.hints.for", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaBundle.message(\"sett\u2026how.parameter.hints.for\")");
        return string;
    }

    public JavaInlayParameterHintsProvider() {
        Option option;
        String string = JavaBundle.message((String)"settings.inlay.java.parameters.with.names.that.are.contained.in.the.method.name", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaBundle.message(\"sett\u2026ined.in.the.method.name\")");
        this.showIfMethodNameContainsParameterName = new Option("java.method.name.contains.parameter.name", string, false);
        String string2 = JavaBundle.message((String)"settings.inlay.java.non.literals.in.case.of.multiple.parameters.with.the.same.type", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JavaBundle.message(\"sett\u2026ters.with.the.same.type\")");
        this.showForParamsWithSameType = new Option("java.multiple.params.same.type", string2, false);
        String string3 = JavaBundle.message((String)"settings.inlay.java.builder.like.methods", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"JavaBundle.message(\"sett\u2026va.builder.like.methods\")");
        this.showForBuilderLikeMethods = new Option("java.build.like.method", string3, false);
        String string4 = JavaBundle.message((String)"settings.inlay.java.methods.with.same.named.numbered.parameters", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"JavaBundle.message(\"sett\u2026med.numbered.parameters\")");
        this.ignoreOneCharOneDigitHints = new Option("java.simple.sequentially.numbered", string4, false);
        String string5 = JavaBundle.message((String)"settings.inlay.java.complex.expressions.binary.functional.array.access.and.other", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"JavaBundle.message(\"sett\u2026.array.access.and.other\")");
        Option option2 = new Option("java.clear.expression.type", string5, false);
        JavaInlayParameterHintsProvider javaInlayParameterHintsProvider = this;
        boolean bl = false;
        boolean bl2 = false;
        Option it = option2;
        boolean bl3 = false;
        it.setExtendedDescription(JavaBundle.message((String)"settings.inlay.java.show.parameter.hints.when.expression.type.is.clear.description", (Object[])new Object[0]));
        javaInlayParameterHintsProvider.isShowHintWhenExpressionTypeIsClear = option = option2;
        String string6 = JavaBundle.message((String)"settings.inlay.java.enum.constants", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"JavaBundle.message(\"sett\u2026lay.java.enum.constants\")");
        this.isShowHintsForEnumConstants = new Option("java.enums", string6, true);
        String string7 = JavaBundle.message((String)"settings.inlay.java.new.expressions", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"JavaBundle.message(\"sett\u2026ay.java.new.expressions\")");
        this.isShowHintsForNewExpressions = new Option("java.new.expr", string7, true);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/hints/JavaInlayParameterHintsProvider$Companion;", "", "()V", "getInstance", "Lcom/intellij/codeInsight/hints/JavaInlayParameterHintsProvider;", "intellij.java.impl"})
    public static final class Companion {
        @NotNull
        public final JavaInlayParameterHintsProvider getInstance() {
            Object object = InlayParameterHintsExtension.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.hints.JavaInlayParameterHintsProvider");
            }
            return (JavaInlayParameterHintsProvider)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

