/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.generation.RecordConstructorMember;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertCompactConstructorToCanonicalAction
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethod method;
        if (project == null) {
            ConvertCompactConstructorToCanonicalAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ConvertCompactConstructorToCanonicalAction.$$$reportNull$$$0(1);
        }
        if ((method = ConvertCompactConstructorToCanonicalAction.getMethod(element)) == null) {
            return;
        }
        PsiClass recordClass = method.getContainingClass();
        if (recordClass == null) {
            return;
        }
        PsiMethod prototype = new RecordConstructorMember(recordClass, false).generateRecordConstructor();
        PsiModifierList modifierList = method.getModifierList();
        prototype.getModifierList().replace((PsiElement)modifierList);
        PsiElement beforeModifier = modifierList.getPrevSibling();
        if (beforeModifier != null) {
            prototype.addRangeBefore(method.getFirstChild(), beforeModifier, (PsiElement)prototype.getModifierList());
        }
        PsiCodeBlock oldBody = Objects.requireNonNull(method.getBody());
        PsiCodeBlock body2 = (PsiCodeBlock)Objects.requireNonNull(prototype.getBody()).replace((PsiElement)oldBody);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        for (PsiRecordComponent component : recordClass.getRecordComponents()) {
            PsiField field = JavaPsiRecordUtil.getFieldForComponent(component);
            if (field == null || HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)body2)) continue;
            body2.add((PsiElement)factory.createStatementFromText("this." + field.getName() + "=" + field.getName() + ";", (PsiElement)body2));
        }
        int offset = editor.getCaretModel().getOffset();
        if (oldBody.getTextRange().contains(offset)) {
            offset += body2.getTextRangeInParent().getStartOffset() - oldBody.getTextRangeInParent().getStartOffset();
        }
        method.replace((PsiElement)prototype);
        editor.getCaretModel().moveToOffset(offset);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ConvertCompactConstructorToCanonicalAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiMethod method;
        if (project == null) {
            ConvertCompactConstructorToCanonicalAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ConvertCompactConstructorToCanonicalAction.$$$reportNull$$$0(4);
        }
        return (method = ConvertCompactConstructorToCanonicalAction.getMethod(element)) != null && JavaPsiRecordUtil.isCompactConstructor(method) && method.getBody() != null && method.getContainingClass() != null && method.getContainingClass().isRecord();
    }

    private static PsiMethod getMethod(@NotNull PsiElement element) {
        if (element == null) {
            ConvertCompactConstructorToCanonicalAction.$$$reportNull$$$0(5);
        }
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiMember.class});
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.convert.compact.constructor.to.canonical", (Object[])new Object[0]);
        if (string == null) {
            ConvertCompactConstructorToCanonicalAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ConvertCompactConstructorToCanonicalAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ConvertCompactConstructorToCanonicalAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

