/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFieldFromParameterDialog
extends DialogWrapper {
    private final Project myProject;
    private final String[] myNames;
    private final PsiType[] myTypes;
    private final PsiClass myTargetClass;
    private final boolean myFieldMayBeFinal;
    private JComponent myNameField;
    private JCheckBox myCbFinal;
    @NonNls
    private static final String PROPERTY_NAME = "CREATE_FIELD_FROM_PARAMETER_DECLARE_FINAL";
    private TypeSelector myTypeSelector;

    public CreateFieldFromParameterDialog(Project project, String[] names2, PsiClass targetClass, boolean fieldMayBeFinal, PsiType ... types) {
        super(project, true);
        this.myProject = project;
        this.myNames = names2;
        this.myTypes = types;
        this.myTargetClass = targetClass;
        this.myFieldMayBeFinal = fieldMayBeFinal;
        this.setTitle(JavaBundle.message((String)"dialog.create.field.from.parameter.title", (Object[])new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        PsiField[] fields;
        if (this.myCbFinal.isEnabled()) {
            PropertiesComponent.getInstance().setValue(PROPERTY_NAME, this.myCbFinal.isSelected());
        }
        for (PsiField field : fields = this.myTargetClass.getFields()) {
            if (!field.getName().equals(this.getEnteredName())) continue;
            int result = Messages.showOkCancelDialog((Component)this.getContentPane(), (String)JavaBundle.message((String)"dialog.create.field.from.parameter.already.exists.text", (Object[])new Object[]{this.getEnteredName()}), (String)JavaBundle.message((String)"dialog.create.field.from.parameter.already.exists.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                this.close(0);
                continue;
            }
            return;
        }
        this.close(0);
    }

    protected void init() {
        super.init();
        this.updateOkStatus();
    }

    public String getEnteredName() {
        if (this.myNameField instanceof JComboBox) {
            JComboBox combobox = (JComboBox)this.myNameField;
            return (String)combobox.getEditor().getItem();
        }
        return ((JTextField)this.myNameField).getText();
    }

    public boolean isDeclareFinal() {
        if (this.myCbFinal.isEnabled()) {
            return this.myCbFinal.isSelected();
        }
        return false;
    }

    protected JComponent createNorthPanel() {
        if (this.myNames.length > 1) {
            final ComboBox combobox = new ComboBox((Object[])this.myNames, 200);
            this.myNameField = combobox;
            combobox.setEditable(true);
            combobox.setSelectedIndex(0);
            combobox.setMaximumRowCount(8);
            combobox.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (combobox.isPopupVisible()) {
                        combobox.setPopupVisible(false);
                    } else {
                        CreateFieldFromParameterDialog.this.doCancelAction();
                    }
                }
            }, KeyStroke.getKeyStroke(27, 0), 1);
            combobox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }
            });
            combobox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }
            });
        } else {
            JTextField field = new JTextField(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    return new Dimension(200, size.height);
                }
            };
            this.myNameField = field;
            field.setText(this.myNames[0]);
            field.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterDialog$5", "textChanged"));
                }
            });
        }
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4);
        gbConstraints.anchor = 13;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        JLabel typeLabel = new JLabel(JavaBundle.message((String)"dialog.create.field.from.parameter.field.type.label", (Object[])new Object[0]));
        panel2.add((Component)typeLabel, gbConstraints);
        gbConstraints.gridx = 1;
        if (this.myTypes.length > 1) {
            this.myTypeSelector = new TypeSelector(this.myProject);
            this.myTypeSelector.setTypes(this.myTypes);
        } else {
            this.myTypeSelector = new TypeSelector(this.myTypes[0], this.myProject);
        }
        panel2.add((Component)this.myTypeSelector.getComponent(), gbConstraints);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        JLabel namePrompt = new JLabel(JavaBundle.message((String)"dialog.create.field.from.parameter.field.name.label", (Object[])new Object[0]));
        panel2.add((Component)namePrompt, gbConstraints);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        panel2.add((Component)this.myNameField, gbConstraints);
        return panel2;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.insets = JBUI.emptyInsets();
        this.myCbFinal = new JCheckBox(JavaBundle.message((String)"dialog.create.field.from.parameter.declare.final.checkbox", (Object[])new Object[0]));
        if (this.myFieldMayBeFinal) {
            this.myCbFinal.setSelected(PropertiesComponent.getInstance().isTrueValue(PROPERTY_NAME));
        } else {
            this.myCbFinal.setSelected(false);
            this.myCbFinal.setEnabled(false);
        }
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbFinal, gbConstraints);
        this.myCbFinal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFieldFromParameterDialog.this.requestFocusInNameWindow();
                if (CreateFieldFromParameterDialog.this.myCbFinal.isEnabled()) {
                    // empty if block
                }
            }
        });
        return panel2;
    }

    private void requestFocusInNameWindow() {
        if (this.myNameField instanceof JTextField) {
            this.myNameField.requestFocusInWindow();
        } else {
            ((JComboBox)this.myNameField).getEditor().getEditorComponent().requestFocusInWindow();
        }
    }

    private void updateOkStatus() {
        String text2 = this.getEnteredName();
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(text2));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    @Nullable
    public PsiType getType() {
        return this.myTypeSelector.getSelectedType();
    }
}

