/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeannotateIntentionAction
implements IntentionAction,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(DeannotateIntentionAction.class);
    private String myAnnotationName;

    @NotNull
    public String getText() {
        String string = JavaBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]) + (this.myAnnotationName != null ? " @" + this.myAnnotationName : "...");
        if (string == null) {
            DeannotateIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]);
        if (string == null) {
            DeannotateIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        ExternalAnnotationsManager externalAnnotationsManager;
        PsiAnnotation[] annotations;
        if (project == null) {
            DeannotateIntentionAction.$$$reportNull$$$0(2);
        }
        this.myAnnotationName = null;
        PsiModifierListOwner listOwner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset(), true);
        if (listOwner != null && (annotations = (externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project)).findExternalAnnotations(listOwner)) != null && annotations.length > 0) {
            List files;
            if (annotations.length == 1) {
                this.myAnnotationName = annotations[0].getQualifiedName();
            }
            if ((files = externalAnnotationsManager.findExternalAnnotationsFiles(listOwner)) == null || files.isEmpty()) {
                return false;
            }
            VirtualFile virtualFile = ((PsiFile)files.get(0)).getVirtualFile();
            return virtualFile != null && (virtualFile.isWritable() || virtualFile.isInLocalFileSystem());
        }
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        PsiModifierListOwner listOwner;
        if (project == null) {
            DeannotateIntentionAction.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((listOwner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset(), true)) != null);
        final ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        PsiAnnotation[] externalAnnotations = annotationsManager.findExternalAnnotations(listOwner);
        LOG.assertTrue(externalAnnotations != null && externalAnnotations.length > 0);
        if (externalAnnotations.length == 1) {
            this.deannotate(externalAnnotations[0], project, file, annotationsManager, listOwner);
            return;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiAnnotation>(JavaBundle.message((String)"deannotate.intention.chooser.title", (Object[])new Object[0]), externalAnnotations){

            public PopupStep<?> onChosen(PsiAnnotation selectedValue, boolean finalChoice) {
                if (finalChoice) {
                    this.doFinalStep(() -> DeannotateIntentionAction.this.deannotate(selectedValue, project, file, annotationsManager, listOwner));
                }
                return PopupStep.FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(PsiAnnotation value2) {
                String qualifiedName = value2.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                String string = qualifiedName;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction$1", "getTextFor"));
            }
        }).showInBestPositionFor(editor);
    }

    private void deannotate(PsiAnnotation annotation, Project project, PsiFile file, ExternalAnnotationsManager annotationsManager, PsiModifierListOwner listOwner) {
        VirtualFile virtualFile = file.getVirtualFile();
        String qualifiedName = annotation.getQualifiedName();
        LOG.assertTrue(qualifiedName != null);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (annotationsManager.deannotate(listOwner, qualifiedName) && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                UndoUtil.markPsiFileForUndo((PsiFile)file);
            }
        }, this.getText(), null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

