/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplitSwitchBranchWithSeveralCaseValuesAction
extends PsiElementBaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.split.switch.branch.with.several.case.values.family", (Object[])new Object[0]);
        if (string == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiStatement body2;
        PsiSwitchLabelStatementBase labelStatement;
        if (project == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(2);
        }
        if ((labelStatement = SplitSwitchBranchWithSeveralCaseValuesAction.findLabelStatement(editor, element)) == null || labelStatement.getEnclosingSwitchBlock() == null) {
            return false;
        }
        if (labelStatement instanceof PsiSwitchLabelStatement) {
            PsiSwitchLabelStatement lastSiblingLabel;
            if (SplitSwitchBranchWithSeveralCaseValuesAction.isMultiValueCase(labelStatement)) {
                if (SplitSwitchBranchWithSeveralCaseValuesAction.isAvailableForLabel(labelStatement)) {
                    this.setText(JavaBundle.message((String)"intention.split.switch.branch.with.several.case.values.split.text", (Object[])new Object[0]));
                    return true;
                }
            } else if (SplitSwitchBranchWithSeveralCaseValuesAction.hasSiblingLabel(labelStatement) && SplitSwitchBranchWithSeveralCaseValuesAction.isAvailableForLabel((PsiSwitchLabelStatementBase)(lastSiblingLabel = SplitSwitchBranchWithSeveralCaseValuesAction.findLastSiblingLabel((PsiStatement)labelStatement, false)))) {
                this.setText(JavaBundle.message((String)"intention.split.switch.branch.with.several.case.values.copy.text", (Object[])new Object[0]));
                return true;
            }
        } else if (labelStatement instanceof PsiSwitchLabeledRuleStatement && SplitSwitchBranchWithSeveralCaseValuesAction.isMultiValueCase(labelStatement) && (body2 = ((PsiSwitchLabeledRuleStatement)labelStatement).getBody()) != null && element.getTextOffset() < body2.getTextOffset()) {
            this.setText(JavaBundle.message((String)"intention.split.switch.branch.with.several.case.values.split.text", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean isAvailableForLabel(@Nullable PsiSwitchLabelStatementBase label) {
        PsiStatement lastStatement = SplitSwitchBranchWithSeveralCaseValuesAction.findLastStatementInBranch((PsiElement)label);
        return lastStatement != null && (!ControlFlowUtils.statementMayCompleteNormally(lastStatement) || PsiTreeUtil.getNextSiblingOfType((PsiElement)lastStatement, PsiSwitchLabelStatement.class) == null);
    }

    private static boolean isMultiValueCase(@NotNull PsiSwitchLabelStatementBase label) {
        PsiExpressionList caseValues2;
        if (label == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(3);
        }
        return (caseValues2 = label.getCaseValues()) != null && caseValues2.getExpressionCount() > 1;
    }

    private static boolean hasSiblingLabel(@Nullable PsiSwitchLabelStatementBase label) {
        return PsiTreeUtil.getPrevSiblingOfType((PsiElement)label, PsiStatement.class) instanceof PsiSwitchLabelStatement || PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiStatement.class) instanceof PsiSwitchLabelStatement;
    }

    @Nullable
    private static PsiElement getPreviousElement(@NotNull Editor editor, @NotNull PsiElement element) {
        int elementOffset;
        if (editor == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(5);
        }
        PsiFile file = element.getContainingFile();
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset == (elementOffset = element.getTextRange().getStartOffset()) && caretOffset > 0) {
            return file.findElementAt(caretOffset - 1);
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiSwitchLabeledRuleStatement labeledRule;
        PsiExpressionList caseValues2;
        if (project == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(7);
        }
        PsiSwitchLabelStatementBase statement = SplitSwitchBranchWithSeveralCaseValuesAction.findLabelStatement(editor, element);
        PsiElement result = null;
        if (statement instanceof PsiSwitchLabelStatement) {
            PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement;
            PsiExpressionList caseValues3 = labelStatement.getCaseValues();
            if (caseValues3 != null && caseValues3.getExpressionCount() > 1) {
                PsiExpression caseValue = SplitSwitchBranchWithSeveralCaseValuesAction.findCaseValue(element, caseValues3, editor);
                Branch branch = Branch.fromLabel(labelStatement);
                if (branch != null) {
                    result = SplitSwitchBranchWithSeveralCaseValuesAction.isInList(caseValue, caseValues3) ? SplitSwitchBranchWithSeveralCaseValuesAction.moveLabelValueAfter(labelStatement, caseValue) : SplitSwitchBranchWithSeveralCaseValuesAction.splitLabelValues(labelStatement);
                }
            } else {
                PsiSwitchLabelStatement lastSiblingLabel = SplitSwitchBranchWithSeveralCaseValuesAction.findLastSiblingLabel((PsiStatement)labelStatement, true);
                if (lastSiblingLabel != null) {
                    result = SplitSwitchBranchWithSeveralCaseValuesAction.moveLabelAfter(labelStatement, lastSiblingLabel);
                } else {
                    PsiStatement previousSibling = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                    if (previousSibling instanceof PsiSwitchLabelStatement) {
                        result = SplitSwitchBranchWithSeveralCaseValuesAction.copyLabelTo(labelStatement, (PsiSwitchLabelStatement)previousSibling);
                    }
                }
            }
        } else if (statement instanceof PsiSwitchLabeledRuleStatement && (caseValues2 = (labeledRule = (PsiSwitchLabeledRuleStatement)statement).getCaseValues()) != null) {
            PsiExpression caseValue = SplitSwitchBranchWithSeveralCaseValuesAction.findCaseValue(element, caseValues2, editor);
            result = SplitSwitchBranchWithSeveralCaseValuesAction.isInList(caseValue, caseValues2) ? SplitSwitchBranchWithSeveralCaseValuesAction.moveRuleAfter(caseValue, labeledRule) : SplitSwitchBranchWithSeveralCaseValuesAction.splitRule(caseValues2, labeledRule);
        }
        if (result != null) {
            editor.getCaretModel().moveToOffset(result.getTextOffset());
        }
    }

    private static PsiExpression findCaseValue(@NotNull PsiElement element, @NotNull PsiExpressionList caseValues2, @NotNull Editor editor) {
        PsiExpression caseValue;
        if (element == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(8);
        }
        if (caseValues2 == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(10);
        }
        if (!SplitSwitchBranchWithSeveralCaseValuesAction.isInList(caseValue = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiExpression.class}), caseValues2)) {
            PsiElement previousElement = SplitSwitchBranchWithSeveralCaseValuesAction.getPreviousElement(editor, element);
            caseValue = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)previousElement, (Class[])new Class[]{PsiExpression.class});
        }
        while (caseValue != null && caseValue.getParent() instanceof PsiExpression) {
            caseValue = (PsiExpression)caseValue.getParent();
        }
        return caseValue;
    }

    @Contract(value="null,_ -> false")
    private static boolean isInList(@Nullable PsiExpression caseValue, @NotNull PsiExpressionList caseValues2) {
        if (caseValues2 == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(11);
        }
        return caseValue != null && PsiTreeUtil.isAncestor((PsiElement)caseValues2, (PsiElement)caseValue, (boolean)true);
    }

    @Nullable
    private static PsiSwitchLabelStatementBase findLabelStatement(@NotNull Editor editor, @NotNull PsiElement element) {
        PsiStatement statement;
        if (editor == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(12);
        }
        if (element == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(13);
        }
        if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class)) instanceof PsiSwitchLabelStatementBase) {
            return (PsiSwitchLabelStatementBase)statement;
        }
        PsiElement previousElement = SplitSwitchBranchWithSeveralCaseValuesAction.getPreviousElement(editor, element);
        statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)previousElement, PsiStatement.class);
        return (PsiSwitchLabelStatementBase)ObjectUtils.tryCast((Object)statement, PsiSwitchLabelStatementBase.class);
    }

    private static PsiElement moveLabelAfter(@NotNull PsiSwitchLabelStatement labelToMove, @NotNull PsiSwitchLabelStatement anchor) {
        Branch branch;
        if (labelToMove == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(14);
        }
        if (anchor == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(15);
        }
        if ((branch = Branch.fromLabel(anchor)) == null) {
            return null;
        }
        return branch.moveAfter(labelToMove);
    }

    private static PsiElement copyLabelTo(@NotNull PsiSwitchLabelStatement labelToCopyFrom, @NotNull PsiSwitchLabelStatement anchor) {
        Branch branch;
        if (labelToCopyFrom == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(16);
        }
        if (anchor == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(17);
        }
        if ((branch = Branch.fromLabel(labelToCopyFrom)) == null) {
            return null;
        }
        return branch.copyTo(anchor);
    }

    @Nullable
    private static PsiElement moveLabelValueAfter(@NotNull PsiSwitchLabelStatement labelStatement, @NotNull PsiExpression caseValue) {
        Branch branch;
        if (labelStatement == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(18);
        }
        if (caseValue == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(19);
        }
        if ((branch = Branch.fromLabel(labelStatement)) == null) {
            return null;
        }
        PsiSwitchLabelStatement newLabel = branch.addLabelAfter(caseValue);
        caseValue.delete();
        return branch.copyTo(newLabel);
    }

    @Nullable
    private static PsiElement splitLabelValues(@NotNull PsiSwitchLabelStatement labelStatement) {
        Branch branch;
        if (labelStatement == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(20);
        }
        if ((branch = Branch.fromLabel(labelStatement)) == null) {
            return null;
        }
        ArrayList<PsiSwitchLabelStatement> newLabels = new ArrayList<PsiSwitchLabelStatement>();
        PsiExpression[] expressions2 = Objects.requireNonNull(labelStatement.getCaseValues()).getExpressions();
        for (int i = expressions2.length - 1; i >= 1; --i) {
            PsiExpression caseValue = expressions2[i];
            PsiSwitchLabelStatement newLabel = branch.addLabelAfter(caseValue);
            newLabels.add(newLabel);
            caseValue.delete();
        }
        for (PsiSwitchLabelStatement newLabel : newLabels) {
            branch.copyTo(newLabel);
        }
        return !newLabels.isEmpty() ? (PsiElement)newLabels.get(0) : null;
    }

    private static PsiSwitchLabeledRuleStatement moveRuleAfter(@NotNull PsiExpression caseValue, @NotNull PsiSwitchLabeledRuleStatement labeledRule) {
        if (caseValue == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(21);
        }
        if (labeledRule == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(22);
        }
        Project project = labeledRule.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiSwitchLabeledRuleStatement newRule = (PsiSwitchLabeledRuleStatement)factory.createStatementFromText("case 1->{}", null);
        Objects.requireNonNull(newRule.getCaseValues()).getExpressions()[0].replace((PsiElement)caseValue);
        newRule = (PsiSwitchLabeledRuleStatement)labeledRule.getParent().addAfter((PsiElement)newRule, (PsiElement)labeledRule);
        newRule = (PsiSwitchLabeledRuleStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newRule);
        Objects.requireNonNull(newRule.getBody()).replace((PsiElement)Objects.requireNonNull(labeledRule.getBody()));
        caseValue.delete();
        return newRule;
    }

    private static PsiSwitchLabeledRuleStatement splitRule(@NotNull PsiExpressionList caseValues2, @NotNull PsiSwitchLabeledRuleStatement labeledRule) {
        if (caseValues2 == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(23);
        }
        if (labeledRule == null) {
            SplitSwitchBranchWithSeveralCaseValuesAction.$$$reportNull$$$0(24);
        }
        PsiExpression[] expressions2 = caseValues2.getExpressions();
        PsiSwitchLabeledRuleStatement anchor = labeledRule;
        for (int i = 1; i < expressions2.length; ++i) {
            anchor = SplitSwitchBranchWithSeveralCaseValuesAction.moveRuleAfter(expressions2[i], anchor);
        }
        return anchor;
    }

    @Contract(value="null -> null")
    @Nullable
    static PsiStatement findLastStatementInBranch(@Nullable PsiElement label) {
        PsiStatement lastStatement = null;
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiStatement.class);
        while (statement != null && !(statement instanceof PsiSwitchLabelStatement)) {
            lastStatement = statement;
            statement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        }
        return lastStatement;
    }

    @Nullable
    private static PsiSwitchLabelStatement findLastSiblingLabel(@Nullable PsiStatement statement, boolean strict) {
        PsiStatement start;
        PsiSwitchLabelStatement result = null;
        PsiStatement next = start = strict ? (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class) : statement;
        while (next instanceof PsiSwitchLabelStatement) {
            result = (PsiSwitchLabelStatement)next;
            next = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)next, PsiStatement.class);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitSwitchBranchWithSeveralCaseValuesAction";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseValues";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelToMove";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelToCopyFrom";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelStatement";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseValue";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitSwitchBranchWithSeveralCaseValuesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMultiValueCase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findCaseValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInList";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findLabelStatement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moveLabelAfter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyLabelTo";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "moveLabelValueAfter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "splitLabelValues";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moveRuleAfter";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "splitRule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Branch {
        private final PsiElement myFirstElement;
        private final PsiStatement myLastStatement;
        private final PsiCodeBlock myCodeBlock;
        private final PsiElement myLBrace;

        private Branch(@NotNull PsiElement firstElement, @NotNull PsiStatement lastStatement, @NotNull PsiCodeBlock codeBlock, @NotNull PsiElement lBrace) {
            if (firstElement == null) {
                Branch.$$$reportNull$$$0(0);
            }
            if (lastStatement == null) {
                Branch.$$$reportNull$$$0(1);
            }
            if (codeBlock == null) {
                Branch.$$$reportNull$$$0(2);
            }
            if (lBrace == null) {
                Branch.$$$reportNull$$$0(3);
            }
            this.myFirstElement = firstElement;
            this.myLastStatement = lastStatement;
            this.myCodeBlock = codeBlock;
            this.myLBrace = lBrace;
        }

        @Nullable
        static Branch fromLabel(@NotNull PsiSwitchLabelStatement label) {
            PsiCodeBlock codeBlock;
            if (label == null) {
                Branch.$$$reportNull$$$0(4);
            }
            if ((codeBlock = (PsiCodeBlock)ObjectUtils.tryCast((Object)label.getParent(), PsiCodeBlock.class)) == null) {
                return null;
            }
            PsiJavaToken lBrace = codeBlock.getLBrace();
            PsiJavaToken rBrace = codeBlock.getRBrace();
            if (lBrace == null || rBrace == null) {
                return null;
            }
            PsiElement firstElement = label.getNextSibling();
            if (!Branch.isInBranch(firstElement, (PsiElement)rBrace)) {
                return null;
            }
            PsiStatement firstStatement = firstElement instanceof PsiStatement ? (PsiStatement)firstElement : (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)firstElement, PsiStatement.class);
            PsiStatement lastStatement = null;
            PsiStatement next = firstStatement;
            while (Branch.isInBranch((PsiElement)next, (PsiElement)rBrace)) {
                lastStatement = next;
                next = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)next, PsiStatement.class);
            }
            if (lastStatement == null) {
                return null;
            }
            return new Branch(firstElement, lastStatement, codeBlock, (PsiElement)lBrace);
        }

        @Contract(value="null,_ -> false")
        private static boolean isInBranch(@Nullable PsiElement element, @NotNull PsiElement rBrace) {
            if (rBrace == null) {
                Branch.$$$reportNull$$$0(5);
            }
            return element != null && element != rBrace && !(element instanceof PsiSwitchLabelStatement);
        }

        PsiElement moveAfter(@NotNull PsiSwitchLabelStatement labelToMove) {
            if (labelToMove == null) {
                Branch.$$$reportNull$$$0(6);
            }
            PsiSwitchLabelStatement previousLabel = (PsiSwitchLabelStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this.myFirstElement, PsiSwitchLabelStatement.class);
            PsiElement labelCopy = this.myCodeBlock.addAfter((PsiElement)labelToMove, (PsiElement)this.myLastStatement);
            this.myCodeBlock.addRangeAfter(this.myFirstElement, (PsiElement)this.myLastStatement, labelCopy);
            this.addBreakIfNeeded((PsiElement)previousLabel);
            PsiElement prefixStart = null;
            PsiElement prefixEnd = null;
            for (PsiElement previous = labelToMove.getPrevSibling(); previous != null && previous != this.myLBrace && !(previous instanceof PsiStatement); previous = previous.getPrevSibling()) {
                prefixStart = previous;
                if (prefixEnd != null) continue;
                prefixEnd = previous;
            }
            if (prefixStart != null) {
                this.myCodeBlock.addRangeBefore(prefixStart, prefixEnd, labelCopy);
                this.myCodeBlock.deleteChildRange(prefixStart, (PsiElement)labelToMove);
            } else {
                labelToMove.delete();
            }
            return labelCopy;
        }

        PsiSwitchLabelStatement copyTo(@NotNull PsiSwitchLabelStatement anchor) {
            if (anchor == null) {
                Branch.$$$reportNull$$$0(7);
            }
            this.myCodeBlock.addRangeAfter(this.myFirstElement, (PsiElement)this.myLastStatement, (PsiElement)anchor);
            this.addBreakIfNeeded((PsiElement)anchor);
            return anchor;
        }

        @NotNull
        PsiSwitchLabelStatement addLabelAfter(@NotNull PsiExpression caseValue) {
            if (caseValue == null) {
                Branch.$$$reportNull$$$0(8);
            }
            Project project = this.myCodeBlock.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiSwitchLabelStatement newLabel = (PsiSwitchLabelStatement)factory.createStatementFromText("case 1:", null);
            Objects.requireNonNull(newLabel.getCaseValues()).getExpressions()[0].replace((PsiElement)caseValue);
            newLabel = (PsiSwitchLabelStatement)this.myCodeBlock.addAfter((PsiElement)newLabel, (PsiElement)this.myLastStatement);
            PsiSwitchLabelStatement psiSwitchLabelStatement = newLabel = (PsiSwitchLabelStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newLabel);
            if (psiSwitchLabelStatement == null) {
                Branch.$$$reportNull$$$0(9);
            }
            return psiSwitchLabelStatement;
        }

        private void addBreakIfNeeded(@Nullable PsiElement label) {
            PsiStatement lastStatementInBranch = SplitSwitchBranchWithSeveralCaseValuesAction.findLastStatementInBranch(label);
            if (lastStatementInBranch != null && ControlFlowUtils.statementMayCompleteNormally(lastStatementInBranch)) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)lastStatementInBranch.getProject());
                PsiStatement breakStatement = factory.createStatementFromText("break;", null);
                this.myCodeBlock.addAfter((PsiElement)breakStatement, (PsiElement)lastStatementInBranch);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeBlock";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lBrace";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rBrace";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "labelToMove";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caseValue";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitSwitchBranchWithSeveralCaseValuesAction$Branch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitSwitchBranchWithSeveralCaseValuesAction$Branch";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addLabelAfter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fromLabel";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isInBranch";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "moveAfter";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "copyTo";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addLabelAfter";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

