/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.lists;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaListUtils {
    private JavaListUtils() {
    }

    @Nullable
    static PsiElement prevBreak(@NotNull PsiElement element) {
        if (element == null) {
            JavaListUtils.$$$reportNull$$$0(0);
        }
        for (PsiElement current = element.getPrevSibling(); current != null && JavaListUtils.isValidIntermediateElement(current); current = current.getPrevSibling()) {
            if (!(current instanceof PsiWhiteSpace) || !current.textContains('\n')) continue;
            return current;
        }
        return null;
    }

    @Nullable
    static PsiElement nextBreak(@NotNull PsiElement element) {
        if (element == null) {
            JavaListUtils.$$$reportNull$$$0(1);
        }
        for (PsiElement current = element.getNextSibling(); current != null && JavaListUtils.isValidIntermediateElement(current); current = current.getNextSibling()) {
            if (!(current instanceof PsiWhiteSpace) || !current.textContains('\n')) continue;
            return current;
        }
        return null;
    }

    static boolean containsEolComments(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            JavaListUtils.$$$reportNull$$$0(2);
        }
        PsiElement parent = elements.get(0).getParent();
        for (PsiElement child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiComment) || ((PsiComment)child).getTokenType() != JavaTokenType.END_OF_LINE_COMMENT) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidIntermediateElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaListUtils.$$$reportNull$$$0(3);
        }
        return element instanceof PsiWhiteSpace || element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.COMMA;
    }

    @Nullable
    static PsiExpressionList getCallArgumentsList(@NotNull PsiElement element) {
        PsiExpressionList expressionList;
        if (element == null) {
            JavaListUtils.$$$reportNull$$$0(4);
        }
        if ((expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionList.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class})) == null) {
            return null;
        }
        PsiElement parent = expressionList.getParent();
        if (!(parent instanceof PsiCall)) {
            return null;
        }
        return expressionList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/intention/impl/lists/JavaListUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prevBreak";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "nextBreak";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsEolComments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidIntermediateElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallArgumentsList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

