/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.JavaStringContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.ide.highlighter.JavaFileHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCodeContextType
extends TemplateContextType {
    protected JavaCodeContextType(@NotNull @NonNls String id, @NotNull String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        if (id == null) {
            JavaCodeContextType.$$$reportNull$$$0(0);
        }
        if (presentableName == null) {
            JavaCodeContextType.$$$reportNull$$$0(1);
        }
        super(id, presentableName, baseContextType);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            JavaCodeContextType.$$$reportNull$$$0(2);
        }
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset).isKindOf((Language)JavaLanguage.INSTANCE)) {
            PsiElement element = file.findElementAt(offset);
            if (element instanceof PsiWhiteSpace) {
                return false;
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    @NotNull
    public SyntaxHighlighter createHighlighter() {
        return new JavaFileHighlighter();
    }

    public Document createDocument(CharSequence text2, Project project) {
        if (project == null) {
            return super.createDocument(text2, project);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        JavaCodeFragment fragment = factory.createCodeBlockCodeFragment((String)text2, (PsiElement)psiFacade.findPackage(""), true);
        DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled((PsiFile)fragment, false);
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
    }

    private static boolean isAfterExpression(PsiElement element) {
        PsiExpression prevExpr;
        ProcessingContext context = new ProcessingContext();
        return ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withAncestor(1, (ElementPattern)StandardPatterns.instanceOf(PsiExpression.class))).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withAncestor(1, (ElementPattern)PlatformPatterns.psiElement(PsiExpression.class).save("prevExpr")))).accepts((Object)element, context) && (prevExpr = (PsiExpression)context.get((Object)"prevExpr")).getTextRange().getEndOffset() <= element.getTextRange().getStartOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/JavaCodeContextType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Declaration
    extends JavaCodeContextType {
        public Declaration() {
            super("JAVA_DECLARATION", "Declaration", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                Declaration.$$$reportNull$$$0(0);
            }
            if (Statement.isStatementContext(element) || Expression.isExpressionContext(element)) {
                return false;
            }
            return JavaKeywordCompletion.isSuitableForClass(element) || JavaKeywordCompletion.isInsideParameterList(element) || PsiTreeUtil.getParentOfType((PsiElement)element, PsiReferenceParameterList.class) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/JavaCodeContextType$Declaration", "isInContext"));
        }
    }

    public static class Expression
    extends JavaCodeContextType {
        public Expression() {
            super("JAVA_EXPRESSION", "Expression", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                Expression.$$$reportNull$$$0(0);
            }
            return Expression.isExpressionContext(element);
        }

        private static boolean isExpressionContext(PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiJavaCodeReferenceElement)) {
                return false;
            }
            if (((PsiJavaCodeReferenceElement)parent).isQualified()) {
                return false;
            }
            PsiElement grandpa = parent.getParent();
            if (grandpa instanceof PsiMethodCallExpression || grandpa instanceof PsiReferenceList) {
                return false;
            }
            if (grandpa instanceof PsiTypeElement && (grandpa.getParent() instanceof PsiMember || grandpa.getParent() instanceof PsiReferenceParameterList)) {
                return false;
            }
            if (JavaKeywordCompletion.isInsideParameterList(element)) {
                return false;
            }
            return !JavaCodeContextType.isAfterExpression(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/JavaCodeContextType$Expression", "isInContext"));
        }
    }

    public static class Statement
    extends JavaCodeContextType {
        public Statement() {
            super("JAVA_STATEMENT", "Statement", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                Statement.$$$reportNull$$$0(0);
            }
            return Statement.isStatementContext(element);
        }

        private static boolean isStatementContext(PsiElement element) {
            PsiElement body2;
            if (JavaCodeContextType.isAfterExpression(element) || JavaStringContextType.isStringLiteral(element)) {
                return false;
            }
            PsiElement statement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
            if (statement instanceof PsiLambdaExpression && (body2 = ((PsiLambdaExpression)statement).getBody()) != null && PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)element, (boolean)false)) {
                statement = body2;
            }
            return statement != null && statement.getTextRange().getStartOffset() == element.getTextRange().getStartOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/JavaCodeContextType$Statement", "isInContext"));
        }
    }

    public static class Generic
    extends JavaCodeContextType {
        public Generic() {
            super("JAVA_CODE", "Java", EverywhereContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                Generic.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/JavaCodeContextType$Generic", "isInContext"));
        }
    }
}

