/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.JavaPsiElementResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.codeInsight.template.macro.VariableTypeCalculator;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableOfTypeMacro
extends Macro {
    public String getName() {
        return "variableOfType";
    }

    public String getPresentableName() {
        return JavaBundle.message((String)"macro.variable.of.type", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        PsiElement[] vars;
        if (params == null) {
            VariableOfTypeMacro.$$$reportNull$$$0(0);
        }
        if ((vars = this.getVariables(params, context)) == null || vars.length == 0) {
            return null;
        }
        return new JavaPsiElementResult(vars[0]);
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        PsiElement[] vars;
        if (params == null) {
            VariableOfTypeMacro.$$$reportNull$$$0(1);
        }
        if ((vars = this.getVariables(params, context)) == null || vars.length < 2) {
            return null;
        }
        LinkedHashSet set = new LinkedHashSet();
        for (PsiElement var : vars) {
            JavaTemplateUtil.addElementLookupItem(set, var);
        }
        return set.toArray(LookupElement.EMPTY_ARRAY);
    }

    protected PsiElement @Nullable [] getVariables(Expression[] params, ExpressionContext context) {
        if (params.length != 1) {
            return null;
        }
        Result result = params[0].calculateResult(context);
        if (result == null) {
            return null;
        }
        Project project = context.getProject();
        int offset = context.getStartOffset();
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        PsiType type2 = MacroUtil.resultToPsiType(result, context);
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement place = file.findElementAt(offset);
        PsiVariable[] variables = MacroUtil.getVariablesVisibleAt(place, "");
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (PsiVariable var : variables) {
            TextRange range;
            PsiClass placeClass;
            PsiClass varClass;
            if (var instanceof PsiField && var.hasModifierProperty("static") ? !manager.areElementsEquivalent((PsiElement)(varClass = ((PsiField)var).getContainingClass()), (PsiElement)(placeClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class))) : var instanceof PsiLocalVariable && (range = var.getNameIdentifier().getTextRange()) != null && range.contains(offset)) continue;
            PsiType type1 = VariableTypeCalculator.getVarTypeAt(var, place);
            if (type2 != null && !type2.isAssignableFrom(type1)) continue;
            array.add(var);
        }
        Object[] expressions2 = MacroUtil.getStandardExpressionsOfType(place, type2);
        ContainerUtil.addAll(array, (Object[])expressions2);
        return PsiUtilCore.toPsiElementArray(array);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "params";
        objectArray2[1] = "com/intellij/codeInsight/template/macro/VariableOfTypeMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

