/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ReplaceComputeWithComputeIfPresentFix
implements LocalQuickFix,
HighPriorityAction {
    private static final CallMatcher MAP_COMPUTE = CallMatcher.instanceCall("java.util.Map", "compute").parameterTypes("K", "java.util.function.BiFunction");

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"inspection.data.flow.use.computeifpresent.quickfix", (Object[])new Object[0]);
        if (string == null) {
            ReplaceComputeWithComputeIfPresentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiLambdaExpression lambda2;
        if (project == null) {
            ReplaceComputeWithComputeIfPresentFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            ReplaceComputeWithComputeIfPresentFix.$$$reportNull$$$0(2);
        }
        if ((lambda2 = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiLambdaExpression.class)) == null) {
            return;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)lambda2, PsiMethodCallExpression.class);
        if (call == null || !"compute".equals(call.getMethodExpression().getReferenceName())) {
            return;
        }
        ExpressionUtils.bindCallTo(call, "computeIfPresent");
    }

    @Contract(value="null -> null")
    public static ReplaceComputeWithComputeIfPresentFix makeFix(PsiElement reference) {
        if (!(reference instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiParameter parameter2 = (PsiParameter)ObjectUtils.tryCast((Object)((PsiReferenceExpression)reference).resolve(), PsiParameter.class);
        if (parameter2 == null) {
            return null;
        }
        PsiParameterList parameterList = (PsiParameterList)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiParameterList.class);
        if (parameterList == null || parameterList.getParametersCount() != 2 || parameterList.getParameterIndex(parameter2) != 1) {
            return null;
        }
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)parameterList.getParent(), PsiLambdaExpression.class);
        if (lambda2 == null) {
            return null;
        }
        PsiExpressionList arguments = (PsiExpressionList)ObjectUtils.tryCast((Object)lambda2.getParent(), PsiExpressionList.class);
        if (arguments == null || arguments.getExpressionCount() != 2 || arguments.getExpressions()[1] != lambda2) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)arguments.getParent(), PsiMethodCallExpression.class);
        if (!MAP_COMPUTE.test(call)) {
            return null;
        }
        return new ReplaceComputeWithComputeIfPresentFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ReplaceComputeWithComputeIfPresentFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ReplaceComputeWithComputeIfPresentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

