/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SuspiciousListRemoveInLoopInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher LIST_REMOVE = CallMatcher.instanceCall("java.util.List", "remove").parameterTypes("int");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousListRemoveInLoopInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!LIST_REMOVE.test(call)) {
                    return;
                }
                PsiReferenceExpression arg = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiReferenceExpression.class);
                if (arg == null) {
                    return;
                }
                PsiExpressionStatement parentStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)call.getParent(), PsiExpressionStatement.class);
                if (parentStatement == null) {
                    return;
                }
                PsiElement parent = parentStatement.getParent();
                while (parent instanceof PsiLabeledStatement || parent instanceof PsiIfStatement || parent instanceof PsiSwitchLabelStatementBase || parent instanceof PsiSwitchStatement || parent instanceof PsiBlockStatement || parent instanceof PsiCodeBlock) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiForStatement)) {
                    return;
                }
                CountingLoop loop = CountingLoop.from((PsiForStatement)parent);
                if (loop == null || loop.isDescending()) {
                    return;
                }
                if (!arg.isReferenceTo((PsiElement)loop.getCounter())) {
                    return;
                }
                if (ControlFlowUtils.isExecutedOnceInLoop((PsiStatement)parentStatement, (PsiLoopStatement)parent)) {
                    return;
                }
                holder.registerProblem(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), JavaBundle.message((String)"inspection.suspicious.list.remove.display.name", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SuspiciousListRemoveInLoopInspection", "buildVisitor"));
    }
}

