/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.accessStaticViaInstance;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AccessStaticViaInstanceBase
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NonNls
    public static final String ACCESS_STATIC_VIA_INSTANCE = "AccessStaticViaInstance";

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return ACCESS_STATIC_VIA_INSTANCE;
    }

    public String getAlternativeID() {
        return "static-access";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            AccessStaticViaInstanceBase.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                AccessStaticViaInstanceBase.this.checkAccessStaticMemberViaInstanceReference(expression2, holder, isOnTheFly);
            }
        };
    }

    private void checkAccessStaticMemberViaInstanceReference(PsiReferenceExpression expr2, ProblemsHolder holder, boolean onTheFly) {
        PsiElement qualifierResolved;
        JavaResolveResult result = expr2.advancedResolve(false);
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiMember)) {
            return;
        }
        PsiExpression qualifierExpression2 = expr2.getQualifierExpression();
        if (qualifierExpression2 == null) {
            return;
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression && ((qualifierResolved = ((PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiClass || qualifierResolved instanceof PsiPackage)) {
            return;
        }
        if (!((PsiMember)resolved).hasModifierProperty("static")) {
            return;
        }
        PsiClass containingClass = ((PsiMember)resolved).getContainingClass();
        if (containingClass != null && containingClass.isInterface()) {
            return;
        }
        String description = JavaErrorBundle.message("static.member.accessed.via.instance.reference", JavaHighlightUtil.formatType(qualifierExpression2.getType()), HighlightMessageUtil.getSymbolName(resolved, result.getSubstitutor()));
        if (!onTheFly && RemoveUnusedVariableUtil.checkSideEffects(qualifierExpression2, null, new ArrayList())) {
            holder.registerProblem((PsiElement)expr2, description, new LocalQuickFix[0]);
            return;
        }
        holder.registerProblem((PsiElement)expr2, description, new LocalQuickFix[]{this.createAccessStaticViaInstanceFix(expr2, onTheFly, result)});
    }

    protected LocalQuickFix createAccessStaticViaInstanceFix(PsiReferenceExpression expr2, boolean onTheFly, JavaResolveResult result) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/accessStaticViaInstance/AccessStaticViaInstanceBase", "buildVisitor"));
    }
}

