/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Analysis;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.ExpandableArray;
import com.intellij.codeInspection.bytecodeAnalysis.NullableInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.TooComplexException;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class NullableInAnalysis
extends Analysis<PResults.PResult> {
    private final ExpandableArray<State> pending;
    private final NullableInterpreter interpreter = new NullableInterpreter();
    private int id;
    private Frame<BasicValue> nextFrame;
    private PResults.PResult myResult = PResults.Identity;
    private PResults.PResult subResult = PResults.Identity;
    private boolean top;
    private int pendingTop;

    protected NullableInAnalysis(RichControlFlow richControlFlow, Direction direction, boolean stable, ExpandableArray<State> pending) {
        super(richControlFlow, direction, stable);
        this.pending = pending;
    }

    @NotNull
    Equation mkEquation(PResults.PResult result) {
        if (PResults.NPE == result) {
            return new Equation(this.aKey, Value.Top);
        }
        if (PResults.Identity == result || PResults.Return == result) {
            return new Equation(this.aKey, Value.Null);
        }
        PResults.ConditionalNPE condNpe = (PResults.ConditionalNPE)result;
        Set<Component> components = condNpe.sop.stream().map(prod -> new Component(Value.Top, (Set<EKey>)prod)).collect(Collectors.toSet());
        return new Equation(this.aKey, new Pending(components));
    }

    @Override
    @NotNull
    protected Equation analyze() throws AnalyzerException {
        this.pendingPush(this.createStartState());
        int steps = 0;
        while (this.pendingTop > 0 && this.earlyResult == null) {
            TooComplexException.check(this.method, ++steps);
            State state = Objects.requireNonNull(this.pending.get(--this.pendingTop));
            int insnIndex = state.conf.insnIndex;
            Conf conf = state.conf;
            List<Conf> history = state.history;
            boolean fold = false;
            if (this.dfsTree.loopEnters[insnIndex]) {
                for (Conf prev : history) {
                    if (!AbstractValues.isInstance(conf, prev)) continue;
                    fold = true;
                    break;
                }
            }
            if (fold) {
                this.addComputed(insnIndex, state);
                continue;
            }
            State baseState = null;
            List thisComputed = this.computed[insnIndex];
            if (thisComputed != null) {
                for (State prevState : thisComputed) {
                    if (!state.equiv(prevState)) continue;
                    baseState = prevState;
                    break;
                }
            }
            if (baseState != null) continue;
            this.processState(state);
        }
        Equation equation = this.earlyResult != null ? this.mkEquation((PResults.PResult)this.earlyResult) : this.mkEquation(this.myResult);
        if (equation == null) {
            NullableInAnalysis.$$$reportNull$$$0(0);
        }
        return equation;
    }

    private void processState(State state) throws AnalyzerException {
        Conf conf = state.conf;
        int insnIndex = conf.insnIndex;
        List<Conf> history = state.history;
        boolean taken = state.taken;
        Frame<BasicValue> frame = conf.frame;
        AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
        List<Conf> nextHistory = this.dfsTree.loopEnters[insnIndex] ? NullableInAnalysis.append(history, conf) : history;
        this.addComputed(insnIndex, state);
        this.execute(frame, insnNode, taken);
        if (this.subResult == PResults.NPE || this.top) {
            this.earlyResult = PResults.NPE;
            return;
        }
        if (this.subResult instanceof PResults.ConditionalNPE) {
            this.myResult = PResults.combineNullable(this.myResult, this.subResult);
        }
        int opcode = insnNode.getOpcode();
        switch (opcode) {
            case 176: {
                if (NullableInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
                    this.earlyResult = PResults.NPE;
                }
                return;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 177: {
                return;
            }
        }
        if (opcode == 191) {
            if (taken) {
                this.earlyResult = PResults.NPE;
            }
            return;
        }
        if (opcode == 199 && NullableInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = insnIndex + 1;
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, false, false));
            return;
        }
        if (opcode == 198 && NullableInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, false, false));
            return;
        }
        if (opcode == 153 && NullableInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, false, false));
            return;
        }
        if (opcode == 154 && NullableInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = insnIndex + 1;
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, false, false));
            return;
        }
        for (int nextInsnIndex : this.controlFlow.transitions[insnIndex]) {
            Frame<BasicValue> nextFrame1 = this.nextFrame;
            if (this.controlFlow.errors[nextInsnIndex] && this.controlFlow.errorTransitions.contains(new ControlFlowGraph.Edge(insnIndex, nextInsnIndex))) {
                nextFrame1 = NullableInAnalysis.createCatchFrame(frame);
            }
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, nextFrame1), nextHistory, taken, false, false));
        }
    }

    private void pendingPush(State state) {
        TooComplexException.check(this.method, this.pendingTop);
        this.pending.set(this.pendingTop++, state);
    }

    private void execute(Frame<BasicValue> frame, AbstractInsnNode insnNode, boolean taken) throws AnalyzerException {
        switch (insnNode.getType()) {
            case 8: 
            case 14: 
            case 15: {
                this.nextFrame = frame;
                this.subResult = PResults.Identity;
                this.top = false;
                break;
            }
            default: {
                this.nextFrame = new Frame(frame);
                this.interpreter.reset(taken);
                this.nextFrame.execute(insnNode, (Interpreter)this.interpreter);
                this.subResult = this.interpreter.getSubResult();
                this.top = this.interpreter.top;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/NullableInAnalysis", "analyze"));
    }
}

