/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DupInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushFieldsInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.ObjectOfInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ResultOfInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SwapInstruction;
import com.intellij.codeInspection.dataFlow.instructions.UnwrapSpecialFieldInstruction;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFGBuilder {
    private final ControlFlowAnalyzer myAnalyzer;
    private final Deque<Runnable> myBranches = new ArrayDeque<Runnable>();
    private final Map<PsiExpression, DfaVariableValue> myMethodRefQualifiers = new HashMap<PsiExpression, DfaVariableValue>();

    CFGBuilder(ControlFlowAnalyzer analyzer) {
        this.myAnalyzer = analyzer;
    }

    private CFGBuilder add(Instruction instruction) {
        this.myAnalyzer.addInstruction(instruction);
        return this;
    }

    public CFGBuilder pushUnknown() {
        this.myAnalyzer.pushUnknown();
        return this;
    }

    public CFGBuilder pushNull() {
        return this.push(DfTypes.NULL);
    }

    public CFGBuilder pushExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            CFGBuilder.$$$reportNull$$$0(0);
        }
        expression2.accept((PsiElementVisitor)this.myAnalyzer);
        return this;
    }

    public CFGBuilder pushExpression(@NotNull PsiExpression expression2, @Nullable NullabilityProblemKind<? super PsiExpression> kind2) {
        if (expression2 == null) {
            CFGBuilder.$$$reportNull$$$0(1);
        }
        if (kind2 == null) {
            return this.pushExpression(expression2);
        }
        this.myAnalyzer.addCustomNullabilityProblem(expression2, kind2);
        expression2.accept((PsiElementVisitor)this.myAnalyzer);
        this.myAnalyzer.removeCustomNullabilityProblem(expression2);
        return this;
    }

    public CFGBuilder unwrap(@NotNull SpecialField descriptor) {
        if (descriptor == null) {
            CFGBuilder.$$$reportNull$$$0(2);
        }
        return this.add(new UnwrapSpecialFieldInstruction(descriptor));
    }

    public CFGBuilder pushForWrite(DfaVariableValue variable) {
        return this.add(new PushInstruction(variable, null, true));
    }

    public CFGBuilder push(DfaValue value2) {
        return this.add(new PushInstruction(value2, null));
    }

    public CFGBuilder push(DfaValue value2, PsiExpression expression2) {
        return this.add(new PushInstruction(value2, expression2));
    }

    public CFGBuilder push(DfType value2) {
        return this.add(new PushValueInstruction(value2));
    }

    public CFGBuilder push(DfType value2, PsiExpression expression2) {
        return this.add(new PushValueInstruction(value2, expression2));
    }

    public CFGBuilder pop() {
        return this.add(new PopInstruction());
    }

    public CFGBuilder dup() {
        return this.add(new DupInstruction());
    }

    public CFGBuilder splice(int count, int ... replacement) {
        return this.add(new SpliceInstruction(count, replacement));
    }

    public CFGBuilder swap() {
        return this.add(new SwapInstruction());
    }

    public CFGBuilder objectOf() {
        return this.add(new ObjectOfInstruction());
    }

    public CFGBuilder resultOf(PsiExpression expression2) {
        return this.add(new ResultOfInstruction(expression2));
    }

    public CFGBuilder isInstance(PsiMethodCallExpression anchor) {
        return this.add(new InstanceofInstruction(anchor));
    }

    public CFGBuilder isInstance(PsiExpression anchor, @Nullable PsiExpression operand2, @NotNull PsiType castType) {
        if (castType == null) {
            CFGBuilder.$$$reportNull$$$0(3);
        }
        return this.add(new InstanceofInstruction(anchor, operand2, castType));
    }

    CFGBuilder compare(IElementType relation) {
        return this.add(new BinopInstruction(relation, null, (PsiType)PsiType.BOOLEAN));
    }

    public CFGBuilder ifConditionIs(boolean value2) {
        ConditionalGotoInstruction gotoInstruction = new ConditionalGotoInstruction(null, value2, null);
        this.myBranches.add(() -> gotoInstruction.setOffset(this.myAnalyzer.getInstructionCount()));
        return this.add(gotoInstruction);
    }

    public CFGBuilder ifCondition(IElementType relation) {
        return this.compare(relation).ifConditionIs(true);
    }

    public CFGBuilder ifNotNull() {
        return this.pushNull().ifCondition(JavaTokenType.NE);
    }

    public CFGBuilder ifNull() {
        return this.pushNull().ifCondition(JavaTokenType.EQEQ);
    }

    public CFGBuilder end() {
        this.myBranches.removeLast().run();
        return this;
    }

    public CFGBuilder elseBranch() {
        GotoInstruction gotoInstruction = new GotoInstruction(null);
        this.add(gotoInstruction).end();
        this.myBranches.add(() -> gotoInstruction.setOffset(this.myAnalyzer.getInstructionCount()));
        return this;
    }

    public CFGBuilder doWhileUnknown() {
        ConditionalGotoInstruction jump = new ConditionalGotoInstruction(null, false, null);
        jump.setOffset(this.myAnalyzer.getInstructionCount());
        this.myBranches.add(() -> this.pushUnknown().add(jump));
        return this;
    }

    public CFGBuilder boxUnbox(@NotNull PsiExpression expression2, PsiType expectedType) {
        if (expression2 == null) {
            CFGBuilder.$$$reportNull$$$0(4);
        }
        this.myAnalyzer.generateBoxingUnboxingInstructionFor(expression2, expectedType);
        return this;
    }

    public CFGBuilder boxUnbox(PsiExpression expression2, PsiType expressionType, PsiType expectedType) {
        this.myAnalyzer.generateBoxingUnboxingInstructionFor(expression2, expressionType, expectedType, false);
        return this;
    }

    public CFGBuilder flushFields() {
        return this.add(new FlushFieldsInstruction());
    }

    public CFGBuilder flush(DfaValue value2) {
        if (value2 instanceof DfaVariableValue) {
            this.add(new FlushVariableInstruction((DfaVariableValue)value2));
        }
        return this;
    }

    public CFGBuilder assign() {
        return this.add(new AssignInstruction(null, null));
    }

    public CFGBuilder assignAndPop(DfaValue target, DfType source) {
        if (target instanceof DfaVariableValue) {
            if (source == DfTypes.TOP) {
                this.add(new FlushVariableInstruction((DfaVariableValue)target));
            } else {
                this.pushForWrite((DfaVariableValue)target).push(source).assign().pop();
            }
        }
        return this;
    }

    public CFGBuilder assign(DfaValue target, DfType source) {
        if (target instanceof DfaVariableValue) {
            if (source == DfTypes.TOP) {
                this.flush(target).push(target);
            } else {
                this.pushForWrite((DfaVariableValue)target).push(source).assign();
            }
        } else {
            this.push(source);
        }
        return this;
    }

    public CFGBuilder doTry(@NotNull PsiElement anchor) {
        if (anchor == null) {
            CFGBuilder.$$$reportNull$$$0(5);
        }
        ControlFlow.DeferredOffset offset = new ControlFlow.DeferredOffset();
        this.myAnalyzer.pushTrap(new Trap.TryCatchAll(anchor, offset));
        this.myBranches.add(() -> offset.setOffset(this.myAnalyzer.getInstructionCount()));
        return this;
    }

    public CFGBuilder catchAll() {
        this.myAnalyzer.popTrap(Trap.TryCatchAll.class);
        GotoInstruction gotoInstruction = new GotoInstruction(null);
        this.add(gotoInstruction).end();
        this.myBranches.add(() -> gotoInstruction.setOffset(this.myAnalyzer.getInstructionCount()));
        return this;
    }

    public CFGBuilder doThrow(@NotNull PsiType exceptionType) {
        if (exceptionType == null) {
            CFGBuilder.$$$reportNull$$$0(6);
        }
        this.myAnalyzer.throwException(exceptionType, null);
        return this;
    }

    public CFGBuilder call(PsiMethodCallExpression call) {
        this.myAnalyzer.addBareCall(call, call.getMethodExpression());
        return this;
    }

    public CFGBuilder assignTo(PsiVariable var) {
        return this.pushForWrite(this.getFactory().getVarFactory().createVariableValue(var)).swap().assign();
    }

    public CFGBuilder assignTo(DfaVariableValue var) {
        return this.pushForWrite(var).swap().assign();
    }

    public DfaValueFactory getFactory() {
        return this.myAnalyzer.getFactory();
    }

    public CFGBuilder evaluateFunction(@Nullable PsiExpression functionalExpression) {
        PsiExpression stripped = PsiUtil.deparenthesizeExpression((PsiExpression)functionalExpression);
        if (stripped == null || stripped instanceof PsiLambdaExpression) {
            return this;
        }
        if (stripped instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)stripped;
            PsiExpression qualifier = methodRef.getQualifierExpression();
            if (qualifier != null && !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef)) {
                DfaVariableValue qualifierBinding = this.createTempVariable(qualifier.getType());
                this.pushForWrite(qualifierBinding).pushExpression(qualifier).assign().pop();
                this.myMethodRefQualifiers.put((PsiExpression)methodRef, qualifierBinding);
            }
            return this;
        }
        return this.pushExpression(functionalExpression, NullabilityProblemKind.passingToNotNullParameter).pop();
    }

    public CFGBuilder invokeFunction(int argCount, @Nullable PsiExpression functionalExpression) {
        return this.invokeFunction(argCount, functionalExpression, Nullability.UNKNOWN);
    }

    public CFGBuilder invokeFunction(int argCount, @Nullable PsiExpression functionalExpression, Nullability resultNullability) {
        PsiExpression stripped = PsiUtil.deparenthesizeExpression((PsiExpression)functionalExpression);
        if (this.tryInlineLambda(argCount, functionalExpression, resultNullability, () -> {})) {
            return this;
        }
        if (stripped instanceof PsiMethodReferenceExpression) {
            PsiElement qualifier;
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)stripped;
            JavaResolveResult resolveResult = methodRef.advancedResolve(false);
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class);
            if (method != null && !method.isVarArgs()) {
                if (this.processKnownMethodReference(argCount, methodRef, method)) {
                    return this;
                }
                int expectedArgCount = method.getParameterList().getParametersCount();
                boolean pushQualifier = true;
                if (!method.hasModifierProperty("static") && !method.isConstructor()) {
                    boolean bl = pushQualifier = !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef);
                    if (!pushQualifier) {
                        ++expectedArgCount;
                    }
                }
                if (argCount == expectedArgCount) {
                    if (pushQualifier) {
                        DfaValue qualifierValue = this.myMethodRefQualifiers.remove(methodRef);
                        this.push(qualifierValue == null ? this.getFactory().getUnknown() : qualifierValue);
                        this.moveTopValue(argCount);
                    }
                    this.myAnalyzer.addBareCall(null, (PsiReferenceExpression)methodRef);
                    this.myAnalyzer.generateBoxingUnboxingInstructionFor((PsiExpression)methodRef, resolveResult.getSubstitutor().substitute(method.getReturnType()), LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)methodRef), false);
                    if (resultNullability == Nullability.NOT_NULL) {
                        this.myAnalyzer.addNullCheck(NullabilityProblemKind.nullableFunctionReturn.problem((PsiExpression)methodRef, null));
                    }
                    return this;
                }
            }
            if ((qualifier = methodRef.getQualifier()) instanceof PsiTypeElement && ((PsiTypeElement)qualifier).getType() instanceof PsiArrayType) {
                this.splice(argCount, new int[0]).push(DfTypes.typedObject(((PsiTypeElement)qualifier).getType(), Nullability.NOT_NULL));
                return this;
            }
        }
        this.splice(argCount, new int[0]);
        if (functionalExpression == null) {
            this.pushUnknown();
            return this;
        }
        this.flushFields();
        this.myAnalyzer.addConditionalErrorThrow();
        PsiType functionalInterfaceType = functionalExpression.getType();
        this.myAnalyzer.addMethodThrows(LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType), null);
        PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
        if (returnType != null) {
            this.push(DfTypes.typedObject(returnType, DfaPsiUtil.getTypeNullability(returnType)));
        } else {
            this.pushUnknown();
        }
        return this;
    }

    public boolean tryInlineLambda(int argCount, @Nullable PsiExpression functionalExpression, Nullability resultNullability, Runnable pushArgs) {
        PsiElement scope;
        List<PsiReferenceExpression> refs;
        PsiLambdaExpression localLambda;
        PsiLambdaExpression lambda2;
        Object[] parameters2;
        PsiExpression stripped = PsiUtil.deparenthesizeExpression((PsiExpression)functionalExpression);
        if (stripped instanceof PsiLambdaExpression && (parameters2 = (lambda2 = (PsiLambdaExpression)stripped).getParameterList().getParameters()).length == argCount && lambda2.getBody() != null) {
            pushArgs.run();
            StreamEx.ofReversed((Object[])parameters2).forEach(p -> this.assignTo((PsiVariable)p).pop());
            this.inlineLambda(lambda2, resultNullability);
            StreamEx.of((Object[])parameters2).forEach(p -> this.add(new FlushVariableInstruction(this.getFactory().getVarFactory().createVariableValue((PsiVariable)p))));
            return true;
        }
        PsiLocalVariable localFn = ExpressionUtils.resolveLocalVariable(stripped);
        if (localFn != null && this.myAnalyzer.wasAdded((PsiElement)(localLambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)localFn.getInitializer()), PsiLambdaExpression.class))) && ContainerUtil.getOnlyItem(refs = VariableAccessUtils.getVariableReferences((PsiVariable)localFn, scope = PsiUtil.getVariableCodeBlock((PsiVariable)localFn, null))) == stripped) {
            this.myAnalyzer.removeLambda(localLambda);
            return this.tryInlineLambda(argCount, (PsiExpression)localLambda, resultNullability, pushArgs);
        }
        return false;
    }

    private boolean processKnownMethodReference(int argCount, PsiMethodReferenceExpression methodRef, PsiMethod method) {
        if (argCount != 1 || !method.getName().equals("isInstance")) {
            return false;
        }
        PsiClassObjectAccessExpression qualifier = (PsiClassObjectAccessExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)methodRef.getQualifierExpression()), PsiClassObjectAccessExpression.class);
        if (qualifier == null) {
            return false;
        }
        PsiType type2 = qualifier.getOperand().getType();
        this.push(DfTypes.typedObject(type2, Nullability.NOT_NULL));
        this.add(new InstanceofInstruction((PsiExpression)methodRef, null, type2));
        return true;
    }

    private void moveTopValue(int depth) {
        if (depth > 0) {
            int[] permutation = new int[depth + 1];
            for (int i = 1; i < permutation.length; ++i) {
                permutation[i] = depth + 1 - i;
            }
            this.splice(depth + 1, permutation);
        }
    }

    private CFGBuilder inlineLambda(PsiLambdaExpression lambda2, Nullability resultNullability) {
        PsiElement body2 = lambda2.getBody();
        PsiExpression expression2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2);
        if (expression2 != null) {
            NullabilityProblemKind<PsiExpression> kind2 = resultNullability == Nullability.NOT_NULL ? NullabilityProblemKind.nullableFunctionReturn : NullabilityProblemKind.noProblem;
            this.myAnalyzer.addCustomNullabilityProblem(expression2, kind2);
            this.pushExpression(expression2);
            this.myAnalyzer.removeCustomNullabilityProblem(expression2);
            this.boxUnbox(expression2, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2));
        } else if (body2 instanceof PsiCodeBlock) {
            DfaVariableValue variable = this.createTempVariable(LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2));
            this.myAnalyzer.inlineBlock((PsiCodeBlock)body2, resultNullability, variable);
            this.push(variable);
        } else {
            this.pushUnknown();
        }
        return this;
    }

    public CFGBuilder loopOver(PsiExpression[] expressions2, DfaVariableValue targetVariable) {
        DfaValueFactory factory = this.getFactory();
        if (expressions2.length > 3) {
            for (PsiExpression expression2 : expressions2) {
                this.pushExpression(expression2);
                this.pop();
            }
            ConditionalGotoInstruction condGoto = new ConditionalGotoInstruction(null, false, null);
            condGoto.setOffset(this.myAnalyzer.getInstructionCount());
            this.myBranches.add(() -> this.pushUnknown().add(condGoto));
            DfaValue commonValue = factory.createCommonValue(expressions2, targetVariable.getType());
            if (DfaTypeValue.isUnknown(commonValue)) {
                this.flush(targetVariable).push(targetVariable);
            } else {
                this.pushForWrite(targetVariable).push(commonValue).assign();
            }
        } else {
            this.push(factory.getSentinel());
            for (PsiExpression expression3 : expressions2) {
                this.pushExpression(expression3);
                this.boxUnbox(expression3, targetVariable.getType());
            }
            this.add(new SpliceInstruction(expressions2.length, IntStreamEx.ofIndices((Object[])expressions2).toArray()));
            GotoInstruction gotoInstruction = new GotoInstruction(null);
            gotoInstruction.setOffset(this.myAnalyzer.getInstructionCount());
            this.dup().push(factory.getSentinel()).compare(JavaTokenType.EQEQ);
            ConditionalGotoInstruction condGoto = new ConditionalGotoInstruction(null, false, null);
            this.add(condGoto);
            this.assignTo(targetVariable);
            this.myBranches.add(() -> {
                this.add(gotoInstruction);
                condGoto.setOffset(this.myAnalyzer.getInstructionCount());
                this.pop();
            });
        }
        return this;
    }

    @NotNull
    public DfaVariableValue createTempVariable(@Nullable PsiType type2) {
        DfaVariableValue dfaVariableValue = this.myAnalyzer.createTempVariable(type2);
        if (dfaVariableValue == null) {
            CFGBuilder.$$$reportNull$$$0(7);
        }
        return dfaVariableValue;
    }

    public CFGBuilder chain(Consumer<? super CFGBuilder> operation) {
        operation.accept(this);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/CFGBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/CFGBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pushExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "boxUnbox";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doTry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doThrow";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

