/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;

public abstract class ContractValue {
    ContractValue() {
    }

    abstract DfaValue makeDfaValue(DfaValueFactory var1, DfaCallArguments var2);

    @NotNull
    DfaCondition makeCondition(DfaValueFactory factory, DfaCallArguments arguments) {
        DfaCondition dfaCondition = DfaCondition.getUnknown();
        if (dfaCondition == null) {
            ContractValue.$$$reportNull$$$0(0);
        }
        return dfaCondition;
    }

    public DfaCondition fromCall(DfaValueFactory factory, PsiCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return DfaCondition.getUnknown();
        }
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return DfaCondition.getUnknown();
        }
        DfaValue qualifierValue = null;
        if (call instanceof PsiMethodCallExpression) {
            PsiExpression qualifier = ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression();
            qualifierValue = factory.createValue(qualifier);
        }
        if (qualifierValue == null) {
            qualifierValue = factory.getUnknown();
        }
        boolean varArgCall = MethodCallUtils.isVarArgCall((PsiCall)call);
        PsiExpression[] args = argumentList.getExpressions();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        DfaValue[] argValues = new DfaValue[parameters2.length];
        for (int i = 0; i < parameters2.length; ++i) {
            DfaValue argValue = null;
            if (!(i >= args.length || varArgCall && i >= parameters2.length - 1)) {
                argValue = factory.createValue(args[i]);
            }
            if (argValue == null) {
                argValue = factory.getUnknown();
            }
            argValues[i] = argValue;
        }
        return this.makeCondition(factory, new DfaCallArguments(qualifierValue, argValues, JavaMethodContractUtil.isPure(method)));
    }

    public boolean isExclusive(ContractValue other) {
        return false;
    }

    public ContractValue invert() {
        return null;
    }

    public boolean isBoundCheckingCondition() {
        return false;
    }

    public DfaCallArguments updateArguments(DfaCallArguments arguments, boolean negated) {
        return arguments;
    }

    public OptionalInt getNullCheckedArgument(boolean equalToNull) {
        return this.getArgumentComparedTo(ContractValue.nullValue(), equalToNull);
    }

    public OptionalInt getArgumentComparedTo(ContractValue value2, boolean equal) {
        return OptionalInt.empty();
    }

    public String getPresentationText(PsiMethod method) {
        return this.toString();
    }

    public PsiExpression findLeftPlace(PsiCallExpression call) {
        return null;
    }

    public PsiExpression findRightPlace(PsiCallExpression call) {
        return null;
    }

    public static ContractValue qualifier() {
        return Qualifier.INSTANCE;
    }

    public static ContractValue argument(int index) {
        return new Argument(index);
    }

    public ContractValue specialField(@NotNull SpecialField field) {
        if (field == null) {
            ContractValue.$$$reportNull$$$0(1);
        }
        return new Spec(this, field);
    }

    public static ContractValue constant(Object value2, @NotNull PsiType type2) {
        if (type2 == null) {
            ContractValue.$$$reportNull$$$0(2);
        }
        return new IndependentValue((Function<? super DfaValueFactory, ? extends DfaValue>)((Function)factory -> factory.getConstant(TypeConversionUtil.computeCastTo((Object)value2, (PsiType)type2), type2)), String.valueOf(value2));
    }

    public static ContractValue booleanValue(boolean value2) {
        return value2 ? IndependentValue.TRUE : IndependentValue.FALSE;
    }

    public static ContractValue nullValue() {
        return IndependentValue.NULL;
    }

    public static ContractValue zero() {
        return IndependentValue.ZERO;
    }

    public static ContractValue condition(ContractValue left, RelationType relation, ContractValue right) {
        return new Condition(left, relation, right);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "makeCondition";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "specialField";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "constant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Condition
    extends ContractValue {
        private final ContractValue myLeft;
        private final ContractValue myRight;
        private final RelationType myRelationType;

        Condition(ContractValue left, RelationType type2, ContractValue right) {
            this.myLeft = left;
            this.myRight = right;
            this.myRelationType = type2;
        }

        @Override
        public boolean isBoundCheckingCondition() {
            switch (this.myRelationType) {
                case LE: 
                case LT: 
                case GE: 
                case GT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isExclusive(ContractValue other) {
            if (!(other instanceof Condition)) {
                return false;
            }
            Condition that = (Condition)other;
            if (that.myLeft.equals(this.myLeft) && that.myRight.equals(this.myRight) && that.myRelationType.getNegated() == this.myRelationType) {
                return true;
            }
            if (that.myLeft.equals(this.myRight) && that.myRight.equals(this.myLeft) && that.myRelationType.getNegated() == this.myRelationType.getFlipped()) {
                return true;
            }
            if (that.myRelationType == this.myRelationType) {
                if (that.myLeft.equals(this.myLeft) && that.myRight.isExclusive(this.myRight)) {
                    return true;
                }
                if (that.myLeft.equals(this.myRight) && that.myRight.isExclusive(this.myLeft)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public DfaCallArguments updateArguments(DfaCallArguments arguments, boolean negated) {
            DfType dfType;
            DfType target;
            DfaValue arg;
            DfaNullability targetNullability = DfaNullability.NOT_NULL;
            int index = this.getNullCheckedArgument(negated).orElse(-1);
            if (index == -1) {
                index = this.getNullCheckedArgument(!negated).orElse(-1);
                targetNullability = DfaNullability.NULL;
            }
            if (index >= 0 && index < arguments.myArguments.length && (arg = arguments.myArguments[index]) instanceof DfaTypeValue && !(target = (dfType = arg.getDfType()).meet(targetNullability.asDfType())).equals(dfType) && target != DfTypes.BOTTOM) {
                DfaValue[] newArguments = (DfaValue[])arguments.myArguments.clone();
                newArguments[index] = arg.getFactory().fromDfType(target);
                return new DfaCallArguments(arguments.myQualifier, newArguments, arguments.myPure);
            }
            return arguments;
        }

        @Override
        public OptionalInt getArgumentComparedTo(ContractValue value2, boolean equal) {
            if (this.myRelationType == RelationType.equivalence(equal)) {
                ContractValue other;
                if (this.myLeft == value2) {
                    other = this.myRight;
                } else if (this.myRight == value2) {
                    other = this.myLeft;
                } else {
                    return OptionalInt.empty();
                }
                if (other instanceof Argument) {
                    return OptionalInt.of(((Argument)other).myIndex);
                }
            }
            if (value2 == IndependentValue.FALSE) {
                return this.getArgumentComparedTo(IndependentValue.TRUE, !equal);
            }
            return OptionalInt.empty();
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return factory.getUnknown();
        }

        @Override
        @NotNull
        DfaCondition makeCondition(DfaValueFactory factory, DfaCallArguments arguments) {
            DfaValue left = this.myLeft.makeDfaValue(factory, arguments);
            DfaValue right = this.myRight.makeDfaValue(factory, arguments);
            if (left.getDfType() instanceof DfPrimitiveType) {
                right = DfaUtil.boxUnbox(right, left.getType());
            }
            if (right.getDfType() instanceof DfPrimitiveType) {
                left = DfaUtil.boxUnbox(left, right.getType());
            }
            DfaCondition dfaCondition = left.cond(this.myRelationType, right);
            if (dfaCondition == null) {
                Condition.$$$reportNull$$$0(0);
            }
            return dfaCondition;
        }

        @Override
        public String getPresentationText(PsiMethod method) {
            if (this.myLeft instanceof IndependentValue) {
                return this.myRight.getPresentationText(method) + " " + (Object)((Object)this.myRelationType.getFlipped()) + " " + this.myLeft.getPresentationText(method);
            }
            return this.myLeft.getPresentationText(method) + " " + (Object)((Object)this.myRelationType) + " " + this.myRight.getPresentationText(method);
        }

        @Override
        public PsiExpression findLeftPlace(PsiCallExpression call) {
            return Condition.findPlace(call, this.myLeft);
        }

        @Override
        public PsiExpression findRightPlace(PsiCallExpression call) {
            return Condition.findPlace(call, this.myRight);
        }

        private static PsiExpression findPlace(PsiCallExpression call, ContractValue value2) {
            PsiExpressionList list;
            while (value2 instanceof Spec) {
                value2 = ((Spec)value2).myQualifier;
            }
            if (value2 instanceof Argument && (list = call.getArgumentList()) != null) {
                PsiExpression[] args = list.getExpressions();
                int index = ((Argument)value2).myIndex;
                if (index < args.length - 1 || index == args.length - 1 && !MethodCallUtils.isVarArgCall((PsiCall)call)) {
                    return args[index];
                }
            }
            if (value2 instanceof Qualifier && call instanceof PsiMethodCallExpression) {
                return ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression();
            }
            return null;
        }

        @Override
        public ContractValue invert() {
            return new Condition(this.myLeft, this.myRelationType.getNegated(), this.myRight);
        }

        public String toString() {
            return this.myLeft + " " + (Object)((Object)this.myRelationType) + " " + this.myRight;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractValue$Condition", "makeCondition"));
        }
    }

    private static final class Spec
    extends ContractValue {
        @NotNull
        private final ContractValue myQualifier;
        @NotNull
        private final SpecialField myField;

        Spec(@NotNull ContractValue qualifier, @NotNull SpecialField field) {
            if (qualifier == null) {
                Spec.$$$reportNull$$$0(0);
            }
            if (field == null) {
                Spec.$$$reportNull$$$0(1);
            }
            this.myQualifier = qualifier;
            this.myField = field;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return this.myField.createValue(factory, this.myQualifier.makeDfaValue(factory, arguments));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Spec)) {
                return false;
            }
            Spec that = (Spec)obj;
            return this.myQualifier.equals(that.myQualifier) && this.myField == that.myField;
        }

        @Override
        public String getPresentationText(PsiMethod method) {
            return this.myQualifier.getPresentationText(method) + "." + this.myField + (this.myField == SpecialField.ARRAY_LENGTH ? "" : "()");
        }

        public String toString() {
            return this.myQualifier + "." + this.myField + "()";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "field";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/ContractValue$Spec";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IndependentValue
    extends ContractValue {
        static final IndependentValue NULL = new IndependentValue((Function<? super DfaValueFactory, ? extends DfaValue>)((Function)factory -> factory.getNull()), "null");
        static final IndependentValue TRUE = new IndependentValue(factory -> factory.getBoolean(true), "true"){

            @Override
            public boolean isExclusive(ContractValue other) {
                return other == FALSE;
            }
        };
        static final IndependentValue FALSE = new IndependentValue(factory -> factory.getBoolean(false), "false"){

            @Override
            public boolean isExclusive(ContractValue other) {
                return other == TRUE;
            }
        };
        static final IndependentValue ZERO = new IndependentValue((Function<? super DfaValueFactory, ? extends DfaValue>)((Function)factory -> factory.getInt(0)), "0");
        private final Function<? super DfaValueFactory, ? extends DfaValue> mySupplier;
        private final String myPresentation;

        IndependentValue(Function<? super DfaValueFactory, ? extends DfaValue> supplier, String presentation) {
            this.mySupplier = supplier;
            this.myPresentation = presentation;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return (DfaValue)this.mySupplier.fun((Object)factory);
        }

        public String toString() {
            return this.myPresentation;
        }
    }

    private static final class Argument
    extends ContractValue {
        private final int myIndex;

        Argument(int index) {
            this.myIndex = index;
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            if (arguments.myArguments.length <= this.myIndex) {
                return factory.getUnknown();
            }
            return arguments.myArguments[this.myIndex];
        }

        @Override
        public String getPresentationText(PsiMethod method) {
            PsiParameter[] params = method.getParameterList().getParameters();
            if (this.myIndex == 0 && params.length == 1) {
                return JavaElementKind.PARAMETER.subject();
            }
            if (this.myIndex < params.length) {
                return params[this.myIndex].getName();
            }
            return this.toString();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Argument && this.myIndex == ((Argument)obj).myIndex;
        }

        public String toString() {
            return "param" + (this.myIndex + 1);
        }
    }

    private static class Qualifier
    extends ContractValue {
        static final Qualifier INSTANCE = new Qualifier();

        private Qualifier() {
        }

        @Override
        DfaValue makeDfaValue(DfaValueFactory factory, DfaCallArguments arguments) {
            return arguments.myQualifier;
        }

        public String toString() {
            return "this";
        }
    }
}

