/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullDialog;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteSideEffectsAwareFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.UnwrapSwitchLabelFix;
import com.intellij.codeInspection.AddAssertStatementFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.RemoveAssignmentFix;
import com.intellij.codeInspection.ReplaceComputeWithComputeIfPresentFix;
import com.intellij.codeInspection.ReplaceTypeInCastFix;
import com.intellij.codeInspection.ReplaceWithTernaryOperatorFix;
import com.intellij.codeInspection.ReplaceWithTrivialLambdaFix;
import com.intellij.codeInspection.StreamFilterNotNullFix;
import com.intellij.codeInspection.SurroundWithIfFix;
import com.intellij.codeInspection.WrapWithMutableCollectionFix;
import com.intellij.codeInspection.dataFlow.DataFlowInspectionBase;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.TrackingRunner;
import com.intellij.codeInspection.dataFlow.fix.FindDfaProblemCauseFix;
import com.intellij.codeInspection.dataFlow.fix.SurroundWithRequireNonNullFix;
import com.intellij.codeInspection.nullable.NullableStuffInspection;
import com.intellij.java.JavaBundle;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowInspection
extends DataFlowInspectionBase {
    @Override
    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression assignment, boolean onTheFly) {
        boolean toRemove2;
        IElementType op = assignment.getOperationTokenType();
        boolean bl = toRemove2 = op == JavaTokenType.ANDEQ && !evaluatesToTrue || op == JavaTokenType.OREQ && evaluatesToTrue;
        if (toRemove2 && !onTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{toRemove2 ? new RemoveAssignmentFix() : DataFlowInspection.createSimplifyToAssignmentFix()};
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Override
    protected LocalQuickFix createReplaceWithTrivialLambdaFix(Object value2) {
        return new ReplaceWithTrivialLambdaFix(value2);
    }

    @Override
    protected LocalQuickFix createMutabilityViolationFix(PsiElement violation, boolean onTheFly) {
        return WrapWithMutableCollectionFix.createFix(violation, onTheFly);
    }

    @Override
    @Nullable
    protected LocalQuickFix createExplainFix(PsiExpression anchor, TrackingRunner.DfaProblemType problemType) {
        return new FindDfaProblemCauseFix(this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, this.IGNORE_ASSERT_STATEMENTS, anchor, problemType);
    }

    @Override
    @Nullable
    protected LocalQuickFix createUnwrapSwitchLabelFix() {
        return new UnwrapSwitchLabelFix();
    }

    @Override
    protected LocalQuickFix createIntroduceVariableFix() {
        return new IntroduceVariableFix(true);
    }

    @Override
    protected LocalQuickFixOnPsiElement createSimplifyBooleanFix(PsiElement element, boolean value2) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        if (PsiTreeUtil.findChildOfType((PsiElement)element, PsiAssignmentExpression.class) != null) {
            return null;
        }
        PsiExpression expression2 = (PsiExpression)element;
        while (element.getParent() instanceof PsiExpression) {
            element = element.getParent();
        }
        SimplifyBooleanExpressionFix fix2 = new SimplifyBooleanExpressionFix(expression2, value2);
        if (!fix2.isAvailable() || SimplifyBooleanExpressionFix.canBeSimplified((PsiExpression)element)) {
            return null;
        }
        return fix2;
    }

    private static boolean isVolatileFieldReference(PsiExpression qualifier) {
        PsiElement target = qualifier instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifier).resolve() : null;
        return target instanceof PsiField && ((PsiField)target).hasModifierProperty("volatile");
    }

    @Override
    @NotNull
    protected List<LocalQuickFix> createMethodReferenceNPEFixes(PsiMethodReferenceExpression methodRef, boolean onTheFly) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        ContainerUtil.addIfNotNull(fixes, (Object)StreamFilterNotNullFix.makeFix((PsiElement)methodRef));
        if (onTheFly) {
            fixes.add(new ReplaceWithTernaryOperatorFix.ReplaceMethodRefWithTernaryOperatorFix());
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            DataFlowInspection.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    protected LocalQuickFix createRemoveAssignmentFix(PsiAssignmentExpression assignment) {
        if (assignment == null || assignment.getRExpression() == null || !(assignment.getParent() instanceof PsiExpressionStatement)) {
            return null;
        }
        return new DeleteSideEffectsAwareFix((PsiStatement)assignment.getParent(), assignment.getRExpression(), true);
    }

    @Override
    @NotNull
    protected List<LocalQuickFix> createCastFixes(PsiTypeCastExpression castExpression, PsiType realType, boolean onTheFly, boolean alwaysFails) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        PsiExpression operand2 = castExpression.getOperand();
        PsiTypeElement typeElement = castExpression.getCastType();
        if (typeElement != null && operand2 != null) {
            PsiType operandType;
            if (!alwaysFails && !SideEffectChecker.mayHaveSideEffects(operand2) && ControlFlowUtils.canExtractStatement((PsiExpression)castExpression)) {
                String suffix = " instanceof " + typeElement.getText();
                fixes.add(new AddAssertStatementFix(ParenthesesUtils.getText(operand2, 8) + suffix));
                if (onTheFly && SurroundWithIfFix.isAvailable(operand2)) {
                    fixes.add(new SurroundWithIfFix(operand2, suffix));
                }
            }
            if (realType != null && (operandType = operand2.getType()) != null) {
                PsiType type2 = typeElement.getType();
                PsiType[] types = new PsiType[]{realType};
                if (realType instanceof PsiIntersectionType) {
                    types = ((PsiIntersectionType)realType).getConjuncts();
                }
                for (PsiType psiType : types) {
                    if (psiType.isAssignableFrom(operandType)) continue;
                    psiType = DfaPsiUtil.tryGenerify(operand2, psiType);
                    fixes.add(new ReplaceTypeInCastFix(type2, psiType));
                }
            }
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            DataFlowInspection.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<LocalQuickFix> createNPEFixes(PsiExpression qualifier, PsiExpression expression2, boolean onTheFly) {
        qualifier = PsiUtil.deparenthesizeExpression((PsiExpression)qualifier);
        SmartList fixes = new SmartList();
        if (qualifier == null || expression2 == null) {
            SmartList smartList = fixes;
            if (smartList == null) {
                DataFlowInspection.$$$reportNull$$$0(2);
            }
            return smartList;
        }
        try {
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)StreamFilterNotNullFix.makeFix((PsiElement)qualifier));
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)ReplaceComputeWithComputeIfPresentFix.makeFix((PsiElement)qualifier));
            if (DataFlowInspection.isVolatileFieldReference(qualifier)) {
                ContainerUtil.addIfNotNull((Collection)fixes, (Object)this.createIntroduceVariableFix());
            } else if (!ExpressionUtils.isNullLiteral(qualifier) && !SideEffectChecker.mayHaveSideEffects(qualifier)) {
                String suffix = " != null";
                if (PsiUtil.getLanguageLevel((PsiElement)qualifier).isAtLeast(LanguageLevel.JDK_1_4) && ControlFlowUtils.canExtractStatement(expression2)) {
                    String replacement = ParenthesesUtils.getText(qualifier, 9) + suffix;
                    fixes.add(new AddAssertStatementFix(replacement));
                }
                if (onTheFly && SurroundWithIfFix.isAvailable(qualifier)) {
                    fixes.add(new SurroundWithIfFix(qualifier, suffix));
                }
                if (onTheFly && ReplaceWithTernaryOperatorFix.isAvailable(qualifier, expression2)) {
                    fixes.add(new ReplaceWithTernaryOperatorFix(qualifier));
                }
            }
            if (!ExpressionUtils.isNullLiteral(qualifier) && PsiUtil.isLanguageLevel7OrHigher((PsiElement)qualifier)) {
                fixes.add(new SurroundWithRequireNonNullFix(qualifier));
            }
            if (onTheFly && !ExpressionUtils.isNullLiteral(qualifier)) {
                ContainerUtil.addIfNotNull((Collection)fixes, (Object)this.createExplainFix(qualifier, new TrackingRunner.NullableDfaProblemType()));
            }
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)DfaOptionalSupport.registerReplaceOptionalOfWithOfNullableFix(qualifier));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        SmartList smartList = fixes;
        if (smartList == null) {
            DataFlowInspection.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @Override
    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter2) {
        return new NullableStuffInspection.NavigateToNullLiteralArguments(parameter2);
    }

    private static JCheckBox createCheckBoxWithHTML(String text2, boolean selected, Consumer<? super JCheckBox> consumer) {
        JCheckBox box = new JCheckBox(XmlStringUtil.wrapInHtml((CharSequence)text2));
        box.setVerticalTextPosition(1);
        box.setSelected(selected);
        box.getModel().addItemListener(event -> consumer.accept(box));
        return box;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodReferenceNPEFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCastFixes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNPEFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class OptionsPanel
    extends JPanel {
        private static final int BUTTON_OFFSET = 20;
        private final JButton myConfigureAnnotations;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            JCheckBox suggestNullables = DataFlowInspection.createCheckBoxWithHTML(JavaBundle.message((String)"inspection.data.flow.nullable.quickfix.option", (Object[])new Object[0]), DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS, box -> {
                DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS = box.isSelected();
            });
            JCheckBox dontReportTrueAsserts = DataFlowInspection.createCheckBoxWithHTML(JavaBundle.message((String)"inspection.data.flow.true.asserts.option", (Object[])new Object[0]), DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS, box -> {
                DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS = box.isSelected();
            });
            JCheckBox ignoreAssertions = DataFlowInspection.createCheckBoxWithHTML("Ignore assert statements", DataFlowInspection.this.IGNORE_ASSERT_STATEMENTS, box -> {
                DataFlowInspection.this.IGNORE_ASSERT_STATEMENTS = box.isSelected();
            });
            JCheckBox reportConstantReferences = DataFlowInspection.createCheckBoxWithHTML("Warn when reading a value guaranteed to be constant", DataFlowInspection.this.REPORT_CONSTANT_REFERENCE_VALUES, box -> {
                DataFlowInspection.this.REPORT_CONSTANT_REFERENCE_VALUES = box.isSelected();
            });
            JCheckBox treatUnknownMembersAsNullable = DataFlowInspection.createCheckBoxWithHTML("Treat non-annotated members and parameters as @Nullable", DataFlowInspection.this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, box -> {
                DataFlowInspection.this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE = box.isSelected();
            });
            JCheckBox reportNullArguments = DataFlowInspection.createCheckBoxWithHTML("Report not-null required parameter with null-literal argument usages", DataFlowInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER, box -> {
                DataFlowInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = box.isSelected();
            });
            JCheckBox reportNullableMethodsReturningNotNull = DataFlowInspection.createCheckBoxWithHTML("Report nullable methods that always return a non-null value", DataFlowInspection.this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL, box -> {
                DataFlowInspection.this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL = box.isSelected();
            });
            JCheckBox reportUnsoundWarnings = DataFlowInspection.createCheckBoxWithHTML("Report problems that happen only on some code paths", DataFlowInspection.this.REPORT_UNSOUND_WARNINGS, box -> {
                DataFlowInspection.this.REPORT_UNSOUND_WARNINGS = box.isSelected();
            });
            gc.insets = JBUI.emptyInsets();
            gc.gridy = 0;
            this.add((Component)suggestNullables, gc);
            this.myConfigureAnnotations = NullableNotNullDialog.createConfigureAnnotationsButton((Component)this);
            ++gc.gridy;
            gc.fill = 0;
            gc.insets.left = 20;
            gc.insets.bottom = 15;
            this.add((Component)this.myConfigureAnnotations, gc);
            gc.fill = 2;
            gc.weighty = 1.0;
            gc.insets.left = 0;
            ++gc.gridy;
            this.add((Component)dontReportTrueAsserts, gc);
            ++gc.gridy;
            this.add((Component)ignoreAssertions, gc);
            ++gc.gridy;
            this.add((Component)reportConstantReferences, gc);
            ++gc.gridy;
            this.add((Component)treatUnknownMembersAsNullable, gc);
            ++gc.gridy;
            this.add((Component)reportNullArguments, gc);
            ++gc.gridy;
            this.add((Component)reportNullableMethodsReturningNotNull, gc);
            ++gc.gridy;
            this.add((Component)reportUnsoundWarnings, gc);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferred = super.getPreferredSize();
            if (!this.isPreferredSizeSet()) {
                Dimension size = this.myConfigureAnnotations.getPreferredSize();
                preferred.width = size.width + 20;
            }
            return preferred;
        }
    }
}

