/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowInspectionBase;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DataFlowInstructionVisitor
extends StandardInstructionVisitor {
    private static final Logger LOG = Logger.getInstance(DataFlowInstructionVisitor.class);
    private final Map<NullabilityProblemKind.NullabilityProblem<?>, StateInfo> myStateInfos = new LinkedHashMap();
    private final Map<PsiTypeCastExpression, StateInfo> myClassCastProblems = new HashMap<PsiTypeCastExpression, StateInfo>();
    private final Map<PsiTypeCastExpression, TypeConstraint> myRealOperandTypes = new HashMap<PsiTypeCastExpression, TypeConstraint>();
    private final Map<PsiCallExpression, Boolean> myFailingCalls = new HashMap<PsiCallExpression, Boolean>();
    private final Map<ExpressionChunk, DataFlowInspectionBase.ConstantResult> myConstantExpressions = new HashMap<ExpressionChunk, DataFlowInspectionBase.ConstantResult>();
    private final Map<PsiElement, ThreeState> myOfNullableCalls = new HashMap<PsiElement, ThreeState>();
    private final Map<PsiAssignmentExpression, Pair<PsiType, PsiType>> myArrayStoreProblems = new HashMap<PsiAssignmentExpression, Pair<PsiType, PsiType>>();
    private final Map<PsiMethodReferenceExpression, DataFlowInspectionBase.ConstantResult> myMethodReferenceResults = new HashMap<PsiMethodReferenceExpression, DataFlowInspectionBase.ConstantResult>();
    private final Map<PsiArrayAccessExpression, ThreeState> myOutOfBoundsArrayAccesses = new HashMap<PsiArrayAccessExpression, ThreeState>();
    private final Set<PsiElement> myReceiverMutabilityViolation = new HashSet<PsiElement>();
    private final Set<PsiElement> myArgumentMutabilityViolation = new HashSet<PsiElement>();
    private final Map<PsiExpression, Boolean> mySameValueAssigned = new HashMap<PsiExpression, Boolean>();
    private final Map<PsiReferenceExpression, Boolean> mySameArguments = new HashMap<PsiReferenceExpression, Boolean>();
    private final Map<PsiExpression, ThreeState> mySwitchLabelsReachability = new HashMap<PsiExpression, ThreeState>();
    private boolean myAlwaysReturnsNotNull = true;
    private final List<DfaMemoryState> myEndOfInitializerStates = new ArrayList<DfaMemoryState>();
    private static final CallMatcher USELESS_SAME_ARGUMENTS = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Integer", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Long", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Float", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Double", "min", "max").parameterCount(2), CallMatcher.instanceCall("java.lang.String", "replace").parameterCount(2));

    DataFlowInstructionVisitor() {
    }

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiExpression left = instruction.getLExpression();
        if (left != null && !Boolean.FALSE.equals(this.mySameValueAssigned.get(left))) {
            if (!left.isPhysical()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Non-physical element in assignment instruction: " + left.getParent().getText(), new Throwable());
                }
            } else {
                DfaValue value2 = memState.peek();
                DfaValue target = memState.getStackValue(1);
                DfType dfType = memState.getDfType(value2);
                if (!(target == null || !memState.areEqual(value2, target) || dfType instanceof DfConstantType && DataFlowInstructionVisitor.isFloatingZero(((DfConstantType)dfType).getValue()) || TypeUtils.isJavaLangString(left.getType()) && !memState.isNull(value2) || DataFlowInstructionVisitor.isAssignmentToDefaultValueInConstructor(instruction, runner, target))) {
                    this.mySameValueAssigned.merge(left, Boolean.TRUE, Boolean::logicalAnd);
                } else {
                    this.mySameValueAssigned.put(left, Boolean.FALSE);
                }
            }
        }
        return super.visitAssign(instruction, runner, memState);
    }

    @Override
    protected void beforeConditionalJump(ConditionalGotoInstruction instruction, boolean isTrueBranch) {
        PsiExpression anchor = instruction.getPsiAnchor();
        if (anchor != null && PsiImplUtil.getSwitchLabel(anchor) != null) {
            this.mySwitchLabelsReachability.merge(anchor, ThreeState.fromBoolean((boolean)isTrueBranch), ThreeState::merge);
        }
    }

    private static boolean isAssignmentToDefaultValueInConstructor(AssignInstruction instruction, DataFlowRunner runner, DfaValue target) {
        PsiType type2;
        boolean isDefaultValue;
        if (!(target instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var = (DfaVariableValue)target;
        if (!(var.getPsiVariable() instanceof PsiField) || var.getQualifier() == null || !(var.getQualifier().getDescriptor() instanceof DfaExpressionFactory.ThisDescriptor)) {
            return false;
        }
        PsiExpression rExpression = instruction.getRExpression();
        while (rExpression instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)rExpression).getOperationTokenType().equals(JavaTokenType.EQ)) {
            rExpression = ((PsiAssignmentExpression)rExpression).getRExpression();
        }
        DfaValue dest = runner.getFactory().createValue(rExpression);
        if (dest == null) {
            return false;
        }
        DfType dfType = dest.getDfType();
        boolean bl = isDefaultValue = DfConstantType.isConst(dfType, PsiTypesUtil.getDefaultValue((PsiType)(type2 = var.getType()))) || DfConstantType.isConst(dfType, 0) && TypeConversionUtil.isIntegralNumberType((PsiType)type2);
        if (!isDefaultValue) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)rExpression, PsiMethod.class);
        return method != null && method.isConstructor();
    }

    private static boolean isFloatingZero(Object value2) {
        if (value2 instanceof Double) {
            return (Double)value2 == 0.0;
        }
        if (value2 instanceof Float) {
            return ((Float)value2).floatValue() == 0.0f;
        }
        return false;
    }

    StreamEx<PsiExpression> sameValueAssignments() {
        return StreamEx.ofKeys(this.mySameValueAssigned, Boolean::booleanValue);
    }

    StreamEx<PsiReferenceExpression> pointlessSameArguments() {
        return StreamEx.ofKeys(this.mySameArguments, Boolean::booleanValue);
    }

    @Override
    protected void onTypeCast(PsiTypeCastExpression castExpression, DfaMemoryState state, boolean castPossible) {
        this.myClassCastProblems.computeIfAbsent(castExpression, e -> new StateInfo()).update(state, castPossible);
    }

    StreamEx<NullabilityProblemKind.NullabilityProblem<?>> problems() {
        return StreamEx.ofKeys(this.myStateInfos, StateInfo::shouldReport);
    }

    public Map<PsiAssignmentExpression, Pair<PsiType, PsiType>> getArrayStoreProblems() {
        return this.myArrayStoreProblems;
    }

    Map<PsiElement, ThreeState> getOfNullableCalls() {
        return this.myOfNullableCalls;
    }

    Map<PsiExpression, DataFlowInspectionBase.ConstantResult> getConstantExpressions() {
        return EntryStream.of(this.myConstantExpressions).filterKeys(chunk -> chunk.myRange == null).mapKeys(chunk -> chunk.myExpression).toMap();
    }

    Map<ExpressionChunk, DataFlowInspectionBase.ConstantResult> getConstantExpressionChunks() {
        return this.myConstantExpressions;
    }

    Map<PsiMethodReferenceExpression, DataFlowInspectionBase.ConstantResult> getMethodReferenceResults() {
        return this.myMethodReferenceResults;
    }

    Map<PsiExpression, ThreeState> getSwitchLabelsReachability() {
        return this.mySwitchLabelsReachability;
    }

    EntryStream<PsiTypeCastExpression, Pair<Boolean, PsiType>> getFailingCastExpressions() {
        return EntryStream.of(this.myClassCastProblems).filterValues(StateInfo::shouldReport).mapToValue((cast, info) -> Pair.create((Object)info.alwaysFails(), (Object)this.myRealOperandTypes.getOrDefault(cast, TypeConstraints.TOP).getPsiType(cast.getProject())));
    }

    Set<PsiElement> getMutabilityViolations(boolean receiver2) {
        return receiver2 ? this.myReceiverMutabilityViolation : this.myArgumentMutabilityViolation;
    }

    public List<DfaMemoryState> getEndOfInitializerStates() {
        return this.myEndOfInitializerStates;
    }

    Stream<PsiArrayAccessExpression> outOfBoundsArrayAccesses() {
        return StreamEx.ofKeys(this.myOutOfBoundsArrayAccesses, arg_0 -> ThreeState.YES.equals(arg_0));
    }

    StreamEx<PsiCallExpression> alwaysFailingCalls() {
        return StreamEx.ofKeys(this.myFailingCalls, v -> v);
    }

    boolean isAlwaysReturnsNotNull(Instruction[] instructions) {
        return this.myAlwaysReturnsNotNull && ContainerUtil.exists((Object[])instructions, i -> i instanceof ReturnInstruction && ((ReturnInstruction)i).getAnchor() instanceof PsiReturnStatement);
    }

    public boolean isInstanceofRedundant(InstanceofInstruction instruction) {
        Object expression2 = instruction.getExpression();
        if (expression2 == null || this.myUsefulInstanceofs.contains(instruction) || !this.myReachable.contains(instruction)) {
            return false;
        }
        DataFlowInspectionBase.ConstantResult result = expression2 instanceof PsiMethodReferenceExpression ? this.myMethodReferenceResults.get(expression2) : this.myConstantExpressions.get(new ExpressionChunk((PsiExpression)expression2, null));
        return result != DataFlowInspectionBase.ConstantResult.TRUE && result != DataFlowInspectionBase.ConstantResult.FALSE;
    }

    @Override
    protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState memState) {
        Application application;
        if (value2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(1);
        }
        if (memState == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(2);
        }
        if (!expression2.isPhysical() && ((application = ApplicationManager.getApplication()).isEAP() || application.isInternal() || application.isUnitTestMode())) {
            throw new IllegalStateException("Non-physical expression is passed");
        }
        expression2.accept((PsiElementVisitor)new ExpressionVisitor(value2, memState));
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (parent instanceof PsiTypeCastExpression) {
            TypeConstraint fact = TypeConstraint.fromDfType(memState.getDfType(value2));
            this.myRealOperandTypes.merge((PsiTypeCastExpression)parent, fact, TypeConstraint::join);
        }
        this.reportConstantExpressionValue(value2, memState, expression2, range);
    }

    @Override
    protected void beforeMethodCall(@NotNull PsiExpression expression2, @NotNull DfaCallArguments arguments, @NotNull DfaMemoryState memState) {
        PsiReferenceExpression reference;
        if (expression2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(3);
        }
        if (arguments == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(4);
        }
        if (memState == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(5);
        }
        if ((reference = USELESS_SAME_ARGUMENTS.getReferenceIfMatched(expression2)) != null) {
            this.mySameArguments.merge(reference, memState.areEqual(arguments.myArguments[0], arguments.myArguments[1]), Boolean::logicalAnd);
        }
    }

    @Override
    protected void beforeMethodReferenceResultPush(@NotNull DfaValue value2, @NotNull PsiMethodReferenceExpression methodRef, @NotNull DfaMemoryState state) {
        List<StandardMethodContract> contracts2;
        PsiMethod method;
        if (value2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(6);
        }
        if (methodRef == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(7);
        }
        if (state == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(8);
        }
        if (OptionalUtil.OPTIONAL_OF_NULLABLE.methodReferenceMatches(methodRef)) {
            this.processOfNullableResult(value2, state, methodRef.getReferenceNameElement());
        }
        if ((method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class)) != null && JavaMethodContractUtil.isPure(method) && ((contracts2 = JavaMethodContractUtil.getMethodContracts(method)).isEmpty() || !contracts2.get(0).isTrivial())) {
            this.myMethodReferenceResults.compute(methodRef, (mr, curState) -> DataFlowInspectionBase.ConstantResult.mergeValue(curState, state, value2));
        }
    }

    private void processOfNullableResult(@NotNull DfaValue value2, @NotNull DfaMemoryState memState, PsiElement anchor) {
        DfaValueFactory factory;
        DfaValue optionalValue;
        if (value2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(9);
        }
        if (memState == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(10);
        }
        ThreeState present = memState.isNull(optionalValue = SpecialField.OPTIONAL_VALUE.createValue(factory = value2.getFactory(), value2)) ? ThreeState.NO : (memState.isNotNull(optionalValue) ? ThreeState.YES : ThreeState.UNSURE);
        this.myOfNullableCalls.merge(anchor, present, ThreeState::merge);
    }

    @Override
    protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
        this.myOutOfBoundsArrayAccesses.merge(expression2, ThreeState.fromBoolean((boolean)alwaysOutOfBounds), ThreeState::merge);
    }

    @Override
    protected void processArrayStoreTypeMismatch(PsiAssignmentExpression assignmentExpression, PsiType fromType, PsiType toType) {
        if (assignmentExpression != null) {
            this.myArrayStoreProblems.put(assignmentExpression, (Pair<PsiType, PsiType>)Pair.create((Object)fromType, (Object)toType));
        }
    }

    @Override
    public DfaInstructionState[] visitEndOfInitializer(EndOfInitializerInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        if (!instruction.isStatic()) {
            this.myEndOfInitializerStates.add(state.createCopy());
        }
        return super.visitEndOfInitializer(instruction, runner, state);
    }

    private static boolean hasNonTrivialFailingContracts(PsiCallExpression call) {
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(call);
        return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> contract.getReturnValue().isFail() && !contract.isTrivial());
    }

    private void reportConstantExpressionValue(DfaValue value2, DfaMemoryState memState, PsiExpression expression2, TextRange range) {
        if (expression2 instanceof PsiLiteralExpression) {
            return;
        }
        ExpressionChunk chunk = new ExpressionChunk(expression2, range);
        this.myConstantExpressions.compute(chunk, (c, curState) -> DataFlowInspectionBase.ConstantResult.mergeValue(curState, memState, value2));
    }

    @Override
    protected boolean checkNotNullable(DfaMemoryState state, @NotNull DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        if (value2 == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(11);
        }
        if (problem != null && problem.getKind() == NullabilityProblemKind.nullableReturn && !state.isNotNull(value2)) {
            this.myAlwaysReturnsNotNull = false;
        }
        boolean ok = super.checkNotNullable(state, value2, problem);
        if (problem == null) {
            return ok;
        }
        StateInfo info = this.myStateInfos.computeIfAbsent(problem, k -> new StateInfo());
        info.update(state, ok);
        return ok;
    }

    @Override
    protected void reportMutabilityViolation(boolean receiver2, @NotNull PsiElement anchor) {
        if (anchor == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(12);
        }
        if (receiver2) {
            if (anchor instanceof PsiMethodReferenceExpression) {
                anchor = ((PsiMethodReferenceExpression)anchor).getReferenceNameElement();
            } else if (anchor instanceof PsiMethodCallExpression) {
                anchor = ((PsiMethodCallExpression)anchor).getMethodExpression().getReferenceNameElement();
            }
            if (anchor != null) {
                this.myReceiverMutabilityViolation.add(anchor);
            }
        } else {
            this.myArgumentMutabilityViolation.add(anchor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInstructionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeExpressionPush";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeMethodCall";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeMethodReferenceResultPush";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processOfNullableResult";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNotNullable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "reportMutabilityViolation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ExpressionChunk {
        @NotNull
        final PsiExpression myExpression;
        @Nullable
        final TextRange myRange;

        ExpressionChunk(@NotNull PsiExpression expression2, @Nullable TextRange range) {
            if (expression2 == null) {
                ExpressionChunk.$$$reportNull$$$0(0);
            }
            this.myExpression = expression2;
            this.myRange = range;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpressionChunk chunk = (ExpressionChunk)o;
            return this.myExpression.equals(chunk.myExpression) && Objects.equals(this.myRange, chunk.myRange);
        }

        public int hashCode() {
            return 31 * this.myExpression.hashCode() + Objects.hashCode(this.myRange);
        }

        public String toString() {
            String text2 = this.myExpression.getText();
            return this.myRange == null ? text2 : text2.substring(this.myRange.getStartOffset(), this.myRange.getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/DataFlowInstructionVisitor$ExpressionChunk", "<init>"));
        }
    }

    private class ExpressionVisitor
    extends JavaElementVisitor {
        private final DfaValue myValue;
        private final DfaMemoryState myMemState;

        ExpressionVisitor(DfaValue value2, DfaMemoryState memState) {
            this.myValue = value2;
            this.myMemState = memState;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            if (OptionalUtil.OPTIONAL_OF_NULLABLE.test(call)) {
                DataFlowInstructionVisitor.this.processOfNullableResult(this.myValue, this.myMemState, (PsiElement)call.getArgumentList().getExpressions()[0]);
            }
        }

        public void visitCallExpression(PsiCallExpression call) {
            super.visitCallExpression(call);
            Boolean isFailing = (Boolean)DataFlowInstructionVisitor.this.myFailingCalls.get(call);
            if (isFailing != null || DataFlowInstructionVisitor.hasNonTrivialFailingContracts(call)) {
                DataFlowInstructionVisitor.this.myFailingCalls.put(call, DfaTypeValue.isContractFail(this.myValue) && !Boolean.FALSE.equals(isFailing));
            }
        }
    }

    private static class StateInfo {
        boolean ephemeralException;
        boolean normalException;
        boolean normalOk;

        private StateInfo() {
        }

        void update(DfaMemoryState state, boolean ok) {
            if (state.isEphemeral()) {
                if (!ok) {
                    this.ephemeralException = true;
                }
            } else if (ok) {
                this.normalOk = true;
            } else {
                this.normalException = true;
            }
        }

        boolean shouldReport() {
            return this.normalException || this.ephemeralException && !this.normalOk;
        }

        boolean alwaysFails() {
            return (this.normalException || this.ephemeralException) && !this.normalOk;
        }
    }
}

