/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaOptionalSupport {
    @Nullable
    static LocalQuickFix registerReplaceOptionalOfWithOfNullableFix(@NotNull PsiExpression qualifier) {
        PsiClass containingClass;
        PsiMethodCallExpression call;
        if (qualifier == null) {
            DfaOptionalSupport.$$$reportNull$$$0(0);
        }
        PsiMethod method = (call = DfaOptionalSupport.findCallExpression((PsiElement)qualifier)) == null ? null : call.resolveMethod();
        PsiClass psiClass = containingClass = method == null ? null : method.getContainingClass();
        if (containingClass != null && "of".equals(method.getName())) {
            String qualifiedName = containingClass.getQualifiedName();
            if ("java.util.Optional".equals(qualifiedName)) {
                return new ReplaceOptionalCallFix("ofNullable", false);
            }
            if ("com.google.common.base.Optional".equals(qualifiedName)) {
                return new ReplaceOptionalCallFix("fromNullable", false);
            }
        }
        return null;
    }

    private static PsiMethodCallExpression findCallExpression(@NotNull PsiElement anchor) {
        PsiElement parent;
        PsiElement argList;
        if (anchor == null) {
            DfaOptionalSupport.$$$reportNull$$$0(1);
        }
        if ((argList = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor).getParent()) instanceof PsiExpressionList && (parent = argList.getParent()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)parent;
        }
        return null;
    }

    @Nullable
    static LocalQuickFix createReplaceOptionalOfNullableWithEmptyFix(@NotNull PsiElement anchor) {
        PsiMethodCallExpression parent;
        if (anchor == null) {
            DfaOptionalSupport.$$$reportNull$$$0(2);
        }
        if ((parent = DfaOptionalSupport.findCallExpression(anchor)) == null) {
            return null;
        }
        boolean jdkOptional = OptionalUtil.JDK_OPTIONAL_OF_NULLABLE.test(parent);
        return new ReplaceOptionalCallFix(jdkOptional ? "empty" : "absent", true);
    }

    @Nullable
    static LocalQuickFix createReplaceOptionalOfNullableWithOfFix(@NotNull PsiElement anchor) {
        PsiMethodCallExpression parent;
        if (anchor == null) {
            DfaOptionalSupport.$$$reportNull$$$0(3);
        }
        if ((parent = DfaOptionalSupport.findCallExpression(anchor)) == null) {
            return null;
        }
        return new ReplaceOptionalCallFix("of", false);
    }

    @NotNull
    public static DfType getOptionalValue(boolean present) {
        DfReferenceType valueType = present ? DfTypes.NOT_NULL_OBJECT : DfTypes.NULL;
        DfType dfType = SpecialField.OPTIONAL_VALUE.asDfType(valueType);
        if (dfType == null) {
            DfaOptionalSupport.$$$reportNull$$$0(4);
        }
        return dfType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaOptionalSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaOptionalSupport";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReplaceOptionalOfWithOfNullableFix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findCallExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceOptionalOfNullableWithEmptyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceOptionalOfNullableWithOfFix";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceOptionalCallFix
    implements LocalQuickFix {
        private final String myTargetMethodName;
        private final boolean myClearArguments;

        ReplaceOptionalCallFix(String targetMethodName, boolean clearArguments) {
            this.myTargetMethodName = targetMethodName;
            this.myClearArguments = clearArguments;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"." + this.myTargetMethodName + "()"});
            if (string == null) {
                ReplaceOptionalCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression methodCallExpression;
            if (project == null) {
                ReplaceOptionalCallFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceOptionalCallFix.$$$reportNull$$$0(2);
            }
            if ((methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class)) != null) {
                PsiExpressionList argList;
                PsiExpression[] args;
                ExpressionUtils.bindCallTo(methodCallExpression, this.myTargetMethodName);
                if (this.myClearArguments && (args = (argList = methodCallExpression.getArgumentList()).getExpressions()).length > 0) {
                    argList.deleteChildRange((PsiElement)args[0], (PsiElement)args[args.length - 1]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaOptionalSupport$ReplaceOptionalCallFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaOptionalSupport$ReplaceOptionalCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

