/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardcodedContracts {
    private static final List<MethodContract> ARRAY_RANGE_CONTRACTS = ContainerUtil.immutableList((Object[])new MethodContract[]{MethodContract.singleConditionContract(ContractValue.argument(1), RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), ContractReturnValue.fail()), MethodContract.singleConditionContract(ContractValue.argument(2), RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), ContractReturnValue.fail()), MethodContract.singleConditionContract(ContractValue.argument(1), RelationType.GT, ContractValue.argument(2), ContractReturnValue.fail())});
    private static final CallMatcher QUEUE_POLL = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Queue", "poll").parameterCount(0), CallMatcher.instanceCall("java.util.Deque", "pollFirst", "pollLast").parameterCount(0));
    private static final CallMapper<ContractProvider> HARDCODED_CONTRACTS = new CallMapper<ContractProvider>().register(CallMatcher.anyOf(CallMatcher.staticCall("com.google.common.base.Preconditions", "checkNotNull"), CallMatcher.staticCall("java.util.Objects", "requireNonNull")), (call, cnt) -> cnt > 0 ? HardcodedContracts.failIfNull(0, cnt, true) : null).register((CallMatcher)CallMatcher.staticCall("com.google.common.base.Preconditions", "checkArgument", "checkState"), (call, cnt) -> {
        if (cnt == 0) {
            return null;
        }
        StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(cnt);
        constraints[0] = StandardMethodContract.ValueConstraint.FALSE_VALUE;
        return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
    }).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "charAt", "codePointAt").parameterCount(1), ContractProvider.of(HardcodedContracts.specialFieldRangeContract(0, RelationType.LT, SpecialField.STRING_LENGTH))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.String", "substring", "subSequence").parameterCount(2), CallMatcher.instanceCall("java.lang.String", "substring").parameterCount(1)), (call, cnt) -> HardcodedContracts.getSubstringContracts(cnt == 2)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "isEmpty").parameterCount(0), ContractProvider.of(SpecialField.STRING_LENGTH.getEmptyContracts())).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "isEmpty").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "isEmpty").parameterCount(0)), ContractProvider.of(SpecialField.COLLECTION_SIZE.getEmptyContracts())).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "equalsIgnoreCase").parameterCount(1), ContractProvider.of(SpecialField.STRING_LENGTH.getEqualsContracts())).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Set", "equals").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.List", "equals").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.Map", "equals").parameterTypes("java.lang.Object")), ContractProvider.of(SpecialField.COLLECTION_SIZE.getEqualsContracts())).register((CallMatcher)CallMatcher.instanceCall("java.util.Collection", "contains").parameterCount(1), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnFalse()))).register((CallMatcher)CallMatcher.instanceCall("java.util.Map", "containsKey", "containsValue").parameterCount(1), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnFalse()))).register((CallMatcher)CallMatcher.instanceCall("java.util.List", "get", "remove").parameterTypes("int"), ContractProvider.of(HardcodedContracts.specialFieldRangeContract(0, RelationType.LT, SpecialField.COLLECTION_SIZE))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.SortedSet", "first", "last").parameterCount(0), CallMatcher.instanceCall("java.util.Deque", "getFirst", "getLast").parameterCount(0), CallMatcher.instanceCall("java.util.Queue", "element").parameterCount(0)), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), RelationType.EQ, ContractValue.zero(), ContractReturnValue.fail()))).register((CallMatcher)CallMatcher.staticCall("java.util.Arrays", "binarySearch", "fill", "parallelPrefix", "parallelSort", "sort", "spliterator", "stream"), (call, cnt) -> cnt >= 3 ? ARRAY_RANGE_CONTRACTS : null).register((CallMatcher)CallMatcher.staticCall("org.mockito.ArgumentMatchers", "argThat").parameterCount(1), ContractProvider.of((MethodContract)StandardMethodContract.fromText("_->_"))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Queue", "peek", "poll").parameterCount(0), CallMatcher.instanceCall("java.util.Deque", "peekFirst", "peekLast", "pollFirst", "pollLast").parameterCount(0)), (call, paramCount) -> Arrays.asList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnNull()), MethodContract.trivialContract(ContractReturnValue.returnAny()))).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "max").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Math", "max").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Integer", "max").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "max").parameterTypes("long", "long")), (call, paramCount) -> HardcodedContracts.mathMinMax(true)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "min").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Math", "min").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Integer", "min").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "min").parameterTypes("long", "long")), (call, paramCount) -> HardcodedContracts.mathMinMax(false)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "startsWith", "endsWith", "contains"), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0).specialField(SpecialField.STRING_LENGTH), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()), MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.EQ, ContractValue.qualifier(), ContractReturnValue.returnTrue()), MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.STRING_LENGTH), RelationType.LT, ContractValue.argument(0).specialField(SpecialField.STRING_LENGTH), ContractReturnValue.returnFalse()))).register((CallMatcher)CallMatcher.instanceCall("java.lang.Object", "equals").parameterTypes("java.lang.Object"), (call, paramCount) -> HardcodedContracts.equalsContracts(call)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2)), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.EQ, ContractValue.argument(1), ContractReturnValue.returnTrue()), StandardMethodContract.fromText("null,!null->false"), StandardMethodContract.fromText("!null,null->false"))).register((CallMatcher)CallMatcher.enumValues(), ContractProvider.of((MethodContract)StandardMethodContract.fromText("->new"))).register((CallMatcher)CallMatcher.staticCall("java.util.Objects", "requireNonNullElse").parameterCount(2), ContractProvider.of(StandardMethodContract.fromText("!null,_->param1"), StandardMethodContract.fromText("null,!null->param2"), StandardMethodContract.fromText("null,null->fail"))).register((CallMatcher)CallMatcher.staticCall("java.util.Objects", "requireNonNullElseGet").parameterCount(2), ContractProvider.of(StandardMethodContract.fromText("!null,_->param1"), StandardMethodContract.fromText("null,_->!null"))).register((CallMatcher)CallMatcher.staticCall("java.lang.System", "arraycopy"), (ContractProvider)((Object)((Function<PsiMethodCallExpression, ContractProvider>)expression2 -> HardcodedContracts.getArraycopyContract())));

    @NotNull
    private static ContractProvider getArraycopyContract() {
        ContractValue src = ContractValue.argument(0);
        ContractValue srcPos = ContractValue.argument(1);
        ContractValue dest = ContractValue.argument(2);
        ContractValue destPos = ContractValue.argument(3);
        ContractValue length = ContractValue.argument(4);
        ContractValue srcLength = src.specialField(SpecialField.ARRAY_LENGTH);
        ContractValue dstLength = dest.specialField(SpecialField.ARRAY_LENGTH);
        ContractProvider contractProvider = ContractProvider.of(MethodContract.singleConditionContract(srcPos, RelationType.GT, srcLength, ContractReturnValue.fail()), MethodContract.singleConditionContract(destPos, RelationType.GT, dstLength, ContractReturnValue.fail()), MethodContract.singleConditionContract(srcPos, RelationType.LT, ContractValue.zero(), ContractReturnValue.fail()), MethodContract.singleConditionContract(destPos, RelationType.LT, ContractValue.zero(), ContractReturnValue.fail()), MethodContract.singleConditionContract(length, RelationType.LT, ContractValue.zero(), ContractReturnValue.fail()), MethodContract.singleConditionContract(length, RelationType.GT, srcLength, ContractReturnValue.fail()), MethodContract.singleConditionContract(length, RelationType.GT, dstLength, ContractReturnValue.fail()));
        if (contractProvider == null) {
            HardcodedContracts.$$$reportNull$$$0(0);
        }
        return contractProvider;
    }

    public static List<MethodContract> getHardcodedContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call) {
        List<MethodContract> contracts2;
        PsiClass owner2;
        if (method == null) {
            HardcodedContracts.$$$reportNull$$$0(1);
        }
        if ((owner2 = method.getContainingClass()) == null || InjectedLanguageManager.getInstance((Project)owner2.getProject()).isInjectedFragment(owner2.getContainingFile())) {
            return Collections.emptyList();
        }
        int paramCount = method.getParameterList().getParametersCount();
        String className2 = owner2.getQualifiedName();
        if (className2 == null) {
            return Collections.emptyList();
        }
        ContractProvider provider = HARDCODED_CONTRACTS.mapFirst(method);
        if (provider != null && (contracts2 = provider.getContracts(call, paramCount)) != null) {
            return contracts2;
        }
        String methodName = method.getName();
        if ("org.apache.commons.lang.Validate".equals(className2) || "org.apache.commons.lang3.Validate".equals(className2) || "org.springframework.util.Assert".equals(className2)) {
            if (("isTrue".equals(methodName) || "state".equals(methodName)) && paramCount > 0) {
                StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[0] = StandardMethodContract.ValueConstraint.FALSE_VALUE;
                return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
            }
            if ("notNull".equals(methodName) && paramCount > 0) {
                StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[0] = StandardMethodContract.ValueConstraint.NULL_VALUE;
                StandardMethodContract contract = new StandardMethodContract(constraints, ContractReturnValue.fail());
                if (PsiType.VOID.equals((Object)method.getReturnType())) {
                    return Collections.singletonList(contract);
                }
                return Arrays.asList(contract, new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), ContractReturnValue.returnParameter(0)));
            }
        } else {
            if (HardcodedContracts.isJunit(className2) || HardcodedContracts.isTestng(className2) || className2.startsWith("com.google.common.truth.") || className2.startsWith("org.assertj.core.api.") || className2.equals("org.hamcrest.MatcherAssert") || className2.equals("org.hamcrest.junit.MatcherAssert")) {
                return HardcodedContracts.handleTestFrameworks(method, paramCount, className2, methodName, call);
            }
            if (TypeUtils.isOptional(owner2)) {
                if (OptionalUtil.OPTIONAL_GET.methodMatches(method) || "orElseThrow".equals(methodName)) {
                    return Collections.singletonList(HardcodedContracts.optionalAbsentContract(ContractReturnValue.fail()));
                }
                if ("isPresent".equals(methodName) && paramCount == 0) {
                    return Arrays.asList(HardcodedContracts.optionalAbsentContract(ContractReturnValue.returnFalse()), MethodContract.trivialContract(ContractReturnValue.returnTrue()));
                }
                if ("isEmpty".equals(methodName) && paramCount == 0) {
                    return Arrays.asList(HardcodedContracts.optionalAbsentContract(ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse()));
                }
            } else if (MethodUtils.isEquals(method)) {
                return Collections.singletonList(new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.returnFalse()));
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<MethodContract> getSubstringContracts(boolean endLimited) {
        ArrayList<MethodContract> contracts2 = new ArrayList<MethodContract>(3);
        contracts2.add(HardcodedContracts.specialFieldRangeContract(0, RelationType.LE, SpecialField.STRING_LENGTH));
        if (endLimited) {
            contracts2.add(HardcodedContracts.specialFieldRangeContract(1, RelationType.LE, SpecialField.STRING_LENGTH));
            contracts2.add(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LE.getNegated(), ContractValue.argument(1), ContractReturnValue.fail()));
        }
        ArrayList<MethodContract> arrayList = contracts2;
        if (arrayList == null) {
            HardcodedContracts.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    static MethodContract optionalAbsentContract(ContractReturnValue returnValue) {
        return MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.OPTIONAL_VALUE), RelationType.EQ, ContractValue.nullValue(), returnValue);
    }

    static MethodContract specialFieldRangeContract(int index, RelationType type2, SpecialField specialField) {
        return MethodContract.singleConditionContract(ContractValue.argument(index), type2.getNegated(), ContractValue.qualifier().specialField(specialField), ContractReturnValue.fail());
    }

    static List<MethodContract> mathMinMax(boolean isMax) {
        return Arrays.asList(MethodContract.singleConditionContract(ContractValue.argument(0), isMax ? RelationType.GT : RelationType.LT, ContractValue.argument(1), ContractReturnValue.returnParameter(0)), MethodContract.trivialContract(ContractReturnValue.returnParameter(1)));
    }

    private static List<MethodContract> equalsContracts(PsiMethodCallExpression call) {
        PsiType type2;
        PsiExpression qualifier;
        PsiExpression psiExpression = qualifier = call == null ? null : call.getMethodExpression().getQualifierExpression();
        if (qualifier != null && (type2 = qualifier.getType()) != null && (HardcodedContracts.knownAsEqualByReference(type2) || TypeConstraints.exact(type2).isComparedByEquals())) {
            return Arrays.asList(MethodContract.singleConditionContract(ContractValue.qualifier(), RelationType.EQ, ContractValue.argument(0), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse()));
        }
        return Arrays.asList(new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.qualifier(), RelationType.EQ, ContractValue.argument(0), ContractReturnValue.returnTrue()));
    }

    private static boolean knownAsEqualByReference(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return true;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        return psiClass != null && (psiClass.isEnum() || "java.lang.Class".equals(psiClass.getQualifiedName()));
    }

    private static boolean isJunit(String className2) {
        return className2.startsWith("junit.framework.") || className2.startsWith("org.junit.") || className2.equals("org.testng.AssertJUnit");
    }

    private static boolean isJunit5(String className2) {
        return className2.startsWith("org.junit.jupiter.");
    }

    private static boolean isTestng(String className2) {
        return className2.startsWith("org.testng.") && !className2.equals("org.testng.AssertJUnit");
    }

    private static List<MethodContract> handleTestFrameworks(PsiMethod method, int paramCount, String className2, String methodName, @Nullable PsiMethodCallExpression call) {
        if (("assertThat".equals(methodName) || "assumeThat".equals(methodName) || "that".equals(methodName)) && call != null) {
            return HardcodedContracts.handleAssertThat(paramCount, call);
        }
        if (!HardcodedContracts.isJunit(className2) && !HardcodedContracts.isTestng(className2)) {
            return Collections.emptyList();
        }
        boolean testng = HardcodedContracts.isTestng(className2);
        if ("fail".equals(methodName)) {
            return Collections.singletonList(StandardMethodContract.trivialContract(paramCount, ContractReturnValue.fail()));
        }
        if (paramCount == 0) {
            return Collections.emptyList();
        }
        int checkedParam = testng || HardcodedContracts.isJunit5(className2) ? 0 : paramCount - 1;
        PsiType type2 = Objects.requireNonNull(method.getParameterList().getParameter(checkedParam)).getType();
        StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
        if (("assertTrue".equals(methodName) || "assumeTrue".equals(methodName)) && PsiType.BOOLEAN.equals((Object)type2)) {
            constraints[checkedParam] = StandardMethodContract.ValueConstraint.FALSE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
        }
        if (("assertFalse".equals(methodName) || "assumeFalse".equals(methodName)) && PsiType.BOOLEAN.equals((Object)type2)) {
            constraints[checkedParam] = StandardMethodContract.ValueConstraint.TRUE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
        }
        if ("assertNull".equals(methodName) && TypeUtils.isJavaLangObject(type2)) {
            constraints[checkedParam] = StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
        }
        if ("assertNotNull".equals(methodName) && TypeUtils.isJavaLangObject(type2)) {
            return HardcodedContracts.failIfNull(checkedParam, paramCount, false);
        }
        return Collections.emptyList();
    }

    @Nullable
    private static StandardMethodContract.ValueConstraint constraintFromMatcher(PsiExpression expr2, boolean negate) {
        if (expr2 instanceof PsiMethodCallExpression) {
            String calledName = ((PsiMethodCallExpression)expr2).getMethodExpression().getReferenceName();
            PsiExpression[] args = ((PsiMethodCallExpression)expr2).getArgumentList().getExpressions();
            if (calledName == null) {
                return null;
            }
            switch (calledName) {
                case "array": 
                case "arrayWithSize": 
                case "arrayContaining": 
                case "arrayContainingInAnyOrder": 
                case "contains": 
                case "containsInAnyOrder": 
                case "containsString": 
                case "endsWith": 
                case "startsWith": 
                case "stringContainsInOrder": 
                case "empty": 
                case "emptyArray": 
                case "emptyCollectionOf": 
                case "emptyIterable": 
                case "emptyIterableOf": 
                case "hasEntry": 
                case "hasItem": 
                case "hasItems": 
                case "hasKey": 
                case "hasProperty": 
                case "hasSize": 
                case "hasToString": 
                case "hasValue": 
                case "hasXPath": {
                    return negate ? null : StandardMethodContract.ValueConstraint.NULL_VALUE;
                }
                case "notNullValue": {
                    return negate ? StandardMethodContract.ValueConstraint.NOT_NULL_VALUE : StandardMethodContract.ValueConstraint.NULL_VALUE;
                }
                case "nullValue": {
                    return negate ? StandardMethodContract.ValueConstraint.NULL_VALUE : StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
                }
                case "equalTo": {
                    if (args.length == 1) {
                        return HardcodedContracts.constraintFromLiteral(args[0], negate);
                    }
                    return null;
                }
                case "not": {
                    if (args.length == 1) {
                        return HardcodedContracts.constraintFromMatcher(args[0], !negate);
                    }
                    return null;
                }
                case "is": {
                    if (args.length == 1) {
                        StandardMethodContract.ValueConstraint fromMatcher = HardcodedContracts.constraintFromMatcher(args[0], negate);
                        return fromMatcher == null ? HardcodedContracts.constraintFromLiteral(args[0], negate) : fromMatcher;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    @Nullable
    private static StandardMethodContract.ValueConstraint constraintFromLiteral(PsiExpression arg, boolean negate) {
        if (!((arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)arg)) instanceof PsiLiteralExpression)) {
            return null;
        }
        Object value2 = ((PsiLiteralExpression)arg).getValue();
        if (value2 == null) {
            return negate ? StandardMethodContract.ValueConstraint.NULL_VALUE : StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
        }
        if (Boolean.TRUE.equals(value2)) {
            return negate ? StandardMethodContract.ValueConstraint.TRUE_VALUE : StandardMethodContract.ValueConstraint.FALSE_VALUE;
        }
        if (Boolean.FALSE.equals(value2)) {
            return negate ? StandardMethodContract.ValueConstraint.FALSE_VALUE : StandardMethodContract.ValueConstraint.TRUE_VALUE;
        }
        return null;
    }

    @NotNull
    private static List<MethodContract> handleAssertThat(int paramCount, @NotNull PsiMethodCallExpression call) {
        PsiExpression[] args;
        if (call == null) {
            HardcodedContracts.$$$reportNull$$$0(3);
        }
        if ((args = call.getArgumentList().getExpressions()).length == paramCount) {
            for (int i = 1; i < args.length; ++i) {
                StandardMethodContract.ValueConstraint constraint = HardcodedContracts.constraintFromMatcher(args[i], false);
                if (constraint == null) continue;
                StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[i - 1] = constraint;
                List<MethodContract> list = Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
                if (list == null) {
                    HardcodedContracts.$$$reportNull$$$0(4);
                }
                return list;
            }
            if (args.length == 1) {
                PsiType type2 = args[0].getType();
                List list = SyntaxTraverser.psiApi().parents((Object)call).skip(1).takeWhile(e -> !(e instanceof PsiStatement) && !(e instanceof PsiMember)).filter(PsiMethodCallExpression.class).filterMap(c -> HardcodedContracts.constraintFromAssertJMatcher(type2, c)).toList();
                if (list == null) {
                    HardcodedContracts.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        List<MethodContract> list = Collections.emptyList();
        if (list == null) {
            HardcodedContracts.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static MethodContract constraintFromAssertJMatcher(PsiType type2, PsiMethodCallExpression call) {
        if (!call.getArgumentList().isEmpty()) {
            return null;
        }
        String name2 = call.getMethodExpression().getReferenceName();
        if (name2 == null) {
            return null;
        }
        switch (name2) {
            case "isNotNull": {
                return new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.fail());
            }
            case "isNull": {
                return new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NOT_NULL_VALUE}, ContractReturnValue.fail());
            }
            case "isPresent": 
            case "isNotEmpty": {
                return HardcodedContracts.emptyCheck(type2, false);
            }
            case "isNotPresent": 
            case "isEmpty": {
                return HardcodedContracts.emptyCheck(type2, true);
            }
            case "isTrue": {
                return new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.FALSE_VALUE}, ContractReturnValue.fail());
            }
            case "isFalse": {
                return new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.TRUE_VALUE}, ContractReturnValue.fail());
            }
        }
        return null;
    }

    @Nullable
    private static MethodContract emptyCheck(PsiType type2, boolean isEmpty) {
        SpecialField field = SpecialField.fromQualifierType(type2);
        if (field == null) {
            return null;
        }
        return MethodContract.singleConditionContract(ContractValue.argument(0).specialField(field), isEmpty ? RelationType.NE : RelationType.EQ, field == SpecialField.OPTIONAL_VALUE ? ContractValue.nullValue() : ContractValue.zero(), ContractReturnValue.fail());
    }

    @NotNull
    private static List<MethodContract> failIfNull(int argIndex, int argCount, boolean returnArg) {
        StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(argCount);
        constraints[argIndex] = StandardMethodContract.ValueConstraint.NULL_VALUE;
        StandardMethodContract failContract = new StandardMethodContract(constraints, ContractReturnValue.fail());
        if (returnArg) {
            List<MethodContract> list = Arrays.asList(failContract, StandardMethodContract.trivialContract(argCount, ContractReturnValue.returnParameter(argIndex)));
            if (list == null) {
                HardcodedContracts.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<MethodContract> list = Collections.singletonList(failContract);
        if (list == null) {
            HardcodedContracts.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static boolean isHardcodedPure(PsiMethod method) {
        PsiParameter[] parameters2;
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String className2 = aClass.getQualifiedName();
        if (className2 == null) {
            return false;
        }
        String name2 = method.getName();
        if ("java.util.Objects".equals(className2) && "requireNonNull".equals(name2) && (parameters2 = method.getParameterList().getParameters()).length == 2 && parameters2[1].getType().getCanonicalText().contains("Supplier")) {
            return false;
        }
        if ("remove".equals(name2)) {
            return false;
        }
        if ("java.lang.System".equals(className2)) {
            return false;
        }
        if ("java.util.Arrays".equals(className2)) {
            return name2.equals("binarySearch") || name2.equals("spliterator") || name2.equals("stream");
        }
        return !QUEUE_POLL.methodMatches(method);
    }

    public static boolean hasHardcodedContracts(@Nullable PsiElement element) {
        if (element instanceof PsiMethod) {
            return !HardcodedContracts.getHardcodedContracts((PsiMethod)element, null).isEmpty();
        }
        if (element instanceof PsiParameter) {
            PsiElement parent = element.getParent();
            return parent != null && HardcodedContracts.hasHardcodedContracts(parent.getParent());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/HardcodedContracts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArraycopyContract";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/HardcodedContracts";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstringContracts";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "handleAssertThat";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "failIfNull";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHardcodedContracts";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleAssertThat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface ContractProvider {
        public List<MethodContract> getContracts(PsiMethodCallExpression var1, int var2);

        public static ContractProvider of(MethodContract contract) {
            return (call, paramCount) -> Collections.singletonList(contract);
        }

        public static ContractProvider of(MethodContract ... contracts2) {
            return (call, paramCount) -> Arrays.asList(contracts2);
        }
    }
}

