/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StateMerger {
    private static final int COMPLEXITY_LIMIT = 250000;
    private final Map<DfaMemoryStateImpl, Set<Fact>> myFacts = ContainerUtil.newIdentityHashMap();
    private final Map<DfaMemoryState, Map<DfaVariableValue, DfaMemoryStateImpl>> myCopyCache = ContainerUtil.newIdentityHashMap();

    StateMerger() {
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByFacts(@NotNull List<DfaMemoryStateImpl> states) {
        if (states == null) {
            StateMerger.$$$reportNull$$$0(0);
        }
        MultiMap<Fact, DfaMemoryStateImpl> statesByFact = this.createFactToStateMap(states);
        Set facts = statesByFact.keySet();
        int complexity = 0;
        for (Fact fact : facts) {
            Collection positiveStates;
            Collection negativeStates;
            if (fact.myPositive || (negativeStates = statesByFact.get((Object)fact)).size() == states.size() || (positiveStates = statesByFact.get((Object)fact.getPositiveCounterpart())).isEmpty()) continue;
            ProgressManager.checkCanceled();
            MultiMap<CompactFactSet, DfaMemoryStateImpl> statesByUnrelatedFacts1 = this.mapByUnrelatedFacts(fact, negativeStates, facts);
            MultiMap<CompactFactSet, DfaMemoryStateImpl> statesByUnrelatedFacts2 = this.mapByUnrelatedFacts(fact, positiveStates, facts);
            if ((complexity += StreamEx.of((Object[])new MultiMap[]{statesByUnrelatedFacts1, statesByUnrelatedFacts2}).flatCollection(MultiMap::keySet).mapToInt(CompactFactSet::size).sum()) > 250000) {
                return null;
            }
            Replacements replacements = new Replacements(states);
            for (Map.Entry entry : statesByUnrelatedFacts1.entrySet()) {
                Collection group1 = (Collection)entry.getValue();
                Collection group2 = statesByUnrelatedFacts2.get(entry.getKey());
                if (group1.isEmpty() || group2.isEmpty()) continue;
                ArrayList group = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable)group1, (Iterable)group2));
                replacements.stripAndMerge(group, fact);
            }
            if (!replacements.hasMerges()) continue;
            return replacements.getMergeResult();
        }
        return null;
    }

    @NotNull
    private MultiMap<Fact, DfaMemoryStateImpl> createFactToStateMap(@NotNull List<DfaMemoryStateImpl> states) {
        if (states == null) {
            StateMerger.$$$reportNull$$$0(1);
        }
        MultiMap statesByFact = MultiMap.createLinked();
        HashMap<DfaTypeValue, Map<DfaVariableValue, Set<DfaMemoryStateImpl>>> constantVars = new HashMap<DfaTypeValue, Map<DfaVariableValue, Set<DfaMemoryStateImpl>>>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            for (Fact fact : this.getFacts(state)) {
                statesByFact.putValue((Object)fact, (Object)state);
                DfaTypeValue value2 = fact.comparedToConstant();
                if (value2 == null) continue;
                constantVars.computeIfAbsent(value2, k -> new HashMap()).computeIfAbsent(fact.myVar, k -> ContainerUtil.newIdentityTroveSet()).add(state);
            }
        }
        for (Fact fact : new ArrayList(statesByFact.keySet())) {
            if (fact.myPositive) continue;
            Collection negativeStates = statesByFact.get((Object)fact);
            Collection positiveStates = statesByFact.get((Object)fact.getPositiveCounterpart());
            if (!StateMerger.isComparisonOfVariablesComparedWithConstant(fact, constantVars, positiveStates, negativeStates)) continue;
            statesByFact.remove((Object)fact);
            statesByFact.remove((Object)fact.getPositiveCounterpart());
        }
        MultiMap multiMap = statesByFact;
        if (multiMap == null) {
            StateMerger.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    private static boolean isComparisonOfVariablesComparedWithConstant(Fact fact, Map<DfaTypeValue, Map<DfaVariableValue, Set<DfaMemoryStateImpl>>> constantVars, Collection<DfaMemoryStateImpl> positiveStates, Collection<DfaMemoryStateImpl> negativeStates) {
        if (!(fact instanceof EqualityFact) || !(((EqualityFact)fact).myArg instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var1 = fact.myVar;
        DfaVariableValue var2 = (DfaVariableValue)((EqualityFact)fact).myArg;
        for (Map<DfaVariableValue, Set<DfaMemoryStateImpl>> map2 : constantVars.values()) {
            Set<DfaMemoryStateImpl> states1 = map2.get(var1);
            Set<DfaMemoryStateImpl> states2 = map2.get(var2);
            if (states1 == null || states2 == null || !states1.containsAll(negativeStates) || !states1.containsAll(positiveStates) || !states2.containsAll(negativeStates) || !states2.containsAll(positiveStates)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private MultiMap<CompactFactSet, DfaMemoryStateImpl> mapByUnrelatedFacts(@NotNull Fact fact, @NotNull Collection<DfaMemoryStateImpl> states, @NotNull Set<Fact> interestingFacts) {
        if (fact == null) {
            StateMerger.$$$reportNull$$$0(3);
        }
        if (states == null) {
            StateMerger.$$$reportNull$$$0(4);
        }
        if (interestingFacts == null) {
            StateMerger.$$$reportNull$$$0(5);
        }
        MultiMap statesByUnrelatedFacts = MultiMap.createLinked();
        for (DfaMemoryStateImpl state : states) {
            statesByUnrelatedFacts.putValue((Object)this.getUnrelatedFacts(fact, state, interestingFacts), (Object)state);
        }
        MultiMap multiMap = statesByUnrelatedFacts;
        if (multiMap == null) {
            StateMerger.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    @NotNull
    private CompactFactSet getUnrelatedFacts(@NotNull Fact fact, @NotNull DfaMemoryStateImpl state, @NotNull Set<Fact> interestingFacts) {
        if (fact == null) {
            StateMerger.$$$reportNull$$$0(7);
        }
        if (state == null) {
            StateMerger.$$$reportNull$$$0(8);
        }
        if (interestingFacts == null) {
            StateMerger.$$$reportNull$$$0(9);
        }
        ArrayList<Fact> result = new ArrayList<Fact>();
        for (Fact other : this.getFacts(state)) {
            if (fact.invalidatesFact(other) || !interestingFacts.contains(other)) continue;
            result.add(other);
        }
        return new CompactFactSet(state.getFactory(), result);
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByRanges(List<DfaMemoryStateImpl> states) {
        Map<DfaVariableValue, Set<LongRangeSet>> ranges2 = StateMerger.createRangeMap(states);
        boolean changed = false;
        for (Map.Entry<DfaVariableValue, Set<LongRangeSet>> entry : ranges2.entrySet()) {
            List<DfaMemoryStateImpl> updated;
            if (entry.getValue().size() <= 1 || (updated = this.mergeIndependentRanges(states, entry.getKey())) == null) continue;
            states = updated;
            changed = true;
        }
        return changed ? states : null;
    }

    @NotNull
    private static Map<DfaVariableValue, Set<LongRangeSet>> createRangeMap(List<DfaMemoryStateImpl> states) {
        LinkedHashMap<DfaVariableValue, Set<LongRangeSet>> ranges2 = new LinkedHashMap<DfaVariableValue, Set<LongRangeSet>>();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            state.forVariableStates((varValue, varState) -> {
                DfType dfType = varState.myDfType;
                if (dfType instanceof DfIntegralType) {
                    ranges2.computeIfAbsent((DfaVariableValue)varValue, k -> new HashSet()).add(((DfIntegralType)dfType).getRange());
                }
            });
        }
        LinkedHashMap<DfaVariableValue, Set<LongRangeSet>> linkedHashMap = ranges2;
        if (linkedHashMap == null) {
            StateMerger.$$$reportNull$$$0(10);
        }
        return linkedHashMap;
    }

    @Nullable
    private List<DfaMemoryStateImpl> mergeIndependentRanges(List<DfaMemoryStateImpl> states, DfaVariableValue var) {
        ProgressManager.checkCanceled();
        LinkedHashMap<DfaMemoryStateImpl, List> merged = new LinkedHashMap<DfaMemoryStateImpl, List>();
        for (DfaMemoryStateImpl state : states) {
            DfaVariableState variableState = state.getVariableState(var);
            if (!(variableState.myDfType instanceof DfIntegralType)) {
                return null;
            }
            merged.computeIfAbsent(this.copyWithoutVar(state, var), k -> new ArrayList()).add(state);
        }
        if (merged.size() == states.size()) {
            return null;
        }
        return StreamEx.ofValues(merged).mapPartial(list -> list.stream().reduce((a, b) -> {
            assert (a.getMergeabilityKey().equals(b.getMergeabilityKey()));
            a.merge((DfaMemoryStateImpl)b);
            return a;
        })).toList();
    }

    @NotNull
    private DfaMemoryStateImpl copyWithoutVar(@NotNull DfaMemoryStateImpl state, @NotNull DfaVariableValue var) {
        Map map2;
        DfaMemoryStateImpl copy;
        if (state == null) {
            StateMerger.$$$reportNull$$$0(11);
        }
        if (var == null) {
            StateMerger.$$$reportNull$$$0(12);
        }
        if ((copy = (DfaMemoryStateImpl)(map2 = this.myCopyCache.computeIfAbsent(state, k -> ContainerUtil.newIdentityHashMap())).get(var)) == null) {
            copy = state.createCopy();
            copy.setVariableState(var, copy.createVariableState(var));
            copy.flushVariable(var);
            map2.put(var, copy);
        }
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            StateMerger.$$$reportNull$$$0(13);
        }
        return dfaMemoryStateImpl;
    }

    @NotNull
    private Set<Fact> getFacts(@NotNull DfaMemoryStateImpl state) {
        if (state == null) {
            StateMerger.$$$reportNull$$$0(14);
        }
        Set set = this.myFacts.computeIfAbsent(state, StateMerger::doGetFacts);
        if (set == null) {
            StateMerger.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    private static Set<Fact> doGetFacts(DfaMemoryStateImpl state) {
        LinkedHashSet<Fact> result = new LinkedHashSet<Fact>();
        for (EqClass eqClass : state.getNonTrivialEqClasses()) {
            int size = eqClass.size();
            for (int i = 0; i < size; ++i) {
                DfaVariableValue var2 = eqClass.getVariable(i);
                for (int j = i + 1; j < size; ++j) {
                    DfaVariableValue eqVar = eqClass.getVariable(j);
                    result.add(Fact.createEqualityFact(var2, eqVar));
                }
            }
        }
        for (DistinctPairSet.DistinctPair classPair : state.getDistinctClassPairs()) {
            EqClass class1 = classPair.getFirst();
            EqClass class2 = classPair.getSecond();
            for (DfaVariableValue var1 : class1) {
                for (DfaVariableValue var2 : class2) {
                    result.add(new EqualityFact(var1, false, var2));
                    result.add(new EqualityFact(var2, false, var1));
                }
            }
        }
        DfaValueFactory factory = state.getFactory();
        state.forVariableStates((var, varState) -> {
            Set notValues;
            TypeConstraint typeConstraint = varState.getTypeConstraint();
            typeConstraint.instanceOfTypes().map(type2 -> new InstanceofFact((DfaVariableValue)var, true, factory.fromDfType(type2.asDfType()))).into((Collection)result);
            typeConstraint.notInstanceOfTypes().map(type2 -> new InstanceofFact((DfaVariableValue)var, false, factory.fromDfType(type2.asDfType()))).into((Collection)result);
            DfType dfType = varState.myDfType;
            if (dfType instanceof DfConstantType) {
                result.add(new EqualityFact((DfaVariableValue)var, true, var.getFactory().fromDfType(dfType)));
            }
            if (dfType instanceof DfAntiConstantType && !(notValues = ((DfAntiConstantType)dfType).getNotValues()).isEmpty() && var.getType() != null) {
                for (Object notValue : notValues) {
                    result.add(new EqualityFact((DfaVariableValue)var, false, var.getFactory().fromDfType(DfTypes.constant(notValue, var.getType()))));
                }
            }
        });
        LinkedHashSet<Fact> linkedHashSet = result;
        if (linkedHashSet == null) {
            StateMerger.$$$reportNull$$$0(16);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StateMerger";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fact";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interestingFacts";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFactToStateMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "mapByUnrelatedFacts";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithoutVar";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacts";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeByFacts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFactToStateMap";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mapByUnrelatedFacts";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnrelatedFacts";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyWithoutVar";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Replacements {
        @NotNull
        private final List<DfaMemoryStateImpl> myAllStates;
        private final Set<DfaMemoryStateImpl> myRemovedStates;
        private final List<DfaMemoryStateImpl> myMerged;

        private Replacements(@NotNull List<DfaMemoryStateImpl> allStates) {
            if (allStates == null) {
                Replacements.$$$reportNull$$$0(0);
            }
            this.myRemovedStates = ContainerUtil.newIdentityTroveSet();
            this.myMerged = new ArrayList<DfaMemoryStateImpl>();
            this.myAllStates = allStates;
        }

        private boolean hasMerges() {
            return !this.myMerged.isEmpty();
        }

        @Nullable
        private List<DfaMemoryStateImpl> getMergeResult() {
            if (this.hasMerges()) {
                ArrayList<DfaMemoryStateImpl> result = new ArrayList<DfaMemoryStateImpl>(this.myMerged);
                for (DfaMemoryStateImpl state : this.myAllStates) {
                    if (this.myRemovedStates.contains(state)) continue;
                    result.add(state);
                }
                return result;
            }
            return null;
        }

        private void stripAndMerge(@NotNull Collection<DfaMemoryStateImpl> group, @NotNull Fact fact) {
            if (group == null) {
                Replacements.$$$reportNull$$$0(1);
            }
            if (fact == null) {
                Replacements.$$$reportNull$$$0(2);
            }
            if (group.size() <= 1) {
                return;
            }
            MultiMap strippedToOriginals = MultiMap.create();
            for (DfaMemoryStateImpl original : group) {
                DfaMemoryStateImpl copy = original.createCopy();
                fact.removeFromState(copy);
                strippedToOriginals.putValue((Object)copy, (Object)original);
            }
            for (Map.Entry entry : strippedToOriginals.entrySet()) {
                Collection merged = (Collection)entry.getValue();
                if (merged.size() <= 1) continue;
                DfaMemoryStateImpl stripped = (DfaMemoryStateImpl)entry.getKey();
                fact.restoreCommonState(stripped, merged);
                for (DfaMemoryStateImpl state : merged) {
                    stripped.afterMerge(state);
                }
                this.myRemovedStates.addAll(merged);
                this.myMerged.add(stripped);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allStates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fact";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger$Replacements";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stripAndMerge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class InstanceofFact
    extends Fact {
        @NotNull
        private final DfaTypeValue myType;

        private InstanceofFact(@NotNull DfaVariableValue var, boolean positive, @NotNull DfaTypeValue type2) {
            if (var == null) {
                InstanceofFact.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                InstanceofFact.$$$reportNull$$$0(1);
            }
            super(positive, var, (var.hashCode() * 31 + type2.hashCode()) * 31 + (positive ? 1 : 0));
            this.myType = type2;
        }

        @Override
        int packHigh() {
            return -this.myType.getID();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InstanceofFact)) {
                return false;
            }
            InstanceofFact fact = (InstanceofFact)o;
            return this.myPositive == fact.myPositive && this.myType == fact.myType && this.myVar == fact.myVar;
        }

        public String toString() {
            return this.myVar + (this.myPositive ? " IS " : " IS NOT ") + this.myType;
        }

        @Override
        @NotNull
        Fact getPositiveCounterpart() {
            return new InstanceofFact(this.myVar, true, this.myType);
        }

        @Override
        boolean invalidatesFact(@NotNull Fact another) {
            if (another == null) {
                InstanceofFact.$$$reportNull$$$0(2);
            }
            return another instanceof InstanceofFact && this.myType == ((InstanceofFact)another).myType && this.myVar == another.myVar;
        }

        @Override
        void removeFromState(@NotNull DfaMemoryStateImpl state) {
            if (state == null) {
                InstanceofFact.$$$reportNull$$$0(3);
            }
            DfaVariableState varState = state.getVariableState(this.myVar);
            state.setVariableState(this.myVar, varState.withoutType(TypeConstraint.fromDfType(this.myType.getDfType())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger$InstanceofFact";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invalidatesFact";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeFromState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class EqualityFact
    extends Fact {
        @NotNull
        private final DfaValue myArg;

        private EqualityFact(@NotNull DfaVariableValue var, boolean positive, @NotNull DfaValue arg) {
            if (var == null) {
                EqualityFact.$$$reportNull$$$0(0);
            }
            if (arg == null) {
                EqualityFact.$$$reportNull$$$0(1);
            }
            super(positive, var, (var.hashCode() * 31 + arg.hashCode()) * 31 + (positive ? 1 : 0));
            this.myArg = arg;
        }

        @Override
        int packHigh() {
            return this.myArg.getID();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EqualityFact)) {
                return false;
            }
            EqualityFact fact = (EqualityFact)o;
            return this.myArg == fact.myArg && this.myVar == fact.myVar && this.myPositive == fact.myPositive;
        }

        public String toString() {
            return this.myVar + (this.myPositive ? " EQ " : " NE ") + this.myArg;
        }

        @Override
        DfaTypeValue comparedToConstant() {
            return this.myArg instanceof DfaTypeValue ? (DfaTypeValue)this.myArg : null;
        }

        @Override
        @NotNull
        EqualityFact getPositiveCounterpart() {
            return new EqualityFact(this.myVar, true, this.myArg);
        }

        @Override
        boolean invalidatesFact(@NotNull Fact another) {
            if (another == null) {
                EqualityFact.$$$reportNull$$$0(2);
            }
            if (!(another instanceof EqualityFact)) {
                return false;
            }
            return this.myVar == another.myVar || this.myVar == ((EqualityFact)another).myArg;
        }

        @Override
        void removeFromState(@NotNull DfaMemoryStateImpl state) {
            DfType dfType;
            if (state == null) {
                EqualityFact.$$$reportNull$$$0(3);
            }
            if ((dfType = state.getDfType(this.myVar)) instanceof DfConstantType || dfType instanceof DfAntiConstantType && ((DfAntiConstantType)dfType).getNotValues().size() == 1) {
                state.flushVariable(this.myVar);
                if (this.myArg.getDfType() == DfTypes.NULL) {
                    state.meetDfType(this.myVar, DfaNullability.NULLABLE.asDfType());
                }
            } else {
                state.removeEquivalence(this.myVar);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arg";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger$EqualityFact";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invalidatesFact";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeFromState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class Fact {
        final boolean myPositive;
        @NotNull
        final DfaVariableValue myVar;
        private final int myHash;

        protected Fact(boolean positive, @NotNull DfaVariableValue var, int hash) {
            if (var == null) {
                Fact.$$$reportNull$$$0(0);
            }
            this.myPositive = positive;
            this.myVar = var;
            this.myHash = hash;
        }

        private int packLow() {
            return this.myPositive ? this.myVar.getID() : -this.myVar.getID();
        }

        abstract int packHigh();

        long pack() {
            int lo = this.packLow();
            int hi = this.packHigh();
            return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
        }

        public final int hashCode() {
            return this.myHash;
        }

        @NotNull
        abstract Fact getPositiveCounterpart();

        DfaTypeValue comparedToConstant() {
            return null;
        }

        abstract boolean invalidatesFact(@NotNull Fact var1);

        abstract void removeFromState(@NotNull DfaMemoryStateImpl var1);

        void restoreCommonState(DfaMemoryStateImpl stripped, Collection<DfaMemoryStateImpl> merged) {
            DfType commonType = (DfType)StreamEx.of(merged).map(s -> s.getDfType(this.myVar)).foldLeft((Object)DfTypes.BOTTOM, DfType::join);
            stripped.meetDfType(this.myVar, commonType);
        }

        @NotNull
        static EqualityFact createEqualityFact(@NotNull DfaVariableValue var, @NotNull DfaValue val) {
            if (var == null) {
                Fact.$$$reportNull$$$0(1);
            }
            if (val == null) {
                Fact.$$$reportNull$$$0(2);
            }
            if (val instanceof DfaVariableValue && val.getID() < var.getID()) {
                return new EqualityFact((DfaVariableValue)val, true, var);
            }
            return new EqualityFact(var, true, val);
        }

        static Fact unpack(DfaValueFactory factory, long packed) {
            int lo = (int)(packed & 0xFFFFFFFFL);
            int hi = (int)(packed >> 32);
            boolean positive = lo >= 0;
            DfaVariableValue var = (DfaVariableValue)factory.getValue(Math.abs(lo));
            if (hi >= 0) {
                return new EqualityFact(var, positive, factory.getValue(hi));
            }
            return new InstanceofFact(var, positive, (DfaTypeValue)factory.getValue(-hi));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/StateMerger$Fact";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createEqualityFact";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class CompactFactSet {
        private final long[] myData;
        private final int myHashCode;
        private final DfaValueFactory myFactory;

        CompactFactSet(DfaValueFactory factory, Collection<Fact> facts) {
            this.myData = facts.stream().mapToLong(Fact::pack).toArray();
            Arrays.sort(this.myData);
            this.myHashCode = Arrays.hashCode(this.myData);
            this.myFactory = factory;
        }

        public int size() {
            return this.myData.length;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CompactFactSet)) {
                return false;
            }
            CompactFactSet other = (CompactFactSet)obj;
            return this.myHashCode == other.myHashCode && Arrays.equals(this.myData, other.myData);
        }

        public String toString() {
            return LongStreamEx.of((long[])this.myData).mapToObj(f -> Fact.unpack(this.myFactory, f)).joining((CharSequence)", ", (CharSequence)"{", (CharSequence)"}");
        }
    }
}

